/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.data;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Objects;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.Region;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.redis.internal.data.AbstractRedisData;
import org.apache.geode.redis.internal.data.ByteArrayWrapper;
import org.apache.geode.redis.internal.data.RedisData;
import org.apache.geode.redis.internal.data.RedisDataType;
import org.apache.geode.redis.internal.data.RedisKey;
import org.apache.geode.redis.internal.delta.AppendDeltaInfo;
import org.apache.geode.redis.internal.delta.DeltaInfo;
import org.apache.geode.redis.internal.executor.string.SetOptions;
import org.apache.geode.redis.internal.netty.Coder;

public class RedisString
extends AbstractRedisData {
    private int appendSequence;
    private ByteArrayWrapper value;
    private static final byte[] bitcountTable = new byte[]{0, 1, 1, 2, 1, 2, 2, 3, 1, 2, 2, 3, 2, 3, 3, 4, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8};

    public RedisString(ByteArrayWrapper value) {
        this.value = value;
    }

    public RedisString() {
    }

    public ByteArrayWrapper get() {
        return new ByteArrayWrapper(this.value.toBytes());
    }

    public void set(ByteArrayWrapper value) {
        this.valueSet(value);
    }

    public int append(ByteArrayWrapper appendValue, Region<RedisKey, RedisData> region, RedisKey key) {
        this.valueAppend(appendValue.toBytes());
        ++this.appendSequence;
        this.storeChanges(region, key, new AppendDeltaInfo(appendValue.toBytes(), this.appendSequence));
        return this.value.length();
    }

    public long incr(Region<RedisKey, RedisData> region, RedisKey key) throws NumberFormatException, ArithmeticException {
        long longValue = this.parseValueAsLong();
        if (longValue == Long.MAX_VALUE) {
            throw new ArithmeticException("increment or decrement would overflow");
        }
        this.valueSetBytes(Coder.longToBytes(++longValue));
        region.put((Object)key, (Object)this);
        return longValue;
    }

    public long incrby(Region<RedisKey, RedisData> region, RedisKey key, long increment) throws NumberFormatException, ArithmeticException {
        long longValue = this.parseValueAsLong();
        if (longValue >= 0L && increment > Long.MAX_VALUE - longValue) {
            throw new ArithmeticException("increment or decrement would overflow");
        }
        this.valueSetBytes(Coder.longToBytes(longValue += increment));
        region.put((Object)key, (Object)this);
        return longValue;
    }

    public BigDecimal incrbyfloat(Region<RedisKey, RedisData> region, RedisKey key, BigDecimal increment) throws NumberFormatException, ArithmeticException {
        BigDecimal bigDecimalValue = this.parseValueAsBigDecimal();
        bigDecimalValue = bigDecimalValue.add(increment);
        this.valueSetBytes(Coder.bigDecimalToBytes(bigDecimalValue));
        region.put((Object)key, (Object)this);
        return bigDecimalValue;
    }

    public long decrby(Region<RedisKey, RedisData> region, RedisKey key, long decrement) {
        long longValue = this.parseValueAsLong();
        if (longValue <= 0L && -decrement < Long.MIN_VALUE - longValue) {
            throw new ArithmeticException("increment or decrement would overflow");
        }
        this.valueSetBytes(Coder.longToBytes(longValue -= decrement));
        region.put((Object)key, (Object)this);
        return longValue;
    }

    public long decr(Region<RedisKey, RedisData> region, RedisKey key) throws NumberFormatException, ArithmeticException {
        long longValue = this.parseValueAsLong();
        if (longValue == Long.MIN_VALUE) {
            throw new ArithmeticException("increment or decrement would overflow");
        }
        this.valueSetBytes(Coder.longToBytes(--longValue));
        region.put((Object)key, (Object)this);
        return longValue;
    }

    private long parseValueAsLong() {
        try {
            return Long.parseLong(this.value.toString());
        }
        catch (NumberFormatException ex) {
            throw new NumberFormatException("value is not an integer or out of range");
        }
    }

    private BigDecimal parseValueAsBigDecimal() {
        String valueString = this.value.toString();
        if (valueString.contains(" ")) {
            throw new NumberFormatException("value is not a valid float");
        }
        try {
            return new BigDecimal(valueString);
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("value is not a valid float");
        }
    }

    public ByteArrayWrapper getrange(long start, long end) {
        int boundedEnd;
        int length = this.value.length();
        int boundedStart = this.getBoundedStartIndex(start, length);
        if (boundedStart > (boundedEnd = this.getBoundedEndIndex(end, length)) || boundedStart == length) {
            return new ByteArrayWrapper(new byte[0]);
        }
        if (boundedEnd != length) {
            ++boundedEnd;
        }
        byte[] returnRange = Arrays.copyOfRange(this.value.toBytes(), boundedStart, boundedEnd);
        return new ByteArrayWrapper(returnRange);
    }

    public int setrange(Region<RedisKey, RedisData> region, RedisKey key, int offset, byte[] valueToAdd) {
        if (valueToAdd.length == 0) {
            return this.value.length();
        }
        int totalLength = offset + valueToAdd.length;
        byte[] bytes = this.value.toBytes();
        if (totalLength < bytes.length) {
            System.arraycopy(valueToAdd, 0, bytes, offset, valueToAdd.length);
        } else {
            byte[] newBytes = Arrays.copyOf(bytes, totalLength);
            System.arraycopy(valueToAdd, 0, newBytes, offset, valueToAdd.length);
            this.valueSetBytes(newBytes);
        }
        region.put((Object)key, (Object)this);
        return this.value.length();
    }

    private int getBoundedStartIndex(long index, int size) {
        if (index >= 0L) {
            return (int)Math.min(index, (long)size);
        }
        return (int)Math.max(index + (long)size, 0L);
    }

    private int getBoundedEndIndex(long index, int size) {
        if (index >= 0L) {
            return (int)Math.min(index, (long)size);
        }
        return (int)Math.max(index + (long)size, -1L);
    }

    public int bitpos(Region<RedisKey, RedisData> region, RedisKey key, int bit, int start, Integer end) {
        boolean endSet;
        int length = this.value.length();
        if (length == 0) {
            return -1;
        }
        boolean bl = endSet = end != null;
        if (!endSet) {
            end = length - 1;
        }
        if (start < 0) {
            start += length;
        }
        if (end < 0) {
            end = end + length;
        }
        if (start < 0) {
            start = 0;
        }
        if (end < 0) {
            end = 0;
        }
        if (start > length) {
            start = length - 1;
        }
        if (end > length) {
            end = length - 1;
        }
        if (end < start) {
            return -1;
        }
        byte[] bytes = this.value.toBytes();
        for (int i = start; i <= end; ++i) {
            byte cByte = bytes[i];
            for (int j = 0; j < 8; ++j) {
                int cBit = (cByte & 128 >> j) >> 7 - j;
                if (cBit != bit) continue;
                return 8 * i + j;
            }
        }
        if (bit == 0 && !endSet) {
            return length * 8;
        }
        return -1;
    }

    public long bitcount(int start, int end) {
        if (start < 0) {
            start += this.value.length();
        }
        if (end < 0) {
            end += this.value.length();
        }
        if (start < 0) {
            start = 0;
        }
        if (end < 0) {
            end = 0;
        }
        if (end > this.value.length() - 1) {
            end = this.value.length() - 1;
        }
        if (end < start || start >= this.value.length()) {
            return 0L;
        }
        long setBits = 0L;
        for (int j = start; j <= end; ++j) {
            setBits += (long)bitcountTable[0xFF & this.value.toBytes()[j]];
        }
        return setBits;
    }

    public long bitcount() {
        return this.bitcount(0, this.value.length() - 1);
    }

    public int strlen() {
        return this.value.length();
    }

    public int getbit(int offset) {
        if (offset < 0) {
            offset += this.value.length() * 8;
        }
        if (offset < 0 || offset > this.value.length() * 8) {
            return 0;
        }
        int byteIndex = offset / 8;
        offset %= 8;
        if (byteIndex >= this.value.length()) {
            return 0;
        }
        return (this.value.toBytes()[byteIndex] & 128 >> offset) >> 7 - offset;
    }

    public int setbit(Region<RedisKey, RedisData> region, RedisKey key, int bitValue, int byteIndex, byte bitIndex) {
        byte[] bytes = this.value.toBytes();
        int returnBit = byteIndex < bytes.length ? (bytes[byteIndex] & 128 >> bitIndex) >> 7 - bitIndex : 0;
        if (byteIndex < bytes.length) {
            bytes[byteIndex] = bitValue == 1 ? (byte)(bytes[byteIndex] | 128 >> bitIndex) : (byte)(bytes[byteIndex] & ~(128 >> bitIndex));
        } else {
            byte[] newBytes = new byte[byteIndex + 1];
            System.arraycopy(bytes, 0, newBytes, 0, bytes.length);
            newBytes[byteIndex] = bitValue == 1 ? (byte)(newBytes[byteIndex] | 128 >> bitIndex) : (byte)(newBytes[byteIndex] & ~(128 >> bitIndex));
            this.valueSetBytes(newBytes);
        }
        region.put((Object)key, (Object)this);
        return returnBit;
    }

    @Override
    public synchronized void toData(DataOutput out, SerializationContext context) throws IOException {
        super.toData(out, context);
        DataSerializer.writePrimitiveInt((int)this.appendSequence, (DataOutput)out);
        DataSerializer.writeByteArray((byte[])this.value.toBytes(), (DataOutput)out);
    }

    @Override
    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        super.fromData(in, context);
        this.appendSequence = DataSerializer.readPrimitiveInt((DataInput)in);
        this.value = new ByteArrayWrapper(DataSerializer.readByteArray((DataInput)in));
    }

    public int getDSFID() {
        return 2187;
    }

    @Override
    protected void applyDelta(DeltaInfo deltaInfo) {
        AppendDeltaInfo appendDeltaInfo = (AppendDeltaInfo)deltaInfo;
        byte[] appendBytes = appendDeltaInfo.getBytes();
        if (this.value == null) {
            this.value = new ByteArrayWrapper(appendBytes);
            this.appendSequence = appendDeltaInfo.getSequence();
        } else if (appendDeltaInfo.getSequence() == this.appendSequence + 1) {
            this.valueAppend(appendBytes);
            this.appendSequence = appendDeltaInfo.getSequence();
        } else if (appendDeltaInfo.getSequence() != this.appendSequence) {
            throw new RuntimeException("APPEND sequence mismatch - delta sequence number: " + appendDeltaInfo.getSequence() + " current sequence number: " + this.appendSequence);
        }
    }

    @Override
    public RedisDataType getType() {
        return RedisDataType.REDIS_STRING;
    }

    public ByteArrayWrapper getset(Region<RedisKey, RedisData> region, RedisKey key, ByteArrayWrapper newValue) {
        ByteArrayWrapper result = this.value;
        this.set(newValue);
        this.persistNoDelta();
        region.put((Object)key, (Object)this);
        return result;
    }

    @Override
    protected boolean removeFromRegion() {
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RedisString)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RedisString that = (RedisString)o;
        return Objects.equals(this.value, that.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.value);
    }

    ByteArrayWrapper getValue() {
        return this.value;
    }

    @Override
    public String toString() {
        return "RedisString{" + super.toString() + ", value=" + this.value + '}';
    }

    protected void handleSetExpiration(SetOptions options) {
        long setExpiration;
        long l = setExpiration = options == null ? 0L : options.getExpiration();
        if (setExpiration != 0L) {
            long now = System.currentTimeMillis();
            long timestamp = now + setExpiration;
            this.setExpirationTimestampNoDelta(timestamp);
        } else if (options == null || !options.isKeepTTL()) {
            this.persistNoDelta();
        }
    }

    protected void valueAppend(byte[] bytes) {
        this.value.append(bytes);
    }

    protected void valueSet(ByteArrayWrapper newValue) {
        this.value = newValue;
    }

    protected void valueSetBytes(byte[] bytes) {
        this.value.setBytes(bytes);
    }

    public KnownVersion[] getSerializationVersions() {
        return null;
    }
}

