/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor;

import java.util.Objects;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class GlobPattern {
    private static final char BACKSLASH = '\\';
    private final Pattern compiled;
    private final String globPattern;
    private boolean hasWildcard = false;

    public GlobPattern(String globPattern) {
        this.compiled = this.createPattern(globPattern);
        this.globPattern = globPattern;
    }

    public Pattern compiled() {
        return this.compiled;
    }

    public String globPattern() {
        return this.globPattern;
    }

    public static Pattern compile(String globPattern) {
        return new GlobPattern(globPattern).compiled();
    }

    public boolean matches(CharSequence s) {
        return this.compiled.matcher(s).matches();
    }

    /*
     * Enabled aggressive block sorting
     */
    private Pattern createPattern(String glob) {
        StringBuilder regex = new StringBuilder();
        int setOpen = 0;
        int len = glob.length();
        this.hasWildcard = false;
        block9: for (int i = 0; i < len; ++i) {
            char c = glob.charAt(i);
            switch (c) {
                case '\\': {
                    if (++i >= len) break;
                    regex.append(c).append(glob.charAt(i));
                    continue block9;
                }
                case '!': 
                case '$': 
                case '(': 
                case ')': 
                case '+': 
                case '.': 
                case '{': 
                case '|': {
                    regex.append('\\');
                    break;
                }
                case '*': {
                    regex.append('.');
                    this.hasWildcard = true;
                    break;
                }
                case '?': {
                    regex.append('.');
                    this.hasWildcard = true;
                    continue block9;
                }
                case '[': {
                    if (setOpen > 0) {
                        regex.append('\\');
                    }
                    ++setOpen;
                    this.hasWildcard = true;
                    break;
                }
                case '^': {
                    if (setOpen != 0) break;
                    regex.append('\\');
                    break;
                }
                case ']': {
                    setOpen = 0;
                }
            }
            regex.append(c);
        }
        if (setOpen > 0) {
            regex.append(']');
        }
        return Pattern.compile(regex.toString(), 40);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GlobPattern)) {
            return false;
        }
        GlobPattern that = (GlobPattern)o;
        return this.compiled.pattern().equals(that.compiled.pattern());
    }

    public int hashCode() {
        return Objects.hash(this.compiled, this.hasWildcard);
    }

    private static void error(String message, String pattern, int pos) {
        throw new PatternSyntaxException(message, pattern, pos);
    }
}

