/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor;

import org.apache.geode.cache.Region;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.execute.AllowExecutionInLowMemory;
import org.apache.geode.internal.cache.execute.RegionFunctionContextImpl;
import org.apache.geode.redis.internal.data.RedisData;
import org.apache.geode.redis.internal.data.RedisKey;

public abstract class SingleResultRedisFunction
implements AllowExecutionInLowMemory {
    private static final long serialVersionUID = 3239452234149879302L;
    private final transient PartitionedRegion partitionedRegion;

    public SingleResultRedisFunction(Region<RedisKey, RedisData> dataRegion) {
        this.partitionedRegion = (PartitionedRegion)dataRegion;
    }

    protected abstract Object compute(RedisKey var1, Object[] var2);

    public void execute(FunctionContext<Object[]> context) {
        RegionFunctionContextImpl regionFunctionContext = (RegionFunctionContextImpl)context;
        RedisKey key = (RedisKey)regionFunctionContext.getFilter().iterator().next();
        Object[] args = (Object[])context.getArguments();
        Runnable computation = () -> {
            Object result = this.compute(key, args);
            context.getResultSender().lastResult(result);
        };
        this.partitionedRegion.computeWithPrimaryLocked((Object)key, computation);
    }

    public boolean optimizeForWrite() {
        return true;
    }

    public boolean isHA() {
        return false;
    }
}

