/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.set;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.geode.redis.internal.data.ByteArrayWrapper;
import org.apache.geode.redis.internal.data.RedisDataType;
import org.apache.geode.redis.internal.data.RedisKey;
import org.apache.geode.redis.internal.executor.RedisResponse;
import org.apache.geode.redis.internal.executor.set.RedisSetCommands;
import org.apache.geode.redis.internal.executor.set.SetExecutor;
import org.apache.geode.redis.internal.netty.Command;
import org.apache.geode.redis.internal.netty.ExecutionHandlerContext;

public class SMoveExecutor
extends SetExecutor {
    private static final int MOVED = 1;
    private static final int NOT_MOVED = 0;

    @Override
    public RedisResponse executeCommand(Command command, ExecutionHandlerContext context) {
        boolean removed;
        List<byte[]> commandElems = command.getProcessedCommand();
        RedisKey source = command.getKey();
        RedisKey destination = new RedisKey(commandElems.get(2));
        ByteArrayWrapper member = new ByteArrayWrapper(commandElems.get(3));
        String destinationType = this.getRedisKeyCommands(context).internalType(destination);
        if (!destinationType.equals(RedisDataType.REDIS_SET.toString()) && !destinationType.equals("none")) {
            return RedisResponse.wrongType("Operation against a key holding the wrong kind of value");
        }
        RedisSetCommands redisSetCommands = this.createRedisSetCommands(context);
        boolean bl = removed = redisSetCommands.srem(source, new ArrayList<ByteArrayWrapper>(Collections.singletonList(member))) == 1L;
        if (!removed) {
            return RedisResponse.integer(0L);
        }
        redisSetCommands.sadd(destination, new ArrayList<ByteArrayWrapper>(Collections.singletonList(member)));
        return RedisResponse.integer(1L);
    }
}

