/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.string;

import java.util.List;
import org.apache.geode.redis.internal.data.RedisKey;
import org.apache.geode.redis.internal.executor.RedisResponse;
import org.apache.geode.redis.internal.executor.string.StringExecutor;
import org.apache.geode.redis.internal.netty.Coder;
import org.apache.geode.redis.internal.netty.Command;
import org.apache.geode.redis.internal.netty.ExecutionHandlerContext;

public class DecrByExecutor
extends StringExecutor {
    private static final int DECREMENT_INDEX = 2;

    @Override
    public RedisResponse executeCommand(Command command, ExecutionHandlerContext context) {
        long decrement;
        List<byte[]> commandElems = command.getProcessedCommand();
        RedisKey key = command.getKey();
        byte[] decrArray = commandElems.get(2);
        String decrString = Coder.bytesToString(decrArray);
        try {
            decrement = Long.parseLong(decrString);
        }
        catch (NumberFormatException e) {
            return RedisResponse.error("value is not an integer or out of range");
        }
        long value = this.getRedisStringCommands(context).decrby(key, decrement);
        return RedisResponse.integer(value);
    }
}

