/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.pubsub;

import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.cache.partition.PartitionMemberInfo;
import org.apache.geode.cache.partition.PartitionRegionHelper;
import org.apache.geode.cache.partition.PartitionRegionInfo;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.cache.execute.InternalFunction;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.redis.internal.data.RedisData;
import org.apache.geode.redis.internal.data.RedisKey;
import org.apache.geode.redis.internal.executor.GlobPattern;
import org.apache.geode.redis.internal.netty.Client;
import org.apache.geode.redis.internal.netty.ExecutionHandlerContext;
import org.apache.geode.redis.internal.pubsub.PubSub;
import org.apache.geode.redis.internal.pubsub.PublishResultCollector;
import org.apache.geode.redis.internal.pubsub.SubscribeResult;
import org.apache.geode.redis.internal.pubsub.Subscription;
import org.apache.geode.redis.internal.pubsub.Subscriptions;
import org.apache.logging.log4j.Logger;

public class PubSubImpl
implements PubSub {
    public static final String REDIS_PUB_SUB_FUNCTION_ID = "redisPubSubFunctionID";
    private static final Logger logger = LogService.getLogger();
    private final Subscriptions subscriptions;

    public PubSubImpl(Subscriptions subscriptions) {
        this.subscriptions = subscriptions;
        this.registerPublishFunction();
    }

    public int getSubscriptionCount() {
        return this.subscriptions.size();
    }

    @Override
    public long publish(Region<RedisKey, RedisData> dataRegion, byte[] channel, byte[] message) {
        PartitionRegionInfo info = PartitionRegionHelper.getPartitionRegionInfo(dataRegion);
        HashSet<DistributedMember> membersWithDataRegion = new HashSet<DistributedMember>();
        for (PartitionMemberInfo memberInfo : info.getPartitionMemberInfo()) {
            membersWithDataRegion.add(memberInfo.getDistributedMember());
        }
        ResultCollector subscriberCountCollector = FunctionService.onMembers(membersWithDataRegion).setArguments((Object)new Object[]{channel, message}).execute(REDIS_PUB_SUB_FUNCTION_ID);
        List subscriberCounts = null;
        try {
            subscriberCounts = (List)subscriberCountCollector.getResult();
        }
        catch (Exception e) {
            logger.warn("Failed to execute publish function {}", (Object)e.getMessage());
            return 0L;
        }
        return subscriberCounts.stream().mapToLong(x -> x).sum();
    }

    @Override
    public SubscribeResult subscribe(byte[] channel, ExecutionHandlerContext context, Client client) {
        return this.subscriptions.subscribe(channel, context, client);
    }

    @Override
    public SubscribeResult psubscribe(byte[] pattern, ExecutionHandlerContext context, Client client) {
        return this.subscriptions.psubscribe(pattern, context, client);
    }

    private void registerPublishFunction() {
        FunctionService.registerFunction((Function)new InternalFunction<Object[]>(){

            public String getId() {
                return PubSubImpl.REDIS_PUB_SUB_FUNCTION_ID;
            }

            public void execute(FunctionContext<Object[]> context) {
                Object[] publishMessage = (Object[])context.getArguments();
                long subscriberCount = PubSubImpl.this.publishMessageToSubscribers((byte[])publishMessage[0], (byte[])publishMessage[1]);
                context.getResultSender().lastResult((Object)subscriberCount);
            }

            public boolean isHA() {
                return false;
            }
        });
    }

    @Override
    public long unsubscribe(byte[] channel, Client client) {
        return this.subscriptions.unsubscribe(channel, client);
    }

    @Override
    public long punsubscribe(GlobPattern pattern, Client client) {
        return this.subscriptions.unsubscribe(pattern, client);
    }

    @Override
    public List<byte[]> findSubscriptionNames(Client client) {
        return this.subscriptions.findSubscriptions(client).stream().map(Subscription::getSubscriptionName).collect(Collectors.toList());
    }

    @Override
    public List<byte[]> findSubscriptionNames(Client client, Subscription.Type type) {
        return this.subscriptions.findSubscriptions(client).stream().filter(s -> s.getType() == type).map(Subscription::getSubscriptionName).collect(Collectors.toList());
    }

    @VisibleForTesting
    long publishMessageToSubscribers(byte[] channel, byte[] message) {
        List<Subscription> foundSubscriptions = this.subscriptions.findSubscriptions(channel);
        if (foundSubscriptions.isEmpty()) {
            return 0L;
        }
        PublishResultCollector publishResultCollector = new PublishResultCollector(foundSubscriptions.size(), this.subscriptions);
        foundSubscriptions.forEach(subscription -> subscription.publishMessage(channel, message, publishResultCollector));
        return publishResultCollector.getSuccessCount();
    }
}

