/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.time.Instant;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.internal.cache.execute.InternalFunction;
import org.apache.geode.logging.internal.OSProcess;
import org.apache.geode.management.internal.cli.domain.StackTracesPerMember;

public class GetStackTracesFunction
implements InternalFunction<Void> {
    private static final long serialVersionUID = 1L;

    public void execute(FunctionContext<Void> context) {
        try {
            Cache cache = context.getCache();
            String memberNameOrId = cache.getDistributedSystem().getDistributedMember().getName();
            if (memberNameOrId == null) {
                memberNameOrId = cache.getDistributedSystem().getDistributedMember().getId();
            }
            StackTracesPerMember stackTracePerMember = new StackTracesPerMember(memberNameOrId, Instant.now(), OSProcess.zipStacks());
            context.getResultSender().lastResult((Object)stackTracePerMember);
        }
        catch (Exception e) {
            context.getResultSender().sendException((Throwable)e);
        }
    }

    public String getId() {
        return GetStackTracesFunction.class.getName();
    }
}

