/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import javax.print.attribute.EnumSyntax;
import org.apache.commons.io.FileUtils;
import org.apache.geode.CancelCriterion;
import org.apache.geode.CancelException;
import org.apache.geode.DataSerializer;
import org.apache.geode.Instantiator;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.DiskAccessException;
import org.apache.geode.cache.EvictionAction;
import org.apache.geode.cache.EvictionAlgorithm;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.compression.Compressor;
import org.apache.geode.internal.HeapDataOutputStream;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.InternalInstantiator;
import org.apache.geode.internal.cache.CountingDataInputStream;
import org.apache.geode.internal.cache.DiskRegion;
import org.apache.geode.internal.cache.DiskRegionStats;
import org.apache.geode.internal.cache.DiskStoreImpl;
import org.apache.geode.internal.cache.Oplog;
import org.apache.geode.internal.cache.PlaceHolderDiskRegion;
import org.apache.geode.internal.cache.RegionMapFactory;
import org.apache.geode.internal.cache.persistence.CanonicalIdHolder;
import org.apache.geode.internal.cache.persistence.DiskExceptionHandler;
import org.apache.geode.internal.cache.persistence.DiskInitFileInterpreter;
import org.apache.geode.internal.cache.persistence.DiskInitFileParser;
import org.apache.geode.internal.cache.persistence.DiskRegionView;
import org.apache.geode.internal.cache.persistence.DiskStoreID;
import org.apache.geode.internal.cache.persistence.PRPersistentConfig;
import org.apache.geode.internal.cache.persistence.PersistentMemberID;
import org.apache.geode.internal.cache.persistence.PersistentMemberPattern;
import org.apache.geode.internal.cache.versions.DiskRegionVersionVector;
import org.apache.geode.internal.cache.versions.RegionVersionHolder;
import org.apache.geode.internal.cache.versions.RegionVersionVector;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.geode.internal.serialization.Version;
import org.apache.geode.internal.serialization.VersioningIO;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class DiskInitFile
implements DiskInitFileInterpreter {
    private static final Logger logger = LogService.getLogger();
    public static final String IF_FILE_EXT = ".if";
    public static final byte IF_EOF_ID = 0;
    public static final byte END_OF_RECORD_ID = 21;
    static final int OPLOG_FILE_ID_REC_SIZE = 10;
    private final ReentrantLock lock = new ReentrantLock();
    public static final byte IFREC_DISKSTORE_ID = 56;
    public static final byte IFREC_INSTANTIATOR_ID = 57;
    public static final byte IFREC_DATA_SERIALIZER_ID = 58;
    public static final byte IFREC_ONLINE_MEMBER_ID = 59;
    public static final byte IFREC_OFFLINE_MEMBER_ID = 60;
    public static final byte IFREC_RM_MEMBER_ID = 61;
    public static final byte IFREC_MY_MEMBER_INITIALIZING_ID = 62;
    public static final byte IFREC_MY_MEMBER_INITIALIZED_ID = 63;
    public static final byte IFREC_CREATE_REGION_ID = 64;
    public static final byte IFREC_BEGIN_DESTROY_REGION_ID = 65;
    public static final byte IFREC_CLEAR_REGION_ID = 66;
    public static final byte IFREC_END_DESTROY_REGION_ID = 67;
    public static final byte IFREC_BEGIN_PARTIAL_DESTROY_REGION_ID = 68;
    public static final byte IFREC_END_PARTIAL_DESTROY_REGION_ID = 69;
    public static final byte IFREC_CRF_CREATE = 70;
    public static final byte IFREC_DRF_CREATE = 71;
    public static final byte IFREC_CRF_DELETE = 72;
    public static final byte IFREC_DRF_DELETE = 73;
    public static final byte IFREC_REGION_CONFIG_ID = 74;
    public static final byte IFREC_OFFLINE_AND_EQUAL_MEMBER_ID = 75;
    public static final byte IFREC_REGION_CONFIG_ID_66 = 76;
    public static final byte IFREC_KRF_CREATE = 77;
    public static final byte IFREC_PR_CREATE = 78;
    public static final byte IFREC_PR_DESTROY = 79;
    public static final byte IFREC_ADD_CANONICAL_MEMBER_ID = 80;
    public static final byte IFREC_REVOKE_DISK_STORE_ID = 81;
    public static final byte IFREC_GEMFIRE_VERSION = 82;
    public static final byte IFREC_CLEAR_REGION_WITH_RVV_ID = 83;
    public static final byte IFREC_REGION_CONFIG_ID_80 = 88;
    public static final byte OPLOG_MAGIC_SEQ_ID = 89;
    public static final byte IFREC_REGION_CONFIG_ID_90 = 90;
    private final DiskStoreImpl parent;
    private final File ifFile;
    private RandomAccessFile ifRAF;
    private boolean closed;
    private final IntOpenHashSet dsIds;
    private final IntOpenHashSet instIds;
    private final LongOpenHashSet crfIds;
    private final LongOpenHashSet drfIds;
    private final Set<Long> krfIds;
    private final Map<Long, PlaceHolderDiskRegion> drMap = new HashMap<Long, PlaceHolderDiskRegion>();
    private final Map<String, PlaceHolderDiskRegion> drMapByName = new HashMap<String, PlaceHolderDiskRegion>();
    private final Map<String, PRPersistentConfig> prMap = new HashMap<String, PRPersistentConfig>();
    private final InternalDataSerializer.RegistrationListener regListener;
    private int ifLiveRecordCount = 0;
    private int ifTotalRecordCount = 0;
    private boolean compactInProgress;
    private KnownVersion gfversion;
    private long clearOplogEntryIdHWM = 0L;
    private final CanonicalIdHolder canonicalIdHolder = new CanonicalIdHolder();
    private final Set<PersistentMemberPattern> revokedMembers = new HashSet<PersistentMemberPattern>();
    private transient long nextSeekPosition;
    private transient boolean gotEOF;
    private int liveRegions = 0;
    static final int DR_ID_MAX_BYTES = 9;
    private static final long MIN_SIZE_BEFORE_COMPACT = 0x100000L;
    private static final double COMPACT_RATIO = 0.5;

    private void lock(boolean useBackupLock) {
        if (useBackupLock) {
            this.getDiskStore().getBackupLock().lock();
        }
        this.lock.lock();
    }

    private void unlock(boolean useBackupLock) {
        if (useBackupLock) {
            this.getDiskStore().getBackupLock().unlock();
        }
        this.lock.unlock();
    }

    private void recoverFromFailedCompaction() {
        File tmpFile = this.getTempFile();
        if (tmpFile.exists() && this.ifFile.exists()) {
            if (!this.ifFile.delete()) {
                throw new IllegalStateException("Could not delete " + this.ifFile);
            }
            if (!tmpFile.renameTo(this.ifFile)) {
                throw new IllegalStateException("Could not rename " + tmpFile + " to " + this.ifFile);
            }
        }
    }

    private DiskStoreImpl getDiskStore() {
        return this.parent;
    }

    public KnownVersion currentRecoveredGFVersion() {
        return this.gfversion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DiskStoreID recover() {
        DiskStoreID result;
        block18: {
            this.recoverFromFailedCompaction();
            if (!this.ifFile.exists()) {
                return new DiskStoreID(UUID.randomUUID());
            }
            result = null;
            try {
                FileInputStream fis = null;
                CountingDataInputStream dis = null;
                try {
                    fis = new FileInputStream(this.ifFile);
                    dis = new CountingDataInputStream(new BufferedInputStream(fis, 8192), this.ifFile.length());
                    DiskInitFileParser parser = new DiskInitFileParser(dis, this);
                    result = parser.parse();
                    this.gotEOF = parser.gotEOF();
                    this.nextSeekPosition = dis.getCount();
                    if (logger.isTraceEnabled(LogMarker.PERSIST_RECOVERY_VERBOSE)) {
                        logger.trace(LogMarker.PERSIST_RECOVERY_VERBOSE, "liveRecordCount={} totalRecordCount={}", (Object)this.ifLiveRecordCount, (Object)this.ifTotalRecordCount);
                    }
                }
                finally {
                    if (dis != null) {
                        dis.close();
                    }
                    if (fis != null) {
                        fis.close();
                    }
                }
                for (PlaceHolderDiskRegion drv : this.drMap.values()) {
                    if (drv.getMyPersistentID() == null && drv.getMyInitializingID() == null || !drv.isBucket() && this.getDiskStore().getOwnedByRegion()) continue;
                    this.getDiskStore().getStats().incUncreatedRecoveredRegions(1);
                    drv.setRecoveredEntryMap(RegionMapFactory.createVM(drv, this.getDiskStore(), this.getDiskStore().getInternalRegionArguments()));
                    if (this.getDiskStore().isOffline()) continue;
                    this.getDiskStore().scheduleForRecovery(drv);
                }
            }
            catch (EOFException fis) {
            }
            catch (ClassNotFoundException ex) {
                throw new DiskAccessException(String.format("Failed to read file during recovery from %s", this.ifFile.getPath()), (Throwable)ex, this.parent);
            }
            catch (IOException ex) {
                throw new DiskAccessException(String.format("Failed to read file during recovery from %s", this.ifFile.getPath()), (Throwable)ex, this.parent);
            }
            catch (CancelException ignore) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Oplog::readOplog:Error in recovery as Cache was closed", (Throwable)ignore);
                }
            }
            catch (RegionDestroyedException ignore) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Oplog::readOplog:Error in recovery as Region was destroyed", (Throwable)ignore);
                }
            }
            catch (IllegalStateException ex) {
                if (this.parent.isClosing()) break block18;
                throw ex;
            }
        }
        return result;
    }

    @Override
    public void cmnClearRegion(long drId, long clearOplogEntryId) {
        DiskRegionView drv = this.getDiskRegionById(drId);
        if (drv.getClearOplogEntryId() == 0L) {
            ++this.ifLiveRecordCount;
        }
        ++this.ifTotalRecordCount;
        drv.setClearOplogEntryId(clearOplogEntryId);
        if (clearOplogEntryId > this.clearOplogEntryIdHWM) {
            this.clearOplogEntryIdHWM = clearOplogEntryId;
        }
    }

    @Override
    public void cmnClearRegion(long drId, ConcurrentHashMap<DiskStoreID, RegionVersionHolder<DiskStoreID>> memberToVersion) {
        DiskRegionView drv = this.getDiskRegionById(drId);
        if (drv.getClearRVV() == null) {
            ++this.ifLiveRecordCount;
        }
        ++this.ifTotalRecordCount;
        DiskStoreID ownerId = this.parent.getDiskStoreID();
        RegionVersionHolder<DiskStoreID> ownerExceptions = memberToVersion.remove(ownerId);
        long ownerVersion = ownerExceptions == null ? 0L : ownerExceptions.getVersion();
        DiskRegionVersionVector rvv = new DiskRegionVersionVector(ownerId, memberToVersion, ownerVersion, new ConcurrentHashMap<DiskStoreID, Long>(), 0L, false, ownerExceptions);
        drv.setClearRVV(rvv);
    }

    public boolean hasLiveRegions() {
        this.lock(false);
        try {
            boolean bl = this.liveRegions > 0;
            return bl;
        }
        finally {
            this.unlock(false);
        }
    }

    @Override
    public void cmnCreateRegion(long drId, String regName) {
        this.recoverDiskRegion(drId, regName);
        ++this.liveRegions;
        ++this.ifLiveRecordCount;
        ++this.ifTotalRecordCount;
    }

    @Override
    public void cmnRegionConfig(long drId, byte lruAlgorithm, byte lruAction, int lruLimit, int concurrencyLevel, int initialCapacity, float loadFactor, boolean statisticsEnabled, boolean isBucket, EnumSet<DiskRegionFlag> flags, String partitionName, int startingBucketId, String compressorClassName, boolean offHeap) {
        DiskRegionView dr = this.getDiskRegionById(drId);
        if (dr != null) {
            if (KnownVersion.GFE_80.compareTo((Version)this.currentRecoveredGFVersion()) > 0 && !dr.getName().contains("_SERIAL_GATEWAY_SENDER_QUEUE") && !dr.getName().contains("_PARALLEL__GATEWAY__SENDER__QUEUE")) {
                flags.add(DiskRegionFlag.IS_WITH_VERSIONING);
            }
            dr.setConfig(lruAlgorithm, lruAction, lruLimit, concurrencyLevel, initialCapacity, loadFactor, statisticsEnabled, isBucket, flags, partitionName, startingBucketId, compressorClassName, offHeap);
            ++this.ifLiveRecordCount;
            ++this.ifTotalRecordCount;
        } else if (logger.isTraceEnabled(LogMarker.PERSIST_RECOVERY_VERBOSE)) {
            logger.trace(LogMarker.PERSIST_RECOVERY_VERBOSE, "bad disk region id!");
        } else {
            throw new IllegalStateException("bad disk region id");
        }
    }

    @Override
    public boolean cmnPRCreate(String name, PRPersistentConfig config) {
        if (this.prMap.put(name, config) == null) {
            ++this.ifLiveRecordCount;
            ++this.ifTotalRecordCount;
            ++this.liveRegions;
            return true;
        }
        return false;
    }

    @Override
    public void cmnGemfireVersion(KnownVersion version) {
        this.gfversion = version;
    }

    @Override
    public boolean cmnPRDestroy(String name) {
        if (this.prMap.remove(name) != null) {
            --this.ifLiveRecordCount;
            ++this.ifTotalRecordCount;
            --this.liveRegions;
            return true;
        }
        return false;
    }

    @Override
    public void cmnAddCanonicalMemberId(int id, Object object) {
        this.canonicalIdHolder.addMapping(id, object);
        ++this.ifLiveRecordCount;
        ++this.ifTotalRecordCount;
    }

    @Override
    public void cmnRmMemberId(long drId, PersistentMemberID pmid) {
        DiskRegionView dr = this.getDiskRegionById(drId);
        if (dr != null) {
            if (!dr.rmOnlineMember(pmid) && !dr.rmOfflineMember(pmid)) {
                dr.rmEqualMember(pmid);
            }
            --this.ifLiveRecordCount;
            ++this.ifTotalRecordCount;
        } else if (logger.isTraceEnabled(LogMarker.PERSIST_RECOVERY_VERBOSE)) {
            logger.trace(LogMarker.PERSIST_RECOVERY_VERBOSE, "bad disk region id!");
        } else {
            throw new IllegalStateException("bad disk region id");
        }
    }

    @Override
    public void cmnOfflineMemberId(long drId, PersistentMemberID pmid) {
        DiskRegionView dr = this.getDiskRegionById(drId);
        if (dr != null) {
            dr.addOfflineMember(pmid);
            if (dr.rmOnlineMember(pmid) || dr.rmEqualMember(pmid)) {
                --this.ifLiveRecordCount;
            }
            ++this.ifLiveRecordCount;
            ++this.ifTotalRecordCount;
        } else if (logger.isTraceEnabled(LogMarker.PERSIST_RECOVERY_VERBOSE)) {
            logger.trace(LogMarker.PERSIST_RECOVERY_VERBOSE, "bad disk region id!");
        } else {
            throw new IllegalStateException("bad disk region id");
        }
    }

    @Override
    public void cmdOfflineAndEqualMemberId(long drId, PersistentMemberID pmid) {
        DiskRegionView dr = this.getDiskRegionById(drId);
        if (dr != null) {
            if (this.parent.upgradeVersionOnly && KnownVersion.GFE_70.compareTo((Version)this.currentRecoveredGFVersion()) > 0) {
                dr.addOnlineMember(pmid);
                if (dr.rmOfflineMember(pmid)) {
                    --this.ifLiveRecordCount;
                }
            } else {
                dr.addOfflineAndEqualMember(pmid);
                if (dr.rmOnlineMember(pmid) || dr.rmOfflineMember(pmid)) {
                    --this.ifLiveRecordCount;
                }
            }
            ++this.ifLiveRecordCount;
            ++this.ifTotalRecordCount;
        } else if (logger.isTraceEnabled(LogMarker.PERSIST_RECOVERY_VERBOSE)) {
            logger.trace(LogMarker.PERSIST_RECOVERY_VERBOSE, "bad disk region id!");
        } else {
            throw new IllegalStateException("bad disk region id");
        }
    }

    @Override
    public void cmnOnlineMemberId(long drId, PersistentMemberID pmid) {
        DiskRegionView dr = this.getDiskRegionById(drId);
        if (dr != null) {
            dr.addOnlineMember(pmid);
            if (dr.rmOfflineMember(pmid) || dr.rmEqualMember(pmid)) {
                --this.ifLiveRecordCount;
            }
            ++this.ifLiveRecordCount;
            ++this.ifTotalRecordCount;
        } else if (logger.isTraceEnabled(LogMarker.PERSIST_RECOVERY_VERBOSE)) {
            logger.trace(LogMarker.PERSIST_RECOVERY_VERBOSE, "bad disk region id!");
        } else {
            throw new IllegalStateException("bad disk region id");
        }
    }

    @Override
    public void cmnDataSerializerId(Class dsc) {
        if (dsc != null) {
            DataSerializer ds = InternalDataSerializer.register(dsc, true);
            this.dsIds.add(ds.getId());
        }
        ++this.ifLiveRecordCount;
        ++this.ifTotalRecordCount;
    }

    @Override
    public void cmnInstantiatorId(int id, Class c, Class ic) {
        if (c != null && ic != null) {
            InternalInstantiator.register(c, ic, id, true);
            this.instIds.add(id);
        }
        ++this.ifLiveRecordCount;
        ++this.ifTotalRecordCount;
    }

    @Override
    public void cmnInstantiatorId(int id, String cn, String icn) {
        if (cn != null && icn != null) {
            InternalInstantiator.register(cn, icn, id, true);
            this.instIds.add(id);
        }
        ++this.ifLiveRecordCount;
        ++this.ifTotalRecordCount;
    }

    @Override
    public void cmnCrfCreate(long oplogId) {
        this.crfIds.add(oplogId);
        ++this.ifLiveRecordCount;
        ++this.ifTotalRecordCount;
    }

    @Override
    public void cmnDrfCreate(long oplogId) {
        this.drfIds.add(oplogId);
        ++this.ifLiveRecordCount;
        ++this.ifTotalRecordCount;
    }

    @Override
    public void cmnKrfCreate(long oplogId) {
        this.krfIds.add(oplogId);
        ++this.ifLiveRecordCount;
        ++this.ifTotalRecordCount;
    }

    @Override
    public boolean cmnCrfDelete(long oplogId) {
        if (this.krfIds.remove(oplogId)) {
            --this.ifLiveRecordCount;
            ++this.ifTotalRecordCount;
        }
        if (this.crfIds.remove(oplogId)) {
            --this.ifLiveRecordCount;
            ++this.ifTotalRecordCount;
            return true;
        }
        return false;
    }

    @Override
    public boolean cmnDrfDelete(long oplogId) {
        if (this.drfIds.remove(oplogId)) {
            --this.ifLiveRecordCount;
            ++this.ifTotalRecordCount;
            return true;
        }
        return false;
    }

    public boolean isCRFOplogIdPresent(long crfId) {
        return this.crfIds.contains(crfId);
    }

    public boolean isDRFOplogIdPresent(long drfId) {
        return this.drfIds.contains(drfId);
    }

    public void verifyOplogs(LongOpenHashSet foundCrfs, LongOpenHashSet foundDrfs) {
        this.verifyOplogs(foundCrfs, foundDrfs, this.crfIds, this.drfIds);
    }

    public void verifyOplogs(LongOpenHashSet foundCrfs, LongOpenHashSet foundDrfs, LongOpenHashSet expectedCrfIds, LongOpenHashSet expectedDrfIds) {
        LongOpenHashSet missingCrfs = this.calcMissing(foundCrfs, expectedCrfIds);
        LongOpenHashSet missingDrfs = this.calcMissing(foundDrfs, expectedDrfIds);
        boolean failed = false;
        String msg = null;
        if (!missingCrfs.isEmpty()) {
            failed = true;
            msg = "*.crf files with these ids: " + Arrays.toString(missingCrfs.toArray());
        }
        if (!missingDrfs.isEmpty()) {
            failed = true;
            msg = msg == null ? "" : msg + ", ";
            msg = msg + "*.drf files with these ids: " + Arrays.toString(missingDrfs.toArray());
        }
        if (failed) {
            msg = "The following required files could not be found: " + msg + ".";
            throw new IllegalStateException(msg);
        }
    }

    private LongOpenHashSet calcMissing(LongOpenHashSet found, LongOpenHashSet expected) {
        LongOpenHashSet missing = new LongOpenHashSet((LongCollection)expected);
        missing.removeAll((LongCollection)found);
        return missing;
    }

    boolean hasKrf(long oplogId) {
        return this.krfIds.contains(oplogId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DiskRegionView takeDiskRegionByName(String name) {
        this.lock(false);
        try {
            DiskRegionView result = this.drMapByName.remove(name);
            if (result != null) {
                this.drMap.remove(result.getId());
            }
            DiskRegionView diskRegionView = result;
            return diskRegionView;
        }
        finally {
            this.unlock(false);
        }
    }

    Map<Long, PlaceHolderDiskRegion> getDRMap() {
        this.lock(false);
        try {
            HashMap<Long, PlaceHolderDiskRegion> hashMap = new HashMap<Long, PlaceHolderDiskRegion>(this.drMap);
            return hashMap;
        }
        finally {
            this.unlock(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DiskRegion createDiskRegion(DiskStoreImpl dsi, String name, boolean isBucket, boolean isPersistBackup, boolean overflowEnabled, boolean isSynchronous, DiskRegionStats stats, CancelCriterion cancel, DiskExceptionHandler exceptionHandler, RegionAttributes ra, EnumSet<DiskRegionFlag> flags, String partitionName, int startingBucketId, Compressor compressor, boolean offHeap) {
        this.lock(true);
        try {
            DiskRegion result = new DiskRegion(dsi, name, isBucket, isPersistBackup, overflowEnabled, isSynchronous, stats, cancel, exceptionHandler, ra, flags, partitionName, startingBucketId, compressor == null ? null : compressor.getClass().getName(), offHeap);
            dsi.addDiskRegion(result);
            DiskRegion diskRegion = result;
            return diskRegion;
        }
        finally {
            this.unlock(true);
        }
    }

    DiskRegionView getDiskRegionByName(String name) {
        this.lock(false);
        try {
            DiskRegionView diskRegionView = this.drMapByName.get(name);
            return diskRegionView;
        }
        finally {
            this.unlock(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DiskRegionView getDiskRegionByPrName(String name) {
        this.lock(false);
        try {
            for (PlaceHolderDiskRegion dr : this.drMapByName.values()) {
                if (!dr.isBucket() || !name.equals(dr.getPrName())) continue;
                PlaceHolderDiskRegion placeHolderDiskRegion = dr;
                return placeHolderDiskRegion;
            }
            Iterator<PlaceHolderDiskRegion> iterator = null;
            return iterator;
        }
        finally {
            this.unlock(false);
        }
    }

    private DiskRegionView getDiskRegionById(long drId) {
        DiskRegionView result = this.drMap.get(drId);
        if (result == null) {
            result = this.parent.getById(drId);
        }
        return result;
    }

    private void recoverDiskRegion(long drId, String regName) {
        this.parent.recoverRegionId(drId);
        PlaceHolderDiskRegion dr = new PlaceHolderDiskRegion(this.parent, drId, regName);
        PlaceHolderDiskRegion old = this.drMap.put(drId, dr);
        assert (old == null);
        PlaceHolderDiskRegion oldDr = this.drMapByName.put(regName, dr);
        if (oldDr != null) {
            this.drMap.remove(oldDr.getId());
        }
    }

    private void writeIFRecord(byte b, DiskRegionView dr) {
        assert (this.lock.isHeldByCurrentThread());
        try {
            ByteBuffer bb = this.getIFWriteBuffer(11);
            bb.put(b);
            this.putDiskRegionID(bb, dr.getId());
            bb.put((byte)21);
            this.writeIFRecord(bb, false);
        }
        catch (IOException ex) {
            DiskAccessException dae = new DiskAccessException(String.format("Failed writing data to initialization file because: %s", ex), this.parent);
            if (!this.compactInProgress) {
                this.parent.handleDiskAccessException(dae);
            }
            throw dae;
        }
    }

    private void writeIFRecord(byte b, DiskRegionView dr, long v) {
        assert (this.lock.isHeldByCurrentThread());
        try {
            ByteBuffer bb = this.getIFWriteBuffer(19);
            bb.put(b);
            this.putDiskRegionID(bb, dr.getId());
            bb.putLong(v);
            bb.put((byte)21);
            this.writeIFRecord(bb, false);
        }
        catch (IOException ex) {
            DiskAccessException dae = new DiskAccessException(String.format("Failed writing data to initialization file because: %s", ex), this.parent);
            if (!this.compactInProgress) {
                this.parent.handleDiskAccessException(dae);
            }
            throw dae;
        }
    }

    private void writeIFRecord(byte b, long v) {
        assert (this.lock.isHeldByCurrentThread());
        try {
            ByteBuffer bb = this.getIFWriteBuffer(10);
            bb.put(b);
            bb.putLong(v);
            bb.put((byte)21);
            this.writeIFRecord(bb, false);
        }
        catch (IOException ex) {
            DiskAccessException dae = new DiskAccessException(String.format("Failed writing data to initialization file because: %s", ex), this.parent);
            if (!this.compactInProgress) {
                this.parent.handleDiskAccessException(dae);
            }
            throw dae;
        }
    }

    private void writeIFRecord(byte b, DiskRegionView dr, String s) {
        assert (this.lock.isHeldByCurrentThread());
        try {
            int hdosSize = 10 + this.estimateByteSize(s) + 1;
            if (hdosSize < 32) {
                hdosSize = 32;
            }
            try (HeapDataOutputStream hdos = new HeapDataOutputStream(hdosSize, KnownVersion.CURRENT);){
                hdos.write(b);
                DiskInitFile.writeDiskRegionID(hdos, dr.getId());
                hdos.writeUTF(s);
                hdos.write(21);
                this.writeIFRecord(hdos, true);
            }
        }
        catch (IOException ex) {
            DiskAccessException dae = new DiskAccessException(String.format("Failed writing data to initialization file because: %s", ex), this.parent);
            if (!this.compactInProgress) {
                this.parent.handleDiskAccessException(dae);
            }
            throw dae;
        }
    }

    private void writeIFRecord(byte b, long regionId, String fileName, Object compactorInfo) {
        assert (this.lock.isHeldByCurrentThread());
        try {
            int hdosSize = 10 + this.estimateByteSize(fileName) + 1;
            if (hdosSize < 32) {
                hdosSize = 32;
            }
            try (HeapDataOutputStream hdos = new HeapDataOutputStream(hdosSize, KnownVersion.CURRENT);){
                hdos.write(b);
                DiskInitFile.writeDiskRegionID(hdos, regionId);
                hdos.writeUTF(fileName);
                DataSerializer.writeObject(compactorInfo, hdos);
                hdos.write(21);
                this.writeIFRecord(hdos, true);
            }
        }
        catch (IOException ex) {
            DiskAccessException dae = new DiskAccessException(String.format("Failed writing data to initialization file because: %s", ex), this.parent);
            if (!this.compactInProgress) {
                this.parent.handleDiskAccessException(dae);
            }
            throw dae;
        }
    }

    private void writeIFRecord(byte b, long regionId, String fileName) {
        assert (this.lock.isHeldByCurrentThread());
        try {
            int hdosSize = 10 + this.estimateByteSize(fileName) + 1;
            if (hdosSize < 32) {
                hdosSize = 32;
            }
            try (HeapDataOutputStream hdos = new HeapDataOutputStream(hdosSize, KnownVersion.CURRENT);){
                hdos.write(b);
                DiskInitFile.writeDiskRegionID(hdos, regionId);
                hdos.writeUTF(fileName);
                hdos.write(21);
                this.writeIFRecord(hdos, true);
            }
        }
        catch (IOException ex) {
            DiskAccessException dae = new DiskAccessException(String.format("Failed writing data to initialization file because: %s", ex), this.parent);
            if (!this.compactInProgress) {
                this.parent.handleDiskAccessException(dae);
            }
            throw dae;
        }
    }

    private int estimateByteSize(String s) {
        return s == null ? 0 : (s.length() + 1) * 3;
    }

    private void writePMIDRecord(byte opcode, DiskRegionView dr, PersistentMemberID pmid, boolean doStats) {
        assert (this.lock.isHeldByCurrentThread());
        try {
            byte[] pmidBytes = this.pmidToBytes(pmid);
            ByteBuffer bb = this.getIFWriteBuffer(14 + pmidBytes.length + 1);
            bb.put(opcode);
            this.putDiskRegionID(bb, dr.getId());
            bb.putInt(pmidBytes.length);
            bb.put(pmidBytes);
            bb.put((byte)21);
            this.writeIFRecord(bb, doStats);
        }
        catch (IOException ex) {
            DiskAccessException dae = new DiskAccessException(String.format("Failed writing data to initialization file because: %s", ex), this.parent);
            if (!this.compactInProgress) {
                this.parent.handleDiskAccessException(dae);
            }
            throw dae;
        }
    }

    private void putDiskRegionID(ByteBuffer bb, long drId) {
        if (drId >= 0L && drId <= 255L) {
            bb.put((byte)drId);
        } else {
            byte bytesNeeded = Oplog.bytesNeeded(drId);
            bb.put(bytesNeeded);
            byte[] bytes = new byte[bytesNeeded];
            for (int i = bytesNeeded - 1; i >= 0; --i) {
                bytes[i] = (byte)(drId & 0xFFL);
                drId >>= 8;
            }
            bb.put(bytes);
        }
    }

    static void writeDiskRegionID(DataOutput dos, long drId) throws IOException {
        if (drId >= 0L && drId <= 255L) {
            dos.write((byte)drId);
        } else {
            byte bytesNeeded = Oplog.bytesNeeded(drId);
            dos.write(bytesNeeded);
            byte[] bytes = new byte[bytesNeeded];
            for (int i = bytesNeeded - 1; i >= 0; --i) {
                bytes[i] = (byte)(drId & 0xFFL);
                drId >>= 8;
            }
            dos.write(bytes);
        }
    }

    static long readDiskRegionID(DataInput dis) throws IOException {
        int bytesToRead = dis.readUnsignedByte();
        if ((long)bytesToRead <= 8L && (long)bytesToRead >= 1L) {
            long result = dis.readByte();
            --bytesToRead;
            while (bytesToRead > 0) {
                result <<= 8;
                result |= (long)dis.readUnsignedByte();
                --bytesToRead;
            }
            return result;
        }
        return bytesToRead;
    }

    private void cmnAddMyInitializingPMID(DiskRegionView dr, PersistentMemberID pmid) {
        if (dr != null) {
            if (dr.addMyInitializingPMID(pmid) == null) {
                ++this.ifLiveRecordCount;
            }
            ++this.ifTotalRecordCount;
        } else if (logger.isTraceEnabled(LogMarker.PERSIST_RECOVERY_VERBOSE)) {
            logger.trace(LogMarker.PERSIST_RECOVERY_VERBOSE, "bad disk region id!");
        } else {
            throw new IllegalStateException("bad disk region id");
        }
    }

    private void cmnMarkInitialized(DiskRegionView dr) {
        if (dr != null) {
            dr.markInitialized();
        } else if (logger.isTraceEnabled(LogMarker.PERSIST_RECOVERY_VERBOSE)) {
            logger.trace(LogMarker.PERSIST_RECOVERY_VERBOSE, "bad disk region id!");
        } else {
            throw new IllegalStateException("bad disk region id");
        }
    }

    private void cmnBeginDestroyRegion(DiskRegionView dr) {
        if (dr != null) {
            dr.markBeginDestroyRegion();
        } else if (logger.isTraceEnabled(LogMarker.PERSIST_RECOVERY_VERBOSE)) {
            logger.trace(LogMarker.PERSIST_RECOVERY_VERBOSE, "bad disk region id!");
        } else {
            throw new IllegalStateException("bad disk region id");
        }
    }

    private void cmnEndDestroyRegion(DiskRegionView dr) {
        if (dr != null) {
            if (dr.getClearOplogEntryId() != 0L) {
                --this.ifLiveRecordCount;
            }
            this.ifLiveRecordCount -= dr.getOnlineMembers().size();
            this.ifLiveRecordCount -= dr.getOfflineMembers().size();
            this.ifLiveRecordCount -= dr.getOfflineAndEqualMembers().size();
            --this.ifLiveRecordCount;
            if (dr.getMyPersistentID() != null) {
                --this.ifLiveRecordCount;
            }
            --this.liveRegions;
            this.drMap.remove(dr.getId());
            this.drMapByName.remove(dr.getName());
            this.parent.rmById(dr.getId());
            dr.markEndDestroyRegion();
        } else if (logger.isTraceEnabled(LogMarker.PERSIST_RECOVERY_VERBOSE)) {
            logger.trace(LogMarker.PERSIST_RECOVERY_VERBOSE, "bad disk region id!");
        } else {
            throw new IllegalStateException("bad disk region id");
        }
    }

    private void cmnBeginPartialDestroyRegion(DiskRegionView dr) {
        ++this.ifLiveRecordCount;
        ++this.ifTotalRecordCount;
        dr.markBeginDestroyDataStorage();
    }

    private void cmnEndPartialDestroyRegion(DiskRegionView dr) {
        if (dr.getClearOplogEntryId() != 0L) {
            --this.ifLiveRecordCount;
        }
        if (dr.getMyPersistentID() != null) {
            --this.ifLiveRecordCount;
        }
        dr.markEndDestroyDataStorage();
    }

    private void saveInstantiator(Instantiator inst) {
        this.saveInstantiator(inst.getId(), inst.getClass().getName(), inst.getInstantiatedClass().getName());
    }

    private void saveInstantiator(int id, String instantiatorClassName, String instantiatedClassName) {
        this.lock(true);
        try {
            if (!this.compactInProgress && this.instIds.contains(id)) {
                return;
            }
            byte[] classNameBytes = DiskInitFile.classNameToBytes(instantiatorClassName);
            byte[] instClassNameBytes = DiskInitFile.classNameToBytes(instantiatedClassName);
            ByteBuffer bb = this.getIFWriteBuffer(9 + classNameBytes.length + 4 + instClassNameBytes.length + 1);
            bb.put((byte)57);
            bb.putInt(id);
            bb.putInt(classNameBytes.length);
            bb.put(classNameBytes);
            bb.putInt(instClassNameBytes.length);
            bb.put(instClassNameBytes);
            bb.put((byte)21);
            this.writeIFRecord(bb);
        }
        catch (IOException ex) {
            throw new DiskAccessException(String.format("Failed saving instantiator to disk because: %s", ex), this.parent);
        }
        finally {
            this.unlock(true);
        }
    }

    private void saveInstantiators() {
        Object[] objects;
        for (Object obj : objects = InternalInstantiator.getInstantiatorsForSerialization()) {
            if (obj instanceof Instantiator) {
                this.saveInstantiator((Instantiator)obj);
                continue;
            }
            InternalInstantiator.InstantiatorAttributesHolder iah = (InternalInstantiator.InstantiatorAttributesHolder)obj;
            this.saveInstantiator(iah.getId(), iah.getInstantiatorClassName(), iah.getInstantiatedClassName());
        }
    }

    private static byte[] classToBytes(Class c) {
        return DiskInitFile.classNameToBytes(c.getName());
    }

    private static byte[] classNameToBytes(String cn) {
        return cn.getBytes();
    }

    private void saveDataSerializer(DataSerializer ds) {
        this.lock(true);
        try {
            if (!this.compactInProgress && this.dsIds.contains(ds.getId())) {
                return;
            }
            byte[] classNameBytes = DiskInitFile.classToBytes(ds.getClass());
            ByteBuffer bb = this.getIFWriteBuffer(5 + classNameBytes.length + 1);
            bb.put((byte)58);
            bb.putInt(classNameBytes.length);
            bb.put(classNameBytes);
            bb.put((byte)21);
            this.writeIFRecord(bb);
        }
        catch (IOException ex) {
            throw new DiskAccessException(String.format("Failed saving data serializer to disk because: %s", ex), this.parent);
        }
        finally {
            this.unlock(true);
        }
    }

    private void saveDataSerializers() {
        DataSerializer[] dataSerializers = InternalDataSerializer.getSerializers();
        for (int i = 0; i < dataSerializers.length; ++i) {
            this.saveDataSerializer(dataSerializers[i]);
        }
    }

    private void saveGemfireVersion() {
        if (this.gfversion == null) {
            this.gfversion = KnownVersion.CURRENT;
        }
        this.writeGemfireVersion(this.gfversion);
    }

    private void stopListeningForDataSerializerChanges() {
        if (this.regListener != null) {
            InternalDataSerializer.removeRegistrationListener(this.regListener);
        }
    }

    public long getMaxRecoveredClearEntryId() {
        return this.clearOplogEntryIdHWM;
    }

    private ByteBuffer getIFWriteBuffer(int size) {
        return ByteBuffer.allocate(size);
    }

    private void writeIFRecord(ByteBuffer bb) throws IOException {
        this.writeIFRecord(bb, true);
    }

    private void checkClosed() {
        if (this.closed) {
            this.parent.getCache().getCancelCriterion().checkCancelInProgress();
            if (this.parent.isClosed() || this.parent.isClosing()) {
                throw new CacheClosedException("The disk store is closed or closing");
            }
            DiskAccessException dae = new DiskAccessException("The disk init file is closed", this.parent);
            this.parent.handleDiskAccessException(dae);
            throw dae;
        }
    }

    private void writeIFRecord(ByteBuffer bb, boolean doStats) throws IOException {
        assert (this.lock.isHeldByCurrentThread());
        this.checkClosed();
        this.ifRAF.write(bb.array(), 0, bb.position());
        if (logger.isTraceEnabled(LogMarker.PERSIST_WRITES_VERBOSE)) {
            logger.trace(LogMarker.PERSIST_WRITES_VERBOSE, "DiskInitFile writeIFRecord bb[0] = {}", (Object)bb.array()[0]);
        }
        if (doStats) {
            ++this.ifLiveRecordCount;
            ++this.ifTotalRecordCount;
        }
        this.compactIfNeeded();
    }

    private void writeIFRecord(HeapDataOutputStream hdos, boolean doStats) throws IOException {
        assert (this.lock.isHeldByCurrentThread());
        this.checkClosed();
        hdos.sendTo(this.ifRAF);
        if (logger.isTraceEnabled(LogMarker.PERSIST_WRITES_VERBOSE)) {
            logger.trace(LogMarker.PERSIST_WRITES_VERBOSE, "DiskInitFile writeIFRecord HDOS");
        }
        if (doStats) {
            ++this.ifLiveRecordCount;
            ++this.ifTotalRecordCount;
        }
        this.compactIfNeeded();
    }

    private void compactIfNeeded() {
        this.lock(true);
        try {
            if (this.compactInProgress) {
                return;
            }
            if (this.ifTotalRecordCount == 0) {
                return;
            }
            if (this.ifTotalRecordCount == this.ifLiveRecordCount) {
                return;
            }
            if (this.ifRAF.length() <= 0x100000L) {
                return;
            }
            if ((double)this.ifLiveRecordCount / (double)this.ifTotalRecordCount > 0.5) {
                return;
            }
            this.compact();
        }
        catch (IOException ignore) {
            return;
        }
        finally {
            this.unlock(true);
        }
    }

    private File getTempFile() {
        return new File(this.ifFile.getAbsolutePath() + "tmp");
    }

    public File getIFFile() {
        return this.ifFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compact() {
        block22: {
            this.lock(true);
            this.compactInProgress = true;
            try {
                try {
                    this.ifRAF.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                File tmpFile = this.getTempFile();
                if (this.ifFile.renameTo(tmpFile)) {
                    boolean success = false;
                    try {
                        this.openRAF();
                        this.writeLiveData();
                        success = true;
                        if (!tmpFile.delete()) {
                            throw new DiskAccessException("could not delete temporary file " + tmpFile, this.parent);
                        }
                        break block22;
                    }
                    catch (DiskAccessException ignore) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Exception compacting init file {}", (Object)this, (Object)ignore);
                        }
                        break block22;
                    }
                    finally {
                        if (!success) {
                            try {
                                this.ifRAF.close();
                            }
                            catch (IOException iOException) {}
                            if (!this.ifFile.delete()) {
                                throw new DiskAccessException("could not delete file " + this.ifFile, this.parent);
                            }
                            if (!tmpFile.renameTo(this.ifFile)) {
                                throw new DiskAccessException("could not rename file " + tmpFile + " to " + this.ifFile, this.parent);
                            }
                            this.openRAF();
                            this.ifLiveRecordCount = 0;
                            this.ifTotalRecordCount = 0;
                        }
                    }
                }
                this.openRAF();
                this.ifLiveRecordCount = 0;
                this.ifTotalRecordCount = 0;
            }
            finally {
                this.compactInProgress = false;
                this.unlock(true);
            }
        }
    }

    public void copyTo(File targetDir) throws IOException {
        this.lock(false);
        try {
            FileUtils.copyFileToDirectory(this.ifFile, targetDir);
        }
        finally {
            this.unlock(false);
        }
    }

    private void openRAF() {
        if (DiskStoreImpl.PREALLOCATE_IF) {
            this.openRAF2();
            return;
        }
        try {
            this.ifRAF = new RandomAccessFile(this.ifFile, this.getFileMode());
            long len = this.ifRAF.length();
            if (len != 0L) {
                this.ifRAF.seek(len);
            }
        }
        catch (IOException ex) {
            throw new DiskAccessException(String.format("Could not open %s.", this.ifFile.getPath()), (Throwable)ex, this.parent);
        }
    }

    protected String getFileMode() {
        return DiskStoreImpl.SYNC_IF_WRITES ? "rwd" : "rw";
    }

    private void openRAF2() {
        try {
            this.ifRAF = new RandomAccessFile(this.ifFile, this.getFileMode());
            long len = this.ifRAF.length();
            if (len != 0L) {
                if (this.gotEOF) {
                    this.ifRAF.seek(this.nextSeekPosition - 1L);
                } else {
                    this.ifRAF.seek(this.nextSeekPosition);
                }
            } else {
                long maxSizeInMB = Math.min(Math.max(this.parent.getMaxOplogSize() / 200L, 1L), 10L);
                byte[] buffer = new byte[0x100000];
                int i = 0;
                while ((long)i < maxSizeInMB) {
                    this.ifRAF.write(buffer);
                    ++i;
                }
                this.ifRAF.seek(0L);
            }
        }
        catch (IOException ex) {
            throw new DiskAccessException(String.format("Could not open %s.", this.ifFile.getPath()), (Throwable)ex, this.parent);
        }
    }

    private void writeLiveData() {
        this.lock(true);
        try {
            this.ifLiveRecordCount = 0;
            this.ifTotalRecordCount = 0;
            this.writeDiskStoreId();
            this.saveGemfireVersion();
            this.saveInstantiators();
            this.saveDataSerializers();
            this.saveCrfIds();
            this.saveDrfIds();
            this.saveKrfIds();
            for (DiskRegionView diskRegionView : this.drMap.values()) {
                this.writeLiveData(diskRegionView);
            }
            for (DiskRegionView diskRegionView : this.parent.getDiskRegions()) {
                this.writeLiveData(diskRegionView);
            }
            this.savePRConfigs();
            this.saveCanonicalIds();
            this.saveRevokedMembers();
            if (logger.isDebugEnabled()) {
                logger.debug("After compacting init file lrc={} trc={}", (Object)this.ifLiveRecordCount, (Object)this.ifTotalRecordCount);
            }
        }
        finally {
            this.unlock(true);
        }
    }

    private void saveCrfIds() {
        LongIterator i = this.crfIds.iterator();
        while (i.hasNext()) {
            this.writeIFRecord((byte)70, i.next());
            ++this.ifLiveRecordCount;
            ++this.ifTotalRecordCount;
        }
    }

    private void saveDrfIds() {
        LongIterator i = this.drfIds.iterator();
        while (i.hasNext()) {
            this.writeIFRecord((byte)71, i.next());
            ++this.ifLiveRecordCount;
            ++this.ifTotalRecordCount;
        }
    }

    private void saveKrfIds() {
        Iterator<Long> i = this.krfIds.iterator();
        while (i.hasNext()) {
            this.writeIFRecord((byte)77, i.next());
            ++this.ifLiveRecordCount;
            ++this.ifTotalRecordCount;
        }
    }

    private void savePRConfigs() {
        for (Map.Entry<String, PRPersistentConfig> entry : this.prMap.entrySet()) {
            this.writePRCreate(entry.getKey(), entry.getValue());
            ++this.ifLiveRecordCount;
            ++this.ifTotalRecordCount;
        }
    }

    private void saveCanonicalIds() {
        Int2ObjectOpenHashMap mappings = this.canonicalIdHolder.getAllMappings();
        ObjectIterator i = mappings.int2ObjectEntrySet().fastIterator();
        while (i.hasNext()) {
            Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)i.next();
            this.writeCanonicalId(entry.getIntKey(), entry.getValue());
        }
    }

    private void saveRevokedMembers() {
        for (PersistentMemberPattern revoked : this.revokedMembers) {
            this.writeRevokedMember(revoked);
        }
    }

    private void writeDiskStoreId() {
        this.lock(true);
        try {
            ByteBuffer bb = this.getIFWriteBuffer(8);
            bb.put((byte)89);
            bb.put(Oplog.OPLOG_TYPE.IF.getBytes(), 0, Oplog.OPLOG_TYPE.getLen());
            bb.put((byte)21);
            this.writeIFRecord(bb, false);
            bb = this.getIFWriteBuffer(18);
            bb.put((byte)56);
            bb.putLong(this.parent.getDiskStoreID().getLeastSignificantBits());
            bb.putLong(this.parent.getDiskStoreID().getMostSignificantBits());
            bb.put((byte)21);
            this.writeIFRecord(bb, false);
        }
        catch (IOException ex) {
            DiskAccessException dae = new DiskAccessException(String.format("Failed writing data to initialization file because: %s", ex), this.parent);
            if (!this.compactInProgress) {
                this.parent.handleDiskAccessException(dae);
            }
            throw dae;
        }
        finally {
            this.unlock(true);
        }
    }

    private void writeRevokedMember(PersistentMemberPattern revoked) {
        try (HeapDataOutputStream hdos = new HeapDataOutputStream(32, KnownVersion.CURRENT);){
            hdos.write(81);
            InternalDataSerializer.invokeToData(revoked, hdos);
            hdos.write(21);
            this.writeIFRecord(hdos, false);
        }
        catch (IOException ex) {
            DiskAccessException dae = new DiskAccessException(String.format("Failed writing data to initialization file because: %s", ex), this.parent);
            if (!this.compactInProgress) {
                this.parent.handleDiskAccessException(dae);
            }
            throw dae;
        }
    }

    private void writeRegionConfig(DiskRegionView drv) {
        int len = this.estimateByteSize(drv.getPartitionName());
        try (HeapDataOutputStream bb = new HeapDataOutputStream(30 + len + 4 + 1 + 1 + 1, KnownVersion.CURRENT);){
            int comprLen = this.estimateByteSize(drv.getCompressorClassName());
            bb.write(90);
            DiskInitFile.writeDiskRegionID(bb, drv.getId());
            bb.write(drv.getLruAlgorithm());
            bb.write(drv.getLruAction());
            bb.writeInt(drv.getLruLimit());
            bb.writeInt(drv.getConcurrencyLevel());
            bb.writeInt(drv.getInitialCapacity());
            bb.writeFloat(drv.getLoadFactor());
            bb.write((byte)(drv.getStatisticsEnabled() ? 1 : 0));
            bb.write((byte)(drv.isBucket() ? 1 : 0));
            EnumSet<DiskRegionFlag> flags = drv.getFlags();
            bb.writeUTF(drv.getPartitionName());
            bb.writeInt(drv.getStartingBucketId());
            bb.writeUTF(drv.getCompressorClassName() == null ? "" : drv.getCompressorClassName());
            bb.writeBoolean(flags.contains((Object)DiskRegionFlag.IS_WITH_VERSIONING));
            bb.writeBoolean(drv.getOffHeap());
            bb.write(21);
            this.writeIFRecord(bb, false);
        }
        catch (IOException ex) {
            DiskAccessException dae = new DiskAccessException(String.format("Failed writing data to initialization file because: %s", ex), this.parent);
            if (!this.compactInProgress) {
                this.parent.handleDiskAccessException(dae);
            }
            throw dae;
        }
    }

    private void writePRCreate(String name, PRPersistentConfig config) {
        int nameLength = this.estimateByteSize(name);
        String colocatedWith = config.getColocatedWith();
        colocatedWith = colocatedWith == null ? "" : colocatedWith;
        int colocatedLength = this.estimateByteSize(colocatedWith);
        try (HeapDataOutputStream hdos = new HeapDataOutputStream(1 + nameLength + 4 + colocatedLength + 1, KnownVersion.CURRENT);){
            hdos.write(78);
            hdos.writeUTF(name);
            hdos.writeInt(config.getTotalNumBuckets());
            hdos.writeUTF(colocatedWith);
            hdos.write(21);
            this.writeIFRecord(hdos, false);
        }
        catch (IOException ex) {
            DiskAccessException dae = new DiskAccessException(String.format("Failed writing data to initialization file because: %s", ex), this.parent);
            if (!this.compactInProgress) {
                this.parent.handleDiskAccessException(dae);
            }
            throw dae;
        }
    }

    private void writePRDestroy(String name) {
        int nameLength = this.estimateByteSize(name);
        try (HeapDataOutputStream hdos = new HeapDataOutputStream(1 + nameLength + 4 + 1, KnownVersion.CURRENT);){
            hdos.write(79);
            hdos.writeUTF(name);
            hdos.write(21);
            this.writeIFRecord(hdos, false);
        }
        catch (IOException ex) {
            DiskAccessException dae = new DiskAccessException(String.format("Failed writing data to initialization file because: %s", ex), this.parent);
            if (!this.compactInProgress) {
                this.parent.handleDiskAccessException(dae);
            }
            throw dae;
        }
    }

    private void writeCanonicalId(int id, Object object) {
        try (HeapDataOutputStream hdos = new HeapDataOutputStream(32, KnownVersion.CURRENT);){
            hdos.write(80);
            hdos.writeInt(id);
            DataSerializer.writeObject(object, hdos);
            hdos.write(21);
            this.writeIFRecord(hdos, true);
        }
        catch (IOException ex) {
            DiskAccessException dae = new DiskAccessException(String.format("Failed writing data to initialization file because: %s", ex), this.parent);
            if (!this.compactInProgress) {
                this.parent.handleDiskAccessException(dae);
            }
            throw dae;
        }
    }

    private void writeLiveData(DiskRegionView drv) {
        this.writeIFRecord((byte)64, drv, drv.getName());
        this.writeRegionConfig(drv);
        if (drv.wasAboutToDestroy()) {
            this.writeIFRecord((byte)65, drv);
        } else if (drv.wasAboutToDestroyDataStorage()) {
            this.writeIFRecord((byte)68, drv);
        }
        if (drv.getClearOplogEntryId() != 0L) {
            this.writeIFRecord((byte)66, drv, drv.getClearOplogEntryId());
            ++this.ifTotalRecordCount;
            ++this.ifLiveRecordCount;
        }
        if (drv.getClearRVV() != null) {
            this.writeClearRecord(drv, drv.getClearRVV());
        }
        for (PersistentMemberID pmid : drv.getOnlineMembers()) {
            this.writePMIDRecord((byte)59, drv, pmid, true);
        }
        for (PersistentMemberID pmid : drv.getOfflineMembers()) {
            this.writePMIDRecord((byte)60, drv, pmid, true);
        }
        for (PersistentMemberID pmid : drv.getOfflineAndEqualMembers()) {
            this.writePMIDRecord((byte)75, drv, pmid, true);
        }
        if (drv.getMyPersistentID() != null) {
            this.writePMIDRecord((byte)62, drv, drv.getMyPersistentID(), true);
            this.writeIFRecord((byte)63, drv);
        }
        if (drv.getMyInitializingID() != null) {
            this.writePMIDRecord((byte)62, drv, drv.getMyInitializingID(), true);
        }
    }

    void forceCompaction() {
        this.compact();
    }

    private byte[] pmidToBytes(PersistentMemberID id) {
        try {
            HeapDataOutputStream hdos = new HeapDataOutputStream(KnownVersion.CURRENT);
            InternalDataSerializer.invokeToData(id, hdos);
            return hdos.toByteArray();
        }
        catch (IOException ex) {
            throw new DiskAccessException(String.format("Failed writing data to initialization file because: %s", ex), this.parent);
        }
    }

    private PersistentMemberID bytesToPMID(byte[] bytes) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            DataInputStream dis = new DataInputStream(bais);
            PersistentMemberID result = new PersistentMemberID();
            InternalDataSerializer.invokeFromData(result, dis);
            return result;
        }
        catch (IOException io) {
            throw new DiskAccessException(String.format("Failed to read file during recovery from %s", this.ifFile.getPath()), (Throwable)io, this.parent);
        }
        catch (ClassNotFoundException cnf) {
            throw new DiskAccessException(String.format("Failed to read file during recovery from %s", this.ifFile.getPath()), (Throwable)cnf, this.parent);
        }
    }

    DiskInitFile(String name, DiskStoreImpl parent, boolean shouldExist, Set<File> oplogs) {
        boolean didNotExist;
        this.parent = parent;
        File f = new File(this.parent.getInfoFileDir().getDir(), "BACKUP" + name + IF_FILE_EXT);
        boolean bl = didNotExist = !f.exists();
        if (shouldExist && didNotExist) {
            String msg = String.format("The init file %s does not exist.", f);
            if (!oplogs.isEmpty()) {
                LinkedHashSet<File> allOplogs = new LinkedHashSet<File>(oplogs);
                msg = msg + String.format("If it no longer exists then delete the following files to be able to create this disk store. Existing oplogs are: %s", allOplogs);
            }
            throw new IllegalStateException(msg);
        }
        this.ifFile = f;
        this.dsIds = new IntOpenHashSet();
        this.instIds = new IntOpenHashSet();
        this.crfIds = new LongOpenHashSet();
        this.drfIds = new LongOpenHashSet();
        this.krfIds = ConcurrentHashMap.newKeySet();
        this.recover();
        if (this.parent.isOffline() && !this.parent.isOfflineCompacting() && !this.parent.isOfflineModify()) {
            this.dump();
        }
        this.openRAF();
        if (!this.parent.isOffline() || this.parent.isOfflineCompacting()) {
            if (didNotExist) {
                this.parent.setDiskStoreID(DiskStoreID.random());
                this.writeDiskStoreId();
                this.saveGemfireVersion();
            }
            this.regListener = new InternalDataSerializer.RegistrationListener(){

                @Override
                public void newInstantiator(Instantiator i) {
                    DiskInitFile.this.saveInstantiator(i);
                }

                @Override
                public void newDataSerializer(DataSerializer ds) {
                    DiskInitFile.this.saveDataSerializer(ds);
                }
            };
            InternalDataSerializer.addRegistrationListener(this.regListener);
            this.saveInstantiators();
            this.saveDataSerializers();
        } else {
            this.regListener = null;
        }
    }

    void closeRegion(DiskRegionView dr) {
        this.lock(true);
        try {
            this.parent.rmById(dr.getId());
            PlaceHolderDiskRegion phdr = new PlaceHolderDiskRegion(dr);
            this.drMap.put(dr.getId(), phdr);
            this.drMapByName.put(dr.getName(), phdr);
        }
        finally {
            this.unlock(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearRegion(DiskRegionView dr, long clearOplogEntryId) {
        this.lock(true);
        try {
            if (clearOplogEntryId != 0L) {
                ++this.ifTotalRecordCount;
                if (dr.getClearOplogEntryId() == 0L) {
                    ++this.ifLiveRecordCount;
                }
                dr.setClearOplogEntryId(clearOplogEntryId);
                if (clearOplogEntryId > this.clearOplogEntryIdHWM) {
                    this.clearOplogEntryIdHWM = clearOplogEntryId;
                }
                this.writeIFRecord((byte)66, dr, clearOplogEntryId);
            }
        }
        finally {
            this.unlock(true);
        }
    }

    void clearRegion(DiskRegion dr, RegionVersionVector rvv) {
        this.lock(true);
        try {
            ++this.ifTotalRecordCount;
            if (dr.getClearRVV() == null) {
                ++this.ifLiveRecordCount;
            }
            dr.setClearRVV(rvv);
            this.writeClearRecord(dr, rvv);
        }
        finally {
            this.unlock(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeClearRecord(DiskRegionView dr, RegionVersionVector rvv) {
        try (HeapDataOutputStream hdos = new HeapDataOutputStream(32, KnownVersion.CURRENT);){
            hdos.write(83);
            DiskInitFile.writeDiskRegionID(hdos, dr.getId());
            Map memberToVersion = rvv.getMemberToVersion();
            hdos.writeInt(memberToVersion.size());
            for (Map.Entry entry : memberToVersion.entrySet()) {
                InternalDataSerializer.invokeToData(entry.getKey(), hdos);
                RegionVersionHolder regionVersionHolder = entry.getValue();
                synchronized (regionVersionHolder) {
                    InternalDataSerializer.invokeToData(entry.getValue(), hdos);
                }
            }
            hdos.write(21);
            this.writeIFRecord(hdos, false);
        }
        catch (IOException ex) {
            DiskAccessException dae = new DiskAccessException(String.format("Failed writing data to initialization file because: %s", ex), this.parent);
            if (!this.compactInProgress) {
                this.parent.handleDiskAccessException(dae);
            }
            throw dae;
        }
    }

    void createRegion(DiskRegionView drv) {
        this.lock(true);
        try {
            if (!drv.isRecreated()) {
                this.writeIFRecord((byte)64, drv, drv.getName());
                ++this.liveRegions;
                this.writeRegionConfig(drv);
            } else if (drv.hasConfigChanged()) {
                this.writeRegionConfig(drv);
                drv.setConfigChanged(false);
            }
        }
        finally {
            this.unlock(true);
        }
    }

    void beginDestroyRegion(DiskRegionView dr) {
        this.lock(true);
        try {
            if (this.regionStillCreated(dr)) {
                this.cmnBeginDestroyRegion(dr);
                this.writeIFRecord((byte)65, dr);
            }
        }
        finally {
            this.unlock(true);
        }
    }

    void endDestroyRegion(DiskRegionView dr) {
        this.lock(true);
        try {
            if (this.regionStillCreated(dr)) {
                this.cmnEndDestroyRegion(dr);
                this.writeIFRecord((byte)67, dr);
                if (logger.isDebugEnabled()) {
                    logger.trace(LogMarker.PERSIST_WRITES_VERBOSE, "DiskInitFile IFREC_END_DESTROY_REGION_ID drId={}", (Object)dr.getId());
                }
            }
        }
        finally {
            this.unlock(true);
        }
    }

    void beginDestroyDataStorage(DiskRegionView dr) {
        this.lock(true);
        try {
            assert (this.regionStillCreated(dr));
            this.cmnBeginPartialDestroyRegion(dr);
            this.writeIFRecord((byte)68, dr);
        }
        finally {
            this.unlock(true);
        }
    }

    void endDestroyDataStorage(DiskRegionView dr) {
        this.lock(true);
        try {
            assert (this.regionStillCreated(dr));
            this.cmnEndPartialDestroyRegion(dr);
            this.writeIFRecord((byte)69, dr);
        }
        finally {
            this.unlock(true);
        }
    }

    public void createPersistentPR(String name, PRPersistentConfig config) {
        this.lock(true);
        try {
            if (this.cmnPRCreate(name, config)) {
                this.writePRCreate(name, config);
            }
        }
        finally {
            this.unlock(true);
        }
    }

    public void destroyPersistentPR(String name) {
        this.lock(true);
        try {
            if (this.cmnPRDestroy(name)) {
                this.writePRDestroy(name);
            }
        }
        finally {
            this.unlock(true);
        }
    }

    public PRPersistentConfig getPersistentPR(String name) {
        this.lock(false);
        try {
            PRPersistentConfig pRPersistentConfig = this.prMap.get(name);
            return pRPersistentConfig;
        }
        finally {
            this.unlock(false);
        }
    }

    public Map<String, PRPersistentConfig> getAllPRs() {
        this.lock(false);
        try {
            HashMap<String, PRPersistentConfig> hashMap = new HashMap<String, PRPersistentConfig>(this.prMap);
            return hashMap;
        }
        finally {
            this.unlock(false);
        }
    }

    void crfCreate(long oplogId) {
        this.lock(true);
        try {
            this.cmnCrfCreate(oplogId);
            this.writeIFRecord((byte)70, oplogId);
        }
        finally {
            this.unlock(true);
        }
    }

    void drfCreate(long oplogId) {
        this.lock(true);
        try {
            this.cmnDrfCreate(oplogId);
            this.writeIFRecord((byte)71, oplogId);
        }
        finally {
            this.unlock(true);
        }
    }

    void krfCreate(long oplogId) {
        this.lock(true);
        try {
            this.cmnKrfCreate(oplogId);
            this.writeIFRecord((byte)77, oplogId);
        }
        finally {
            this.unlock(true);
        }
    }

    void crfDelete(long oplogId) {
        this.lock(true);
        try {
            if (this.cmnCrfDelete(oplogId)) {
                this.writeIFRecord((byte)72, oplogId);
            }
        }
        finally {
            this.unlock(true);
        }
    }

    void drfDelete(long oplogId) {
        this.lock(true);
        try {
            if (this.cmnDrfDelete(oplogId)) {
                this.writeIFRecord((byte)73, oplogId);
            }
        }
        finally {
            this.unlock(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getOrCreateCanonicalId(Object object) {
        this.lock(true);
        try {
            int id = this.canonicalIdHolder.getId(object);
            if (id <= 0) {
                id = this.canonicalIdHolder.createId(object);
                this.writeCanonicalId(id, object);
            }
            int n = id;
            return n;
        }
        finally {
            this.unlock(true);
        }
    }

    Object getCanonicalObject(int id) {
        this.lock(false);
        try {
            Object object = this.canonicalIdHolder.getObject(id);
            return object;
        }
        finally {
            this.unlock(false);
        }
    }

    void close() {
        this.lock(true);
        try {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.stopListeningForDataSerializerChanges();
            try {
                this.ifRAF.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            for (DiskRegionView k : this.getKnown()) {
                k.close();
            }
            if (this.liveRegions == 0 && !this.parent.isValidating()) {
                this.basicDestroy();
            }
        }
        finally {
            this.unlock(true);
        }
    }

    void destroy() {
        this.lock(true);
        try {
            this.close();
            this.basicDestroy();
        }
        finally {
            this.unlock(true);
        }
    }

    private void basicDestroy() {
        if (this.ifFile.exists() && !this.ifFile.delete() && logger.isDebugEnabled()) {
            logger.debug("could not delete file {}", (Object)this.ifFile);
        }
    }

    void addMyInitializingPMID(DiskRegionView dr, PersistentMemberID pmid) {
        this.lock(true);
        try {
            if (this.regionStillCreated(dr)) {
                this.cmnAddMyInitializingPMID(dr, pmid);
                this.writePMIDRecord((byte)62, dr, pmid, false);
            }
        }
        finally {
            this.unlock(true);
        }
    }

    void markInitialized(DiskRegionView dr) {
        this.lock(true);
        try {
            if (this.regionStillCreated(dr)) {
                this.writeIFRecord((byte)63, dr);
                this.cmnMarkInitialized(dr);
            }
        }
        finally {
            this.unlock(true);
        }
    }

    void addOnlinePMID(DiskRegionView dr, PersistentMemberID pmid) {
        this.lock(true);
        try {
            if (this.regionStillCreated(dr) && dr.addOnlineMember(pmid)) {
                if (dr.rmOfflineMember(pmid) || dr.rmEqualMember(pmid)) {
                    --this.ifLiveRecordCount;
                }
                this.writePMIDRecord((byte)59, dr, pmid, true);
            }
        }
        finally {
            this.unlock(true);
        }
    }

    void addOfflinePMID(DiskRegionView dr, PersistentMemberID pmid) {
        this.lock(true);
        try {
            if (this.regionStillCreated(dr) && dr.addOfflineMember(pmid)) {
                if (dr.rmOnlineMember(pmid) || dr.rmEqualMember(pmid)) {
                    --this.ifLiveRecordCount;
                }
                this.writePMIDRecord((byte)60, dr, pmid, true);
            }
        }
        finally {
            this.unlock(true);
        }
    }

    void addOfflineAndEqualPMID(DiskRegionView dr, PersistentMemberID pmid) {
        this.lock(true);
        try {
            if (this.regionStillCreated(dr) && dr.addOfflineAndEqualMember(pmid)) {
                if (dr.rmOnlineMember(pmid) || dr.rmOfflineMember(pmid)) {
                    --this.ifLiveRecordCount;
                }
                this.writePMIDRecord((byte)75, dr, pmid, true);
            }
        }
        finally {
            this.unlock(true);
        }
    }

    void rmPMID(DiskRegionView dr, PersistentMemberID pmid) {
        this.lock(true);
        try {
            if (this.regionStillCreated(dr) && (dr.rmOnlineMember(pmid) || dr.rmOfflineMember(pmid) || dr.rmEqualMember(pmid))) {
                --this.ifLiveRecordCount;
                ++this.ifTotalRecordCount;
                this.writePMIDRecord((byte)61, dr, pmid, false);
            }
        }
        finally {
            this.unlock(true);
        }
    }

    public void revokeMember(PersistentMemberPattern revokedPattern) {
        if (revokedPattern.getUUID() == null) {
            return;
        }
        this.lock(true);
        try {
            if (this.cmnRevokeDiskStoreId(revokedPattern)) {
                ++this.ifLiveRecordCount;
                ++this.ifTotalRecordCount;
                this.writeRevokedMember(revokedPattern);
            }
        }
        finally {
            this.unlock(true);
        }
    }

    public Set<PersistentMemberPattern> getRevokedIDs() {
        this.lock(false);
        try {
            HashSet<PersistentMemberPattern> hashSet = new HashSet<PersistentMemberPattern>(this.revokedMembers);
            return hashSet;
        }
        finally {
            this.unlock(false);
        }
    }

    boolean regionStillCreated(DiskRegionView dr) {
        this.lock(false);
        try {
            boolean bl = this.getDiskRegionById(dr.getId()) != null;
            return bl;
        }
        finally {
            this.unlock(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean regionExists(long drId) {
        this.lock(false);
        try {
            boolean bl = this.drMap.containsKey(drId);
            return bl;
        }
        finally {
            this.unlock(false);
        }
    }

    Collection<DiskRegionView> getKnown() {
        this.lock(false);
        try {
            ArrayList<DiskRegionView> arrayList = new ArrayList<DiskRegionView>(this.drMap.values());
            return arrayList;
        }
        finally {
            this.unlock(false);
        }
    }

    @Override
    public void cmnAddMyInitializingPMID(long drId, PersistentMemberID pmid) {
        this.cmnAddMyInitializingPMID(this.getDiskRegionById(drId), pmid);
    }

    @Override
    public void cmnBeginDestroyRegion(long drId) {
        this.cmnBeginDestroyRegion(this.getDiskRegionById(drId));
    }

    @Override
    public void cmnBeginPartialDestroyRegion(long drId) {
        this.cmnBeginPartialDestroyRegion(this.getDiskRegionById(drId));
    }

    @Override
    public void cmnEndDestroyRegion(long drId) {
        this.cmnEndDestroyRegion(this.getDiskRegionById(drId));
    }

    @Override
    public void cmnEndPartialDestroyRegion(long drId) {
        this.cmnEndPartialDestroyRegion(this.getDiskRegionById(drId));
    }

    @Override
    public void cmnMarkInitialized(long drId) {
        this.cmnMarkInitialized(this.getDiskRegionById(drId));
    }

    @Override
    public void cmnDiskStoreID(DiskStoreID diskStoreID) {
        if (logger.isTraceEnabled(LogMarker.PERSIST_RECOVERY_VERBOSE)) {
            logger.trace(LogMarker.PERSIST_RECOVERY_VERBOSE, "diskStoreId={}", (Object)diskStoreID);
        }
        this.parent.setDiskStoreID(diskStoreID);
    }

    @Override
    public boolean cmnRevokeDiskStoreId(PersistentMemberPattern revokedPattern) {
        return this.revokedMembers.add(revokedPattern);
    }

    @Override
    public String getNameForError() {
        return this.parent.toString();
    }

    @Override
    public boolean isClosing() {
        return this.parent.isClosing();
    }

    public void dump() {
        if (logger.isTraceEnabled(LogMarker.PERSIST_RECOVERY_VERBOSE)) {
            System.out.println("expectedCrfs=" + Arrays.toString(this.crfIds.toArray()));
            System.out.println("expectedDrfs=" + Arrays.toString(this.drfIds.toArray()));
            System.out.println("dataSerializerIds=" + Arrays.toString(this.dsIds.toArray()));
            System.out.println("instantiatorIds=  " + Arrays.toString(this.instIds.toArray()));
        }
    }

    private Map<String, List<PlaceHolderDiskRegion>> getRegionsToDump(String regName) {
        if (regName == null) {
            HashMap<String, List<PlaceHolderDiskRegion>> regions = new HashMap<String, List<PlaceHolderDiskRegion>>();
            for (DiskRegionView diskRegionView : this.drMap.values()) {
                if (!(diskRegionView instanceof PlaceHolderDiskRegion)) continue;
                PlaceHolderDiskRegion dr = (PlaceHolderDiskRegion)diskRegionView;
                if (dr.isBucket()) {
                    ArrayList<PlaceHolderDiskRegion> buckets = (ArrayList<PlaceHolderDiskRegion>)regions.get(dr.getPrName());
                    if (buckets == null) {
                        buckets = new ArrayList<PlaceHolderDiskRegion>();
                        regions.put(dr.getPrName(), buckets);
                    }
                    buckets.add(dr);
                    continue;
                }
                regions.put(diskRegionView.getName(), Collections.singletonList(dr));
            }
            return regions;
        }
        DiskRegionView drv = this.getDiskRegionByName(regName);
        if (drv == null) {
            ArrayList<PlaceHolderDiskRegion> buckets = new ArrayList<PlaceHolderDiskRegion>();
            for (PlaceHolderDiskRegion dr : this.drMapByName.values()) {
                if (!dr.isBucket() || !dr.getName().equals(dr.getPrName())) continue;
                buckets.add(dr);
            }
            if (buckets.isEmpty()) {
                throw new IllegalArgumentException("The disk store does not contain a region named " + regName);
            }
            return Collections.singletonMap(regName, buckets);
        }
        if (drv instanceof PlaceHolderDiskRegion) {
            return Collections.singletonMap(regName, Collections.singletonList((PlaceHolderDiskRegion)drv));
        }
        return Collections.emptyMap();
    }

    public void dumpRegionInfo(PrintStream printStream, String regName) {
        printStream.println("Regions in the disk store:");
        for (Map.Entry<String, List<PlaceHolderDiskRegion>> regionEntry : this.getRegionsToDump(regName).entrySet()) {
            printStream.print("  ");
            List<PlaceHolderDiskRegion> regions = regionEntry.getValue();
            if (logger.isTraceEnabled(LogMarker.PERSIST_RECOVERY_VERBOSE)) {
                for (PlaceHolderDiskRegion region : regions) {
                    region.dump(printStream);
                }
                continue;
            }
            regions.get(0).dump(printStream);
        }
    }

    public void dumpRegionMetadata(boolean showBuckets) {
        System.out.println("Disk Store ID: " + this.getDiskStore().getDiskStoreID());
        System.out.println("Regions in the disk store:");
        for (Map.Entry<String, List<PlaceHolderDiskRegion>> regionEntry : this.getRegionsToDump(null).entrySet()) {
            System.out.print("  ");
            List<PlaceHolderDiskRegion> regions = regionEntry.getValue();
            PlaceHolderDiskRegion region0 = regions.get(0);
            if (region0.isBucket()) {
                this.dumpPRMetaData(showBuckets, regions);
                continue;
            }
            region0.dumpMetadata();
        }
    }

    private void dumpPRMetaData(boolean showBuckets, List<PlaceHolderDiskRegion> regions) {
        StringBuilder msg = new StringBuilder(regions.get(0).getPrName());
        regions.get(0).dumpCommonAttributes(msg);
        if (showBuckets) {
            for (PlaceHolderDiskRegion region : regions) {
                msg.append("\n");
                msg.append("\n");
                msg.append(region.getName());
                region.dumpPersistentView(msg);
            }
        } else {
            HashMap<DiskStoreID, String> online = new HashMap<DiskStoreID, String>();
            HashMap<DiskStoreID, String> offline = new HashMap<DiskStoreID, String>();
            HashMap<DiskStoreID, String> equal = new HashMap<DiskStoreID, String>();
            for (PlaceHolderDiskRegion placeHolderDiskRegion : regions) {
                for (PersistentMemberID mem : placeHolderDiskRegion.getOnlineMembers()) {
                    online.put(mem.getDiskStoreId(), mem.getHost() + ":" + mem.getDirectory());
                }
                for (PersistentMemberID mem : placeHolderDiskRegion.getOfflineMembers()) {
                    offline.put(mem.getDiskStoreId(), mem.getHost() + ":" + mem.getDirectory());
                }
                for (PersistentMemberID mem : placeHolderDiskRegion.getOfflineAndEqualMembers()) {
                    equal.put(mem.getDiskStoreId(), mem.getHost() + ":" + mem.getDirectory());
                }
            }
            msg.append("\n\tonlineMembers:");
            for (Map.Entry entry : online.entrySet()) {
                msg.append("\n\t\t").append(entry.getKey()).append(" ").append((String)entry.getValue());
            }
            msg.append("\n\tofflineMembers:");
            for (Map.Entry entry : offline.entrySet()) {
                msg.append("\n\t\t").append(entry.getKey()).append(" ").append((String)entry.getValue());
            }
            msg.append("\n\tequalsMembers:");
            for (Map.Entry entry : equal.entrySet()) {
                msg.append("\n\t\t").append(entry.getKey()).append(" ").append((String)entry.getValue());
            }
        }
        System.out.println(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyPRRegion(String prName) {
        ArrayList<PlaceHolderDiskRegion> buckets = new ArrayList<PlaceHolderDiskRegion>();
        this.lock(true);
        try {
            for (PlaceHolderDiskRegion dr : this.drMapByName.values()) {
                if (!dr.isBucket() || !prName.equals(dr.getPrName())) continue;
                buckets.add(dr);
            }
        }
        finally {
            this.unlock(true);
        }
        for (PlaceHolderDiskRegion dr : buckets) {
            this.endDestroyRegion(dr);
        }
        this.destroyPersistentPR(prName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String modifyPRRegion(String prName, String lruOption, String lruActionOption, String lruLimitOption, String concurrencyLevelOption, String initialCapacityOption, String loadFactorOption, String compressorClassNameOption, String statisticsEnabledOption, String offHeapOption, boolean printToConsole) {
        StringBuffer sb = new StringBuffer();
        ArrayList<PlaceHolderDiskRegion> buckets = new ArrayList<PlaceHolderDiskRegion>();
        this.lock(true);
        try {
            for (PlaceHolderDiskRegion dr : this.drMapByName.values()) {
                if (!dr.isBucket() || !prName.equals(dr.getPrName())) continue;
                buckets.add(dr);
            }
            boolean printInfo = true;
            for (PlaceHolderDiskRegion dr : buckets) {
                String message = this.basicModifyRegion(printInfo, dr, lruOption, lruActionOption, lruLimitOption, concurrencyLevelOption, initialCapacityOption, loadFactorOption, compressorClassNameOption, statisticsEnabledOption, offHeapOption, printToConsole);
                if (printInfo) {
                    sb.append(message);
                }
                printInfo = false;
            }
        }
        finally {
            this.unlock(true);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String modifyRegion(DiskRegionView drv, String lruOption, String lruActionOption, String lruLimitOption, String concurrencyLevelOption, String initialCapacityOption, String loadFactorOption, String compressorClassNameOption, String statisticsEnabledOption, String offHeapOption, boolean printToConsole) {
        this.lock(true);
        try {
            String string = this.basicModifyRegion(false, drv, lruOption, lruActionOption, lruLimitOption, concurrencyLevelOption, initialCapacityOption, loadFactorOption, compressorClassNameOption, statisticsEnabledOption, offHeapOption, printToConsole);
            return string;
        }
        finally {
            this.unlock(true);
        }
    }

    private String basicModifyRegion(boolean printInfo, DiskRegionView drv, String lruOption, String lruActionOption, String lruLimitOption, String concurrencyLevelOption, String initialCapacityOption, String loadFactorOption, String compressorClassNameOption, String statisticsEnabledOption, String offHeapOption, boolean printToConsole) {
        EnumSyntax ea;
        byte lruAlgorithm = drv.getLruAlgorithm();
        byte lruAction = drv.getLruAction();
        int lruLimit = drv.getLruLimit();
        int concurrencyLevel = drv.getConcurrencyLevel();
        int initialCapacity = drv.getInitialCapacity();
        float loadFactor = drv.getLoadFactor();
        String compressorClassName = drv.getCompressorClassName();
        boolean statisticsEnabled = drv.getStatisticsEnabled();
        boolean offHeap = drv.getOffHeap();
        StringBuffer sb = new StringBuffer();
        String lineSeparator = System.getProperty("line.separator");
        if (lruOption != null) {
            ea = EvictionAlgorithm.parseAction(lruOption);
            if (ea == null) {
                throw new IllegalArgumentException("Expected lru to be one of the following: \"none\", \"lru-entry-count\", \"lru-heap-percentage\", or \"lru-memory-size\"");
            }
            lruAlgorithm = (byte)ea.getValue();
            if (((EvictionAlgorithm)ea).isNone()) {
                lruAction = (byte)EvictionAction.NONE.getValue();
                lruLimit = 0;
            } else if (((EvictionAlgorithm)ea).isLRUHeap()) {
                lruLimit = 0;
            }
        }
        if (lruActionOption != null) {
            ea = EvictionAction.parseAction(lruActionOption);
            if (ea != null) {
                lruAction = (byte)ea.getValue();
            } else {
                throw new IllegalArgumentException("Expected lruAction to be one of the following: \"none\", \"overflow-to-disk\", or \"local-destroy\"");
            }
        }
        if (lruLimitOption != null && (lruLimit = Integer.parseInt(lruLimitOption)) < 0) {
            throw new IllegalArgumentException("Expected lruLimit to be greater than or equal to zero");
        }
        if (concurrencyLevelOption != null && (concurrencyLevel = Integer.parseInt(concurrencyLevelOption)) < 0) {
            throw new IllegalArgumentException("Expected concurrencyLevel to be greater than or equal to zero");
        }
        if (initialCapacityOption != null && (initialCapacity = Integer.parseInt(initialCapacityOption)) < 0) {
            throw new IllegalArgumentException("Expected initialCapacity to be greater than or equal to zero");
        }
        if (loadFactorOption != null && (double)(loadFactor = Float.parseFloat(loadFactorOption)) < 0.0) {
            throw new IllegalArgumentException("Expected loadFactor to be greater than or equal to zero");
        }
        if (compressorClassNameOption != null) {
            String string = compressorClassName = compressorClassNameOption.isEmpty() ? null : compressorClassNameOption;
        }
        if (statisticsEnabledOption != null && !(statisticsEnabled = Boolean.parseBoolean(statisticsEnabledOption)) && !statisticsEnabledOption.equalsIgnoreCase("false")) {
            throw new IllegalArgumentException("Expected statisticsEnabled to be \"true\" or \"false\"");
        }
        if (offHeapOption != null && !(offHeap = Boolean.parseBoolean(offHeapOption)) && !offHeapOption.equalsIgnoreCase("false")) {
            throw new IllegalArgumentException("Expected offHeap to be \"true\" or \"false\"");
        }
        sb.append("Before modification: ");
        sb.append(lineSeparator);
        sb.append(((PlaceHolderDiskRegion)drv).dump2());
        sb.append(lineSeparator);
        drv.setConfig(lruAlgorithm, lruAction, lruLimit, concurrencyLevel, initialCapacity, loadFactor, statisticsEnabled, drv.isBucket(), drv.getFlags(), drv.getPartitionName(), drv.getStartingBucketId(), compressorClassName, offHeap);
        ((PlaceHolderDiskRegion)drv).getEvictionAttributes();
        this.writeRegionConfig(drv);
        sb.append("After modification: ");
        sb.append(lineSeparator);
        sb.append(((PlaceHolderDiskRegion)drv).dump2());
        sb.append(lineSeparator);
        String message = sb.toString();
        if (printInfo && printToConsole) {
            System.out.println(message);
        }
        return message;
    }

    private void writeGemfireVersion(KnownVersion version) {
        this.lock(true);
        try {
            ByteBuffer bb = this.getIFWriteBuffer(5);
            bb.put((byte)82);
            VersioningIO.writeOrdinal((ByteBuffer)bb, (short)version.ordinal(), (boolean)false);
            bb.put((byte)21);
            this.writeIFRecord(bb, false);
        }
        catch (IOException ex) {
            DiskAccessException dae = new DiskAccessException(String.format("Failed writing data to initialization file because: %s", ex), this.parent);
            if (!this.compactInProgress) {
                this.parent.handleDiskAccessException(dae);
            }
            throw dae;
        }
        finally {
            this.unlock(true);
        }
    }

    public static enum DiskRegionFlag {
        IS_WITH_VERSIONING;

    }
}

