/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.partitioned;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.geode.CancelException;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.CacheException;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.DistributionStats;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.HeapDataOutputStream;
import org.apache.geode.internal.cache.BucketDump;
import org.apache.geode.internal.cache.BucketRegion;
import org.apache.geode.internal.cache.ForceReattemptException;
import org.apache.geode.internal.cache.InitialImageOperation;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.PartitionedRegionDataStore;
import org.apache.geode.internal.cache.VersionTagHolder;
import org.apache.geode.internal.cache.partitioned.PartitionMessage;
import org.apache.geode.internal.cache.versions.VersionSource;
import org.apache.geode.internal.cache.versions.VersionTag;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.internal.serialization.Version;
import org.apache.geode.internal.serialization.Versioning;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class FetchBulkEntriesMessage
extends PartitionMessage {
    private static final Logger logger = LogService.getLogger();
    private HashSet<Integer> bucketIds;
    private String regex;
    private HashMap<Integer, HashSet> bucketKeys;
    private static final byte ALL_KEYS = 0;
    private static final byte KEY_LIST = 1;
    private static final byte REGEX = 2;
    private byte keys;
    private boolean allowTombstones;

    public FetchBulkEntriesMessage() {
    }

    private FetchBulkEntriesMessage(InternalDistributedMember recipient, int regionId, ReplyProcessor21 processor, HashMap<Integer, HashSet> bucketKeys, HashSet<Integer> bucketIds, String regex, boolean allowTombstones) {
        super(recipient, regionId, processor);
        this.bucketKeys = bucketKeys;
        this.bucketIds = bucketIds;
        this.regex = regex;
        this.keys = bucketKeys != null ? (byte)1 : 0;
        this.allowTombstones = allowTombstones;
    }

    public static FetchBulkEntriesResponse send(InternalDistributedMember recipient, PartitionedRegion r, HashMap<Integer, HashSet> bucketKeys, HashSet<Integer> bucketIds, String regex, boolean allowTombstones) throws ForceReattemptException {
        Assert.assertTrue(recipient != null, "FetchBulkEntriesMessage NULL reply message");
        FetchBulkEntriesResponse p = new FetchBulkEntriesResponse(r.getSystem(), r, recipient);
        FetchBulkEntriesMessage m = new FetchBulkEntriesMessage(recipient, r.getPRId(), p, bucketKeys, bucketIds, regex, allowTombstones);
        m.setTransactionDistributed(r.getCache().getTxManager().isDistributed());
        Set<InternalDistributedMember> failures = r.getDistributionManager().putOutgoing(m);
        if (failures != null && failures.size() > 0) {
            throw new ForceReattemptException(String.format("Failed sending < %s >", m));
        }
        return p;
    }

    @Override
    protected boolean operateOnPartitionedRegion(ClusterDistributionManager dm, PartitionedRegion pr, long startTime) throws CacheException, ForceReattemptException {
        if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
            logger.trace(LogMarker.DM_VERBOSE, "FetchBulkEntriesMessage operateOnRegion: {}", (Object)pr.getFullPath());
        }
        FetchBulkEntriesReplyMessage.sendReply(pr, this.getSender(), this.getProcessorId(), dm, this.bucketKeys, this.bucketIds, this.regex, this.allowTombstones, startTime);
        return false;
    }

    @Override
    protected void appendFields(StringBuilder buff) {
        super.appendFields(buff);
        buff.append("; bucketId=").append(this.bucketIds);
        buff.append("; recipient=").append(this.getRecipient());
    }

    public int getDSFID() {
        return 165;
    }

    @Override
    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        super.fromData(in, context);
        this.keys = DataSerializer.readByte(in);
        if (this.keys == 1) {
            this.bucketKeys = DataSerializer.readHashMap(in);
        } else if (this.keys == 0) {
            this.bucketIds = DataSerializer.readHashSet(in);
        }
        this.regex = DataSerializer.readString(in);
        this.allowTombstones = DataSerializer.readPrimitiveBoolean(in);
    }

    @Override
    public void toData(DataOutput out, SerializationContext context) throws IOException {
        super.toData(out, context);
        DataSerializer.writeByte(this.keys, out);
        if (this.keys == 1) {
            DataSerializer.writeHashMap(this.bucketKeys, out);
        } else if (this.keys == 0) {
            DataSerializer.writeHashSet(this.bucketIds, out);
        }
        DataSerializer.writeString(this.regex, out);
        DataSerializer.writePrimitiveBoolean(this.allowTombstones, out);
    }

    @Override
    public KnownVersion[] getSerializationVersions() {
        return null;
    }

    public static class FetchBulkEntriesResponse
    extends ReplyProcessor21 {
        private final PartitionedRegion pr;
        private final HashMap<Integer, HashMap<Object, Object>> returnValue;
        private final HashMap<Integer, HashMap<Object, VersionTag>> returnVersions = new HashMap();
        private final Map<VersionSource, VersionSource> canonicalMembers = new ConcurrentHashMap<VersionSource, VersionSource>();
        private final Object endLock = new Object();
        private volatile int chunksProcessed;
        private volatile boolean lastChunkReceived;
        private HashSet<Integer> failedBucketIds;
        private ArrayList<Integer> receivedBuckets = new ArrayList();
        private int expectedChunks;
        private InternalDistributedMember recipient;

        public FetchBulkEntriesResponse(InternalDistributedSystem ds, PartitionedRegion pr, InternalDistributedMember recipient) {
            super(ds, Collections.singleton(recipient));
            this.pr = pr;
            this.recipient = recipient;
            this.returnValue = new HashMap();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void processChunkResponse(FetchBulkEntriesReplyMessage msg) {
            boolean doneProcessing = false;
            if (msg.getException() != null) {
                this.process(msg);
            } else {
                boolean deserializingKey = true;
                try {
                    int currentId;
                    ByteArrayInputStream byteStream = new ByteArrayInputStream(msg.chunk);
                    DataInputStream in = new DataInputStream(byteStream);
                    boolean isDebugEnabled = logger.isTraceEnabled(LogMarker.DM_VERBOSE);
                    block11: while (in.available() > 0 && (currentId = DataSerializer.readPrimitiveInt(in)) != -1) {
                        while (in.available() > 0) {
                            deserializingKey = true;
                            Object key = DataSerializer.readObject(in);
                            if (key != null) {
                                deserializingKey = false;
                                Object value = DataSerializer.readObject(in);
                                VersionTag versionTag = (VersionTag)DataSerializer.readObject(in);
                                if (versionTag != null) {
                                    if (this.canonicalMembers.containsKey(versionTag.getMemberID())) {
                                        versionTag.setMemberID(this.canonicalMembers.get(versionTag.getMemberID()));
                                    } else {
                                        this.canonicalMembers.put((VersionSource)versionTag.getMemberID(), (VersionSource)versionTag.getMemberID());
                                    }
                                }
                                HashMap<Integer, HashMap<Object, Object>> hashMap = this.returnValue;
                                synchronized (hashMap) {
                                    HashMap<Object, Object> valueMap = this.returnValue.get(currentId);
                                    HashMap<Object, VersionTag<Object>> versionMap = this.returnVersions.get(currentId);
                                    if (valueMap != null) {
                                        valueMap.put(key, value);
                                    } else {
                                        valueMap = new HashMap();
                                        valueMap.put(key, value);
                                        this.returnValue.put(currentId, valueMap);
                                    }
                                    if (versionMap != null) {
                                        versionMap.put(key, versionTag);
                                    } else {
                                        versionMap = new HashMap();
                                        versionMap.put(key, versionTag);
                                        this.returnVersions.put(currentId, versionMap);
                                    }
                                    continue;
                                }
                            }
                            boolean bucketHasMore = DataSerializer.readPrimitiveBoolean(in);
                            HashMap<Integer, HashMap<Object, Object>> hashMap = this.returnValue;
                            synchronized (hashMap) {
                                if (!bucketHasMore) {
                                    this.receivedBuckets.add(currentId);
                                }
                                continue block11;
                            }
                        }
                    }
                    Object object = this.endLock;
                    synchronized (object) {
                        ++this.chunksProcessed;
                        if (msg.lastInSeries) {
                            this.expectedChunks = msg.msgNum;
                            this.failedBucketIds = msg.failedBucketIds;
                        }
                        if (this.expectedChunks == this.chunksProcessed) {
                            doneProcessing = true;
                            this.lastChunkReceived = true;
                        }
                        if (isDebugEnabled) {
                            logger.trace(LogMarker.DM_VERBOSE, "{} chunksProcessed={}, lastChunkReceived={},done={}", (Object)this, (Object)this.chunksProcessed, (Object)this.lastChunkReceived, (Object)doneProcessing);
                        }
                    }
                }
                catch (Exception e) {
                    if (deserializingKey) {
                        this.processException(new ReplyException("Error deserializing keys", e));
                    } else {
                        this.processException(new ReplyException("Error deserializing values", e));
                    }
                    this.checkIfDone();
                }
                if (doneProcessing) {
                    this.process(msg);
                }
            }
        }

        public BucketDump[] waitForEntries() throws ForceReattemptException {
            try {
                this.waitForRepliesUninterruptibly();
            }
            catch (ReplyException e) {
                Throwable t = e.getCause();
                if (t instanceof CancelException) {
                    logger.debug("FetchBulkEntriesResponse got remote cancellation; forcing reattempt. {}", (Object)t.getMessage(), (Object)t);
                    throw new ForceReattemptException("FetchKeysResponse got remote cancellation; forcing reattempt.", t);
                }
                if (t instanceof ForceReattemptException) {
                    throw new ForceReattemptException("Peer requests reattempt", t);
                }
                e.handleCause();
            }
            if (!this.lastChunkReceived) {
                throw new ForceReattemptException("No replies received");
            }
            BucketDump[] dumps = new BucketDump[this.receivedBuckets.size()];
            for (int i = 0; i < this.receivedBuckets.size(); ++i) {
                int id = this.receivedBuckets.get(i);
                dumps[i] = new BucketDump(id, this.recipient, null, (Map<Object, Object>)this.returnValue.get(id), (Map<Object, VersionTag>)this.returnVersions.get(id));
            }
            return dumps;
        }

        public HashSet<Integer> getFailedBucketIds() {
            return this.failedBucketIds;
        }
    }

    public static class FetchBulkEntriesReplyMessage
    extends ReplyMessage {
        boolean lastInSeries;
        transient byte[] chunk;
        transient HeapDataOutputStream chunkStream;
        private int msgNum;
        private HashSet<Integer> failedBucketIds;

        @Override
        public KnownVersion[] getSerializationVersions() {
            return null;
        }

        public FetchBulkEntriesReplyMessage() {
        }

        private FetchBulkEntriesReplyMessage(InternalDistributedMember dest, int processorId, HeapDataOutputStream chunk, int msgNum, boolean lastInSeries) {
            this.setRecipient(dest);
            this.setProcessorId(processorId);
            this.lastInSeries = lastInSeries;
            this.chunkStream = chunk;
            this.msgNum = msgNum;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void sendReply(PartitionedRegion pr, InternalDistributedMember recipient, int processorId, DistributionManager dm, HashMap<Integer, HashSet> bucketKeys, HashSet<Integer> bucketIds, String regex, boolean allowTombstones, long startTime) throws ForceReattemptException {
            boolean lockAcquired;
            BucketRegion map;
            block61: {
                PartitionedRegionDataStore ds = pr.getDataStore();
                if (ds == null) {
                    return;
                }
                ArrayList<BucketRegion> maps = new ArrayList<BucketRegion>();
                HashSet<Integer> failedBuckets = new HashSet<Integer>();
                Set<Integer> bucketIdSet = null;
                bucketIdSet = bucketKeys != null ? bucketKeys.keySet() : bucketIds;
                for (int id : bucketIdSet) {
                    try {
                        maps.add(ds.handleRemoteGetEntries(id));
                    }
                    catch (ForceReattemptException fre) {
                        failedBuckets.add(id);
                    }
                }
                map = null;
                lockAcquired = false;
                try (HeapDataOutputStream mos = new HeapDataOutputStream(InitialImageOperation.CHUNK_SIZE_IN_BYTES + 2048, Versioning.getKnownVersionOrDefault((Version)recipient.getVersion(), (KnownVersion)KnownVersion.CURRENT));){
                    Iterator mapsIterator = maps.iterator();
                    Iterator it = null;
                    boolean keepGoing = true;
                    boolean writeFooter = false;
                    boolean lastMsgSent = false;
                    boolean needToWriteBucketInfo = true;
                    int msgNum = 0;
                    while (mapsIterator.hasNext()) {
                        block60: {
                            if (map != null && lockAcquired) {
                                try {
                                    map.releaseDestroyLock();
                                }
                                catch (CancelException cancelException) {
                                }
                                finally {
                                    lockAcquired = false;
                                }
                            }
                            if ((map = (BucketRegion)mapsIterator.next()).isBucketDestroyed()) {
                                failedBuckets.add(map.getId());
                                continue;
                            }
                            try {
                                map.acquireDestroyLock();
                                lockAcquired = true;
                            }
                            catch (CancelException e) {
                                if (!logger.isDebugEnabled()) break block60;
                                logger.debug("sendReply: acquireDestroyLock failed due to cache closure, region = {}", (Object)map.getFullPath());
                            }
                        }
                        try {
                            it = bucketKeys != null ? bucketKeys.get(map.getId()).iterator() : (regex == null ? new HashSet(map.keySet(allowTombstones)).iterator() : map.getKeysWithInterest(1, regex, allowTombstones).iterator());
                            while (it.hasNext()) {
                                Set<InternalDistributedMember> failures;
                                Object key = it.next();
                                VersionTagHolder clientEvent = new VersionTagHolder();
                                Object value = map.get(key, null, true, true, true, null, clientEvent, allowTombstones);
                                if (needToWriteBucketInfo) {
                                    DataSerializer.writePrimitiveInt(map.getId(), mos);
                                    needToWriteBucketInfo = false;
                                    writeFooter = true;
                                }
                                int entrySize = mos.size();
                                DataSerializer.writeObject(key, mos);
                                VersionTag versionTag = clientEvent.getVersionTag();
                                if (versionTag != null) {
                                    versionTag.replaceNullIDs(map.getVersionMember());
                                }
                                DataSerializer.writeObject(value, mos);
                                DataSerializer.writeObject(versionTag, mos);
                                entrySize = mos.size() - entrySize;
                                if (mos.size() + entrySize >= InitialImageOperation.CHUNK_SIZE_IN_BYTES || !it.hasNext()) {
                                    DataSerializer.writeObject(null, mos);
                                    DataSerializer.writePrimitiveBoolean(it.hasNext(), mos);
                                    needToWriteBucketInfo = true;
                                    writeFooter = false;
                                }
                                if (mos.size() + entrySize < InitialImageOperation.CHUNK_SIZE_IN_BYTES) continue;
                                boolean lastMsg = !it.hasNext() && !mapsIterator.hasNext();
                                FetchBulkEntriesReplyMessage reply = new FetchBulkEntriesReplyMessage(recipient, processorId, mos, ++msgNum, lastMsg);
                                if (lastMsg) {
                                    reply.failedBucketIds = failedBuckets;
                                }
                                boolean bl = keepGoing = (failures = dm.putOutgoing(reply)) == null || failures.size() == 0;
                                if (lastMsg && keepGoing) {
                                    lastMsgSent = true;
                                }
                                mos.reset();
                            }
                            if (keepGoing) continue;
                            throw new ForceReattemptException("Failed to send response");
                        }
                        catch (IOException ioe) {
                            throw new ForceReattemptException("Unable to send response to fetch-entries request", ioe);
                        }
                        finally {
                            if (!lockAcquired) continue;
                            try {
                                map.releaseDestroyLock();
                            }
                            catch (CancelException cancelException) {}
                            continue;
                            finally {
                                lockAcquired = false;
                            }
                        }
                    }
                    if (lastMsgSent) break block61;
                    if (mos.size() == 0) {
                        try {
                            DataSerializer.writePrimitiveInt(-1, mos);
                        }
                        catch (IOException ioe) {
                            throw new ForceReattemptException("Unable to send response to fetch-entries request", ioe);
                        }
                    }
                    if (writeFooter) {
                        try {
                            DataSerializer.writeObject(null, mos);
                            DataSerializer.writePrimitiveBoolean(false, mos);
                        }
                        catch (IOException ioe) {
                            throw new ForceReattemptException("Unable to send response to fetch-entries request", ioe);
                        }
                    }
                    FetchBulkEntriesReplyMessage reply = new FetchBulkEntriesReplyMessage(recipient, processorId, mos, ++msgNum, true);
                    reply.failedBucketIds = failedBuckets;
                    Set<InternalDistributedMember> failures = dm.putOutgoing(reply);
                    if (failures != null && failures.size() > 0) {
                        throw new ForceReattemptException("Failed to send response");
                    }
                }
            }
            if (lockAcquired) {
                try {
                    map.releaseDestroyLock();
                }
                catch (CancelException cancelException) {
                }
                finally {
                    lockAcquired = false;
                }
            }
        }

        @Override
        public void process(DistributionManager dm, ReplyProcessor21 p) {
            long startTime = this.getTimestamp();
            FetchBulkEntriesResponse processor = (FetchBulkEntriesResponse)p;
            if (processor == null) {
                if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                    logger.trace(LogMarker.DM_VERBOSE, "FetchBulkEntriesReplyMessage processor not found");
                }
                return;
            }
            processor.processChunkResponse(this);
            if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                logger.trace(LogMarker.DM_VERBOSE, "{} processed {}", (Object)processor, (Object)this);
            }
            dm.getStats().incReplyMessageTime(DistributionStats.getStatTime() - startTime);
        }

        @Override
        public void toData(DataOutput out, SerializationContext context) throws IOException {
            super.toData(out, context);
            out.writeBoolean(this.lastInSeries);
            DataSerializer.writePrimitiveInt(this.msgNum, out);
            DataSerializer.writeObjectAsByteArray(this.chunkStream, out);
            DataSerializer.writeHashSet(this.failedBucketIds, out);
        }

        @Override
        public int getDSFID() {
            return 166;
        }

        @Override
        public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
            super.fromData(in, context);
            this.lastInSeries = in.readBoolean();
            this.msgNum = DataSerializer.readPrimitiveInt(in);
            this.chunk = DataSerializer.readByteArray(in);
            this.failedBucketIds = DataSerializer.readHashSet(in);
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("FetchBulkEntriesReplyMessage ").append("processorid=").append(this.processorId);
            if (this.getSender() != null) {
                sb.append(",sender=").append(this.getSender());
            }
            sb.append(",lastInSeries=").append(this.lastInSeries);
            if (this.chunk != null) {
                sb.append(",size=").append(this.chunk.length);
            } else if (this.chunkStream != null) {
                sb.append(",size=").append(this.chunkStream.size());
            }
            if (this.getException() != null) {
                sb.append(",exception=").append(this.getException());
            }
            return sb.toString();
        }
    }
}

