/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.geode.CancelException;
import org.apache.geode.SystemFailure;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.CacheClientStatus;
import org.apache.geode.internal.cache.IncomingGatewayStatus;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.TXId;
import org.apache.geode.internal.cache.TXManagerImpl;
import org.apache.geode.internal.cache.tier.Acceptor;
import org.apache.geode.internal.cache.tier.ServerSideHandshake;
import org.apache.geode.internal.cache.tier.sockets.CacheClientNotifier;
import org.apache.geode.internal.cache.tier.sockets.CacheClientNotifierStats;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.cache.tier.sockets.ServerConnectionCollection;
import org.apache.geode.internal.lang.JavaWorkarounds;
import org.apache.geode.logging.internal.executors.LoggingThread;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class ClientHealthMonitor {
    private static final Logger logger = LogService.getLogger();
    public static final String CLIENT_HEALTH_MONITOR_INTERVAL_PROPERTY = "geode.client-health-monitor-interval";
    private final ConcurrentMap<ClientProxyMembershipID, AtomicLong> clientHeartbeats = new ConcurrentHashMap<ClientProxyMembershipID, AtomicLong>();
    private final ConcurrentMap<ClientProxyMembershipID, Integer> clientMaximumTimeBetweenPings = new ConcurrentHashMap<ClientProxyMembershipID, Integer>();
    private final InternalCache cache;
    private final int maximumTimeBetweenPings;
    private final ClientHealthMonitorThread clientMonitor;
    @MakeNotStatic
    private static ClientHealthMonitor instance;
    @MakeNotStatic
    private static int refCount;
    private static final long DEFAULT_CLIENT_MONITOR_INTERVAL_IN_MILLIS = 1000L;
    private final CacheClientNotifierStats stats;
    private final HashMap<ServerSideHandshake, MutableInt> cleanupTable = new HashMap();
    private final HashMap<ClientProxyMembershipID, MutableInt> cleanupProxyIdTable = new HashMap();
    private final HashMap<ClientProxyMembershipID, ServerConnectionCollection> proxyIdConnections = new HashMap();
    AtomicInteger numberOfClientsWithConflationOff = new AtomicInteger(0);
    private final long monitorInterval;

    public int getMaximumTimeBetweenPings() {
        return this.maximumTimeBetweenPings;
    }

    public long getMonitorInterval() {
        return this.monitorInterval;
    }

    public static ClientHealthMonitor getInstance(InternalCache cache, int maximumTimeBetweenPings, CacheClientNotifierStats stats) {
        ClientHealthMonitor.createInstance(cache, maximumTimeBetweenPings, stats);
        return instance;
    }

    public static ClientHealthMonitor getInstance() {
        return instance;
    }

    public static synchronized void shutdownInstance() {
        --refCount;
        if (instance == null) {
            return;
        }
        if (refCount > 0) {
            return;
        }
        instance.shutdown();
        boolean interrupted = false;
        try {
            if (ClientHealthMonitor.instance.clientMonitor != null) {
                ClientHealthMonitor.instance.clientMonitor.join();
            }
        }
        catch (InterruptedException e) {
            interrupted = true;
            if (logger.isDebugEnabled()) {
                logger.debug(":Interrupted joining with the ClientHealthMonitor Thread", (Throwable)e);
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
        instance = null;
        refCount = 0;
    }

    public void registerClient(ClientProxyMembershipID proxyID) {
        this.registerClient(proxyID, this.maximumTimeBetweenPings);
    }

    public void registerClient(ClientProxyMembershipID proxyID, int maximumTimeBetweenPings) {
        if (!this.clientMaximumTimeBetweenPings.containsKey(proxyID)) {
            this.clientMaximumTimeBetweenPings.putIfAbsent(proxyID, maximumTimeBetweenPings);
        }
        if (!this.clientHeartbeats.containsKey(proxyID) && null == this.clientHeartbeats.putIfAbsent(proxyID, new AtomicLong(System.currentTimeMillis()))) {
            if (this.stats != null) {
                this.stats.incClientRegisterRequests();
            }
            if (logger.isDebugEnabled()) {
                logger.debug("ClientHealthMonitor: Registering client with member id {}", (Object)proxyID);
            }
        }
    }

    private void unregisterClient(ClientProxyMembershipID proxyID, boolean clientDisconnectedCleanly, Throwable clientDisconnectException) {
        if (this.clientHeartbeats.remove(proxyID) != null) {
            if (clientDisconnectedCleanly) {
                if (logger.isDebugEnabled()) {
                    logger.debug("ClientHealthMonitor: Unregistering client with member id {}", (Object)proxyID);
                }
            } else {
                logger.warn("ClientHealthMonitor: Unregistering client with member id {} due to: {}", (Object)proxyID, (Object)(clientDisconnectException == null ? "Unknown reason" : clientDisconnectException.getLocalizedMessage()));
            }
            if (this.stats != null) {
                this.stats.incClientUnRegisterRequests();
            }
            this.expireTXStates(proxyID);
        }
        this.clientMaximumTimeBetweenPings.remove(proxyID);
    }

    void unregisterClient(ClientProxyMembershipID proxyID, Acceptor acceptor, boolean clientDisconnectedCleanly, Throwable clientDisconnectException) {
        CacheClientNotifier ccn;
        this.unregisterClient(proxyID, clientDisconnectedCleanly, clientDisconnectException);
        if (acceptor != null && (ccn = acceptor.getCacheClientNotifier()) != null) {
            try {
                ccn.unregisterClient(proxyID, clientDisconnectedCleanly);
            }
            catch (CancelException cancelException) {
                // empty catch block
            }
        }
    }

    public Set<TXId> getScheduledToBeRemovedTx() {
        TXManagerImpl txMgr = (TXManagerImpl)this.cache.getCacheTransactionManager();
        return txMgr.getScheduledToBeRemovedTx();
    }

    private void expireTXStates(ClientProxyMembershipID proxyID) {
        if (this.cache.isClosed()) {
            return;
        }
        TXManagerImpl txMgr = (TXManagerImpl)this.cache.getCacheTransactionManager();
        if (null == txMgr) {
            return;
        }
        Set<TXId> txIds = txMgr.getTransactionsForClient((InternalDistributedMember)proxyID.getDistributedMember());
        if (!txIds.isEmpty()) {
            txMgr.expireDisconnectedClientTransactions(txIds, true);
        }
    }

    public void removeAllConnectionsAndUnregisterClient(ClientProxyMembershipID proxyID, Throwable t) {
        this.cleanupClientThreads(proxyID, false);
        this.unregisterClient(proxyID, false, t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerConnectionCollection addConnection(ClientProxyMembershipID proxyID, ServerConnection connection) {
        HashMap<ClientProxyMembershipID, ServerConnectionCollection> hashMap = this.proxyIdConnections;
        synchronized (hashMap) {
            ServerConnectionCollection collection = this.getProxyIdCollection(proxyID);
            collection.addConnection(connection);
            return collection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeConnection(ClientProxyMembershipID proxyID, ServerConnection connection) {
        HashMap<ClientProxyMembershipID, ServerConnectionCollection> hashMap = this.proxyIdConnections;
        synchronized (hashMap) {
            ServerConnectionCollection collection = this.proxyIdConnections.get(proxyID);
            if (collection != null) {
                collection.removeConnection(connection);
                if (collection.getConnections().isEmpty()) {
                    this.proxyIdConnections.remove(proxyID);
                }
            }
        }
    }

    public void receivedPing(ClientProxyMembershipID proxyID) {
        AtomicLong heartbeat;
        if (this.clientMonitor == null) {
            return;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("ClientHealthMonitor: Received ping from client with member id {}", (Object)proxyID);
        }
        if (null == (heartbeat = (AtomicLong)this.clientHeartbeats.get(proxyID))) {
            this.registerClient(proxyID, this.getMaximumTimeBetweenPings(proxyID));
        } else {
            heartbeat.set(System.currentTimeMillis());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object[]> getConnectedClients(Set<ClientProxyMembershipID> filterProxies) {
        HashMap<String, Object[]> map = new HashMap<String, Object[]>();
        HashMap<ClientProxyMembershipID, ServerConnectionCollection> hashMap = this.proxyIdConnections;
        synchronized (hashMap) {
            for (Map.Entry<ClientProxyMembershipID, ServerConnectionCollection> entry : this.proxyIdConnections.entrySet()) {
                ClientProxyMembershipID proxyID = entry.getKey();
                if (filterProxies != null && !filterProxies.contains(proxyID)) continue;
                String membershipID = null;
                Set<ServerConnection> connections = entry.getValue().getConnections();
                int socketPort = 0;
                InetAddress socketAddress = null;
                Iterator<ServerConnection> iterator = connections.iterator();
                if (iterator.hasNext()) {
                    ServerConnection sc = iterator.next();
                    socketPort = sc.getSocketPort();
                    socketAddress = sc.getSocketAddress();
                    membershipID = sc.getMembershipID();
                }
                int connectionCount = connections.size();
                String clientString = socketAddress == null ? "client member id=" + membershipID : "host name=" + socketAddress.toString() + " host ip=" + socketAddress.getHostAddress() + " client port=" + socketPort + " client member id=" + membershipID;
                Object[] data = (Object[])map.get(membershipID);
                if (data == null) {
                    map.put(membershipID, new Object[]{clientString, connectionCount});
                    continue;
                }
                data[1] = (Integer)data[1] + connectionCount;
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<ClientProxyMembershipID, CacheClientStatus> getStatusForAllClients() {
        HashMap<ClientProxyMembershipID, CacheClientStatus> result = new HashMap<ClientProxyMembershipID, CacheClientStatus>();
        HashMap<ClientProxyMembershipID, ServerConnectionCollection> hashMap = this.proxyIdConnections;
        synchronized (hashMap) {
            block3: for (Map.Entry<ClientProxyMembershipID, ServerConnectionCollection> entry : this.proxyIdConnections.entrySet()) {
                ClientProxyMembershipID proxyID = entry.getKey();
                CacheClientStatus cci = new CacheClientStatus(proxyID);
                Set<ServerConnection> connections = entry.getValue().getConnections();
                if (connections == null) continue;
                for (ServerConnection sc : connections) {
                    if (!sc.isClientServerConnection()) continue;
                    String memberId = sc.getMembershipID();
                    cci.setMemberId(memberId);
                    cci.setNumberOfConnections(connections.size());
                    result.put(proxyID, cci);
                    continue block3;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillInClientInfo(Map<ClientProxyMembershipID, CacheClientStatus> allClients) {
        HashMap<ClientProxyMembershipID, ServerConnectionCollection> hashMap = this.proxyIdConnections;
        synchronized (hashMap) {
            for (Map.Entry<ClientProxyMembershipID, CacheClientStatus> entry : allClients.entrySet()) {
                ClientProxyMembershipID proxyID = entry.getKey();
                CacheClientStatus cci = entry.getValue();
                ServerConnectionCollection collection = this.proxyIdConnections.get(proxyID);
                Set<ServerConnection> connections = collection != null ? collection.getConnections() : null;
                if (connections == null) continue;
                String memberId = null;
                cci.setNumberOfConnections(connections.size());
                ArrayList<Integer> socketPorts = new ArrayList<Integer>();
                ArrayList<InetAddress> socketAddresses = new ArrayList<InetAddress>();
                for (ServerConnection sc : connections) {
                    socketPorts.add(sc.getSocketPort());
                    socketAddresses.add(sc.getSocketAddress());
                    memberId = sc.getMembershipID();
                }
                cci.setMemberId(memberId);
                cci.setSocketPorts(socketPorts);
                cci.setSocketAddresses(socketAddresses);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, IncomingGatewayStatus> getConnectedIncomingGateways() {
        HashMap<String, IncomingGatewayStatus> connectedIncomingGateways = new HashMap<String, IncomingGatewayStatus>();
        HashMap<ClientProxyMembershipID, ServerConnectionCollection> hashMap = this.proxyIdConnections;
        synchronized (hashMap) {
            for (Map.Entry<ClientProxyMembershipID, ServerConnectionCollection> entry : this.proxyIdConnections.entrySet()) {
                ClientProxyMembershipID proxyID = entry.getKey();
                Set<ServerConnection> connections = entry.getValue().getConnections();
                for (ServerConnection sc : connections) {
                    if (!sc.getCommunicationMode().isWAN()) continue;
                    IncomingGatewayStatus status = new IncomingGatewayStatus(proxyID.getDSMembership(), sc.getSocketAddress(), sc.getSocketPort());
                    connectedIncomingGateways.put(proxyID.getDSMembership(), status);
                }
            }
        }
        return connectedIncomingGateways;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean cleanupClientThreads(ClientProxyMembershipID proxyID, boolean timedOut) {
        boolean result = false;
        Set<ServerConnection> serverConnections = null;
        HashMap<ClientProxyMembershipID, ServerConnectionCollection> hashMap = this.proxyIdConnections;
        synchronized (hashMap) {
            ServerConnectionCollection collection = this.proxyIdConnections.remove(proxyID);
            if (collection != null) {
                serverConnections = collection.getConnections();
            }
        }
        if (serverConnections != null) {
            result = true;
            for (ServerConnection serverConnection : serverConnections) {
                serverConnection.handleTermination(timedOut);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean prepareToTerminateIfNoConnectionIsProcessing(ClientProxyMembershipID proxyID) {
        HashMap<ClientProxyMembershipID, ServerConnectionCollection> hashMap = this.proxyIdConnections;
        synchronized (hashMap) {
            ServerConnectionCollection collection = this.proxyIdConnections.get(proxyID);
            if (collection == null) {
                return true;
            }
            if (collection.connectionsProcessing.get() == 0) {
                collection.isTerminating = true;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateThreads(ClientProxyMembershipID proxyID) {
        HashSet<ServerConnection> serverConnections;
        HashMap<ClientProxyMembershipID, ServerConnectionCollection> hashMap = this.proxyIdConnections;
        synchronized (hashMap) {
            ServerConnectionCollection collection = this.proxyIdConnections.get(proxyID);
            serverConnections = collection != null ? new HashSet<ServerConnection>(collection.getConnections()) : Collections.emptySet();
        }
        for (ServerConnection serverConnection : serverConnections) {
            if (!serverConnection.hasBeenTimedOutOnClient()) continue;
            logger.warn("{} is being terminated because its client timeout of {} has expired.", (Object)serverConnection, (Object)serverConnection.getClientReadTimeout());
            try {
                serverConnection.handleTermination(true);
            }
            finally {
                this.removeConnection(proxyID, serverConnection);
            }
        }
    }

    @VisibleForTesting
    Map<ClientProxyMembershipID, Long> getClientHeartbeats() {
        return this.clientHeartbeats.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((AtomicLong)entry.getValue()).get()));
    }

    protected synchronized void shutdown() {
        if (this.clientMonitor != null) {
            this.clientMonitor.stopMonitoring();
        }
    }

    protected static synchronized void createInstance(InternalCache cache, int maximumTimeBetweenPings, CacheClientNotifierStats stats) {
        ++refCount;
        if (instance != null) {
            return;
        }
        instance = new ClientHealthMonitor(cache, maximumTimeBetweenPings, stats);
    }

    private ClientHealthMonitor(InternalCache cache, int maximumTimeBetweenPings, CacheClientNotifierStats stats) {
        this.cache = cache;
        this.maximumTimeBetweenPings = maximumTimeBetweenPings;
        this.monitorInterval = Long.getLong(CLIENT_HEALTH_MONITOR_INTERVAL_PROPERTY, 1000L);
        logger.debug("Setting monitorInterval to {}", (Object)this.monitorInterval);
        if (maximumTimeBetweenPings > 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Initializing client health monitor thread", (Object)this);
            }
            this.clientMonitor = new ClientHealthMonitorThread(maximumTimeBetweenPings);
            this.clientMonitor.start();
        } else {
            logger.info("Client health monitor thread disabled due to maximumTimeBetweenPings setting: {}", (Object)maximumTimeBetweenPings);
            this.clientMonitor = null;
        }
        this.stats = stats;
    }

    public String toString() {
        return "ClientHealthMonitor@" + Integer.toHexString(System.identityHashCode(this));
    }

    private ServerConnectionCollection getProxyIdCollection(ClientProxyMembershipID proxyID) {
        return (ServerConnectionCollection)JavaWorkarounds.computeIfAbsent(this.proxyIdConnections, (Object)proxyID, key -> new ServerConnectionCollection());
    }

    Map<ClientProxyMembershipID, MutableInt> getCleanupProxyIdTable() {
        return this.cleanupProxyIdTable;
    }

    Map<ServerSideHandshake, MutableInt> getCleanupTable() {
        return this.cleanupTable;
    }

    public boolean hasDeltaClients() {
        return this.numberOfClientsWithConflationOff.get() > 0;
    }

    private int getMaximumTimeBetweenPings(ClientProxyMembershipID proxyID) {
        return this.clientMaximumTimeBetweenPings.getOrDefault(proxyID, this.maximumTimeBetweenPings);
    }

    @VisibleForTesting
    void testUseCustomHeartbeatCheck(HeartbeatTimeoutCheck check) {
        this.clientMonitor.overrideHeartbeatTimeoutCheck(check);
    }

    @VisibleForTesting
    public static ClientHealthMonitorProvider singletonProvider() {
        return ClientHealthMonitor::getInstance;
    }

    @VisibleForTesting
    public static Supplier<ClientHealthMonitor> singletonGetter() {
        return ClientHealthMonitor::getInstance;
    }

    static {
        refCount = 0;
    }

    @FunctionalInterface
    @VisibleForTesting
    public static interface ClientHealthMonitorProvider {
        public ClientHealthMonitor get(InternalCache var1, int var2, CacheClientNotifierStats var3);
    }

    class ClientHealthMonitorThread
    extends LoggingThread {
        private HeartbeatTimeoutCheck checkHeartbeat;
        final int _maximumTimeBetweenPings;
        volatile boolean _isStopped;

        void overrideHeartbeatTimeoutCheck(HeartbeatTimeoutCheck newCheck) {
            this.checkHeartbeat = newCheck;
        }

        ClientHealthMonitorThread(int maximumTimeBetweenPings) {
            super("ClientHealthMonitor Thread");
            this.checkHeartbeat = (currentTime, lastHeartbeat, allowedInterval) -> currentTime - lastHeartbeat > allowedInterval;
            this._isStopped = false;
            this._maximumTimeBetweenPings = maximumTimeBetweenPings;
            logger.info("ClientHealthMonitorThread maximum allowed time between pings: {}", (Object)this._maximumTimeBetweenPings);
            if (maximumTimeBetweenPings == 0 && logger.isDebugEnabled()) {
                logger.debug("zero ping interval detected", (Throwable)new Exception("stack trace"));
            }
        }

        protected synchronized void stopMonitoring() {
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Stopping monitoring", (Object)ClientHealthMonitor.this);
            }
            this._isStopped = true;
            this.interrupt();
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Stopped dispatching", (Object)ClientHealthMonitor.this);
            }
        }

        protected boolean isStopped() {
            return this._isStopped;
        }

        public void run() {
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Beginning to monitor clients", (Object)ClientHealthMonitor.this);
            }
            while (!this._isStopped) {
                SystemFailure.checkFailure();
                try {
                    Thread.sleep(ClientHealthMonitor.this.monitorInterval);
                    if (logger.isTraceEnabled()) {
                        logger.trace("Monitoring {} client(s)", (Object)ClientHealthMonitor.this.getClientHeartbeats().size());
                    }
                    long currentTime = System.currentTimeMillis();
                    if (logger.isTraceEnabled()) {
                        logger.trace("{} starting sweep at {}", (Object)ClientHealthMonitor.this, (Object)currentTime);
                    }
                    for (Map.Entry<ClientProxyMembershipID, Long> entry : ClientHealthMonitor.this.getClientHeartbeats().entrySet()) {
                        int maximumTimeBetweenPingsForClient;
                        ClientProxyMembershipID proxyID = entry.getKey();
                        ClientHealthMonitor.this.validateThreads(proxyID);
                        Long latestHeartbeatValue = entry.getValue();
                        if (latestHeartbeatValue == null) continue;
                        long latestHeartbeat = latestHeartbeatValue;
                        if (logger.isTraceEnabled()) {
                            logger.trace("{} ms have elapsed since the latest heartbeat for client with member id {}", (Object)(currentTime - latestHeartbeat), (Object)proxyID);
                        }
                        if (this.checkHeartbeat.timedOut(currentTime, latestHeartbeat, maximumTimeBetweenPingsForClient = ClientHealthMonitor.this.getMaximumTimeBetweenPings(proxyID))) {
                            if (ClientHealthMonitor.this.prepareToTerminateIfNoConnectionIsProcessing(proxyID)) {
                                if (!ClientHealthMonitor.this.cleanupClientThreads(proxyID, true)) continue;
                                logger.warn("Monitoring client with member id {}. It had been {} ms since the latest heartbeat. Max interval is {}. Terminated client.", (Object)entry.getKey(), (Object)(currentTime - latestHeartbeat), (Object)maximumTimeBetweenPingsForClient);
                                continue;
                            }
                            if (!logger.isDebugEnabled()) continue;
                            logger.debug("Monitoring client with member id {}. It has been {} ms since the latest heartbeat. This client would have been terminated but at least one of its threads is processing a message.", (Object)entry.getKey(), (Object)(currentTime - latestHeartbeat));
                            continue;
                        }
                        if (!logger.isTraceEnabled()) continue;
                        logger.trace("Monitoring client with member id {}. It has been {} ms since the latest heartbeat. This client is healthy.", (Object)entry.getKey(), (Object)(currentTime - latestHeartbeat));
                    }
                }
                catch (InterruptedException e) {
                    if (this._isStopped) break;
                    logger.warn("Unexpected interrupt, exiting", (Throwable)e);
                    break;
                }
                catch (Exception e) {
                    if (this._isStopped) continue;
                    logger.fatal(ClientHealthMonitor.this.toString() + ": An unexpected Exception occurred", (Throwable)e);
                }
            }
        }
    }

    static interface HeartbeatTimeoutCheck {
        public boolean timedOut(long var1, long var3, long var5);
    }
}

