/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.cache.DynamicRegionFactory;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.ResourceException;
import org.apache.geode.cache.operations.RemoveAllOperationContext;
import org.apache.geode.distributed.internal.DistributionStats;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.PutAllPartialResultException;
import org.apache.geode.internal.cache.ha.ThreadIdentifier;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.CacheServerStats;
import org.apache.geode.internal.cache.tier.sockets.ChunkedMessage;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.cache.tier.sockets.VersionedObjectList;
import org.apache.geode.internal.cache.versions.VersionTag;
import org.apache.geode.internal.security.AuthorizeRequest;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.internal.util.Breadcrumbs;
import org.apache.geode.security.ResourcePermission;
import org.apache.geode.util.internal.UncheckedUtils;

public class RemoveAll
extends BaseCommand {
    @Immutable
    private static final RemoveAll singleton = new RemoveAll();

    public static Command getCommand() {
        return singleton;
    }

    protected RemoveAll() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cmdExecute(Message clientMessage, ServerConnection serverConnection, SecurityService securityService, long startp) throws IOException, InterruptedException {
        VersionedObjectList response;
        String regionName;
        long start = startp;
        CacheServerStats stats = serverConnection.getCacheServerStats();
        serverConnection.setAsTrue(2);
        serverConnection.setAsTrue(3);
        long oldStart = start;
        start = DistributionStats.getStatTime();
        stats.incReadRemoveAllRequestTime(start - oldStart);
        boolean replyWithMetaData = false;
        try {
            PartitionedRegion pr;
            Part regionNamePart = clientMessage.getPart(0);
            regionName = regionNamePart.getCachedString();
            StringBuilder errMessage = new StringBuilder();
            if (regionName == null) {
                String txt = "The input region name for the removeAll request is null";
                logger.warn("{} : {}", new Object[]{serverConnection.getName(), txt});
                errMessage.append(txt);
                RemoveAll.writeChunkedErrorResponse(clientMessage, 8, errMessage.toString(), serverConnection);
                serverConnection.setAsTrue(1);
                return;
            }
            LocalRegion region = (LocalRegion)serverConnection.getCache().getRegion(regionName);
            if (region == null) {
                String reason = " was not found during removeAll request";
                RemoveAll.writeRegionDestroyedEx(clientMessage, regionName, reason, serverConnection);
                serverConnection.setAsTrue(1);
                return;
            }
            Part eventPart = clientMessage.getPart(1);
            ByteBuffer eventIdPartsBuffer = ByteBuffer.wrap(eventPart.getSerializedForm());
            long threadId = EventID.readEventIdPartsFromOptmizedByteArray(eventIdPartsBuffer);
            long sequenceId = EventID.readEventIdPartsFromOptmizedByteArray(eventIdPartsBuffer);
            EventID eventId = new EventID(serverConnection.getEventMemberIDByteArray(), threadId, sequenceId);
            Breadcrumbs.setEventId(eventId);
            int flags = clientMessage.getPart(2).getInt();
            boolean clientIsEmpty = (flags & 1) != 0;
            boolean clientHasCCEnabled = (flags & 2) != 0;
            Object callbackArg = clientMessage.getPart(3).getObject();
            Part numberOfKeysPart = clientMessage.getPart(4);
            int numberOfKeys = numberOfKeysPart.getInt();
            if (logger.isDebugEnabled()) {
                StringBuilder buffer = new StringBuilder();
                buffer.append(serverConnection.getName()).append(": Received removeAll request from ").append(serverConnection.getSocketString()).append(" for region ").append(regionName).append(callbackArg != null ? " callbackArg " + callbackArg : "").append(" with ").append(numberOfKeys).append(" keys.");
                logger.debug((CharSequence)buffer);
            }
            ArrayList<Object> keys = new ArrayList<Object>(numberOfKeys);
            ArrayList retryVersions = new ArrayList(numberOfKeys);
            for (int i = 0; i < numberOfKeys; ++i) {
                Part keyPart = clientMessage.getPart(5 + i);
                Object key = keyPart.getStringOrObject();
                if (key == null) {
                    String txt = "One of the input keys for the removeAll request is null";
                    logger.warn("{} : {}", new Object[]{serverConnection.getName(), txt});
                    errMessage.append(txt);
                    RemoveAll.writeChunkedErrorResponse(clientMessage, 8, errMessage.toString(), serverConnection);
                    serverConnection.setAsTrue(1);
                    return;
                }
                if (clientMessage.isRetry()) {
                    EventID entryEventId = new EventID(eventId, i);
                    if (region instanceof PartitionedRegion) {
                        PartitionedRegion pr2 = (PartitionedRegion)region;
                        int bucketId = pr2.getKeyInfo(key).getBucketId();
                        long entryThreadId = ThreadIdentifier.createFakeThreadIDForBulkOp(bucketId, entryEventId.getThreadID());
                        entryEventId = new EventID(entryEventId.getMembershipID(), entryThreadId, entryEventId.getSequenceID());
                    }
                    VersionTag<?> tag = this.findVersionTagsForRetriedBulkOp(region, entryEventId);
                    retryVersions.add(tag);
                } else {
                    retryVersions.add(null);
                }
                keys.add(key);
            }
            if (clientMessage.getNumberOfParts() == 5 + numberOfKeys + 1) {
                int timeout = clientMessage.getPart(5 + numberOfKeys).getInt();
                serverConnection.setRequestSpecificTimeout(timeout);
            }
            securityService.authorize(ResourcePermission.Resource.DATA, ResourcePermission.Operation.WRITE, regionName);
            AuthorizeRequest authzRequest = serverConnection.getAuthzRequest();
            if (authzRequest != null) {
                if (DynamicRegionFactory.regionIsDynamicRegionList(regionName)) {
                    authzRequest.createRegionAuthorize(regionName);
                } else {
                    RemoveAllOperationContext removeAllContext = authzRequest.removeAllAuthorize(regionName, keys, callbackArg);
                    callbackArg = removeAllContext.getCallbackArg();
                }
            }
            response = region.basicBridgeRemoveAll(keys, (ArrayList)UncheckedUtils.uncheckedCast(retryVersions), serverConnection.getProxyID(), eventId, callbackArg);
            if (!region.getConcurrencyChecksEnabled() || clientIsEmpty || !clientHasCCEnabled) {
                if (logger.isTraceEnabled()) {
                    logger.trace("setting removeAll response to null. region-cc-enabled={}; clientIsEmpty={}; client-cc-enabled={}", (Object)region.getConcurrencyChecksEnabled(), (Object)clientIsEmpty, (Object)clientHasCCEnabled);
                }
                response = null;
            }
            if (region instanceof PartitionedRegion && (pr = (PartitionedRegion)region).getNetworkHopType() != 0) {
                this.writeReplyWithRefreshMetadata(clientMessage, response, serverConnection, pr, pr.getNetworkHopType());
                pr.clearNetworkHopData();
                replyWithMetaData = true;
            }
        }
        catch (RegionDestroyedException | ResourceException | PutAllPartialResultException rde) {
            RemoveAll.writeChunkedException(clientMessage, rde, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        catch (Exception ce) {
            RemoveAll.checkForInterrupt(serverConnection, ce);
            RemoveAll.writeChunkedException(clientMessage, ce, serverConnection);
            serverConnection.setAsTrue(1);
            logger.warn(String.format("%s: Unexpected Exception", serverConnection.getName()), (Throwable)ce);
            return;
        }
        finally {
            long oldStart2 = start;
            start = DistributionStats.getStatTime();
            stats.incProcessRemoveAllTime(start - oldStart2);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Sending removeAll response back to {} for region {}{}", (Object)serverConnection.getName(), (Object)serverConnection.getSocketString(), (Object)regionName, (Object)(logger.isTraceEnabled() ? ": " + response : ""));
        }
        if (!replyWithMetaData) {
            this.writeReply(clientMessage, response, serverConnection);
        }
        serverConnection.setAsTrue(1);
        stats.incWriteRemoveAllResponseTime(DistributionStats.getStatTime() - start);
    }

    @Override
    protected void writeReply(Message origMsg, ServerConnection serverConnection) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected void writeReply(Message origMsg, VersionedObjectList response, ServerConnection servConn) throws IOException {
        int listSize;
        servConn.getCache().getCancelCriterion().checkCancelInProgress(null);
        ChunkedMessage replyMsg = servConn.getChunkedResponseMessage();
        replyMsg.setMessageType(1);
        replyMsg.setTransactionId(origMsg.getTransactionId());
        int n = listSize = response == null ? 0 : response.size();
        if (response != null) {
            response.setKeys(null);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("sending chunked response header.  version list size={}{}", (Object)listSize, (Object)(logger.isTraceEnabled() ? " list=" + response : ""));
        }
        replyMsg.sendHeader();
        if (listSize > 0) {
            int chunkSize = 2 * MAXIMUM_CHUNK_SIZE;
            VersionedObjectList.Chunker chunk = new VersionedObjectList.Chunker(response, chunkSize, false, false);
            for (int i = 0; i < listSize; i += chunkSize) {
                boolean lastChunk = i + chunkSize >= listSize;
                replyMsg.setNumberOfParts(1);
                replyMsg.setMessageType(1);
                replyMsg.setLastChunk(lastChunk);
                replyMsg.setTransactionId(origMsg.getTransactionId());
                replyMsg.addObjPart(chunk);
                if (logger.isDebugEnabled()) {
                    logger.debug("sending chunk at index {} last chunk={} numParts={}", (Object)i, (Object)lastChunk, (Object)replyMsg.getNumberOfParts());
                }
                replyMsg.sendChunk(servConn);
            }
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("sending only header");
            }
            replyMsg.addObjPart(null);
            replyMsg.setLastChunk(true);
            replyMsg.sendChunk(servConn);
        }
        servConn.setAsTrue(1);
        if (logger.isTraceEnabled()) {
            logger.trace("{}: rpl tx: {}", (Object)servConn.getName(), (Object)origMsg.getTransactionId());
        }
    }

    private void writeReplyWithRefreshMetadata(Message origMsg, VersionedObjectList response, ServerConnection servConn, PartitionedRegion pr, byte nwHop) throws IOException {
        int listSize;
        servConn.getCache().getCancelCriterion().checkCancelInProgress(null);
        ChunkedMessage replyMsg = servConn.getChunkedResponseMessage();
        replyMsg.setMessageType(1);
        replyMsg.setTransactionId(origMsg.getTransactionId());
        replyMsg.sendHeader();
        int n = listSize = response == null ? 0 : response.size();
        if (logger.isDebugEnabled()) {
            logger.debug("sending chunked response header with metadata refresh status. Version list size = {}{}", (Object)listSize, (Object)(logger.isTraceEnabled() ? "; list=" + response : ""));
        }
        if (response != null) {
            response.setKeys(null);
        }
        replyMsg.setNumberOfParts(1);
        replyMsg.setTransactionId(origMsg.getTransactionId());
        replyMsg.addBytesPart(new byte[]{pr.getMetadataVersion(), nwHop});
        if (listSize > 0) {
            replyMsg.setLastChunk(false);
            replyMsg.sendChunk(servConn);
            int chunkSize = 2 * MAXIMUM_CHUNK_SIZE;
            VersionedObjectList.Chunker chunk = new VersionedObjectList.Chunker(response, chunkSize, false, false);
            for (int i = 0; i < listSize; i += chunkSize) {
                boolean lastChunk = i + chunkSize >= listSize;
                replyMsg.setNumberOfParts(1);
                replyMsg.setMessageType(1);
                replyMsg.setLastChunk(lastChunk);
                replyMsg.setTransactionId(origMsg.getTransactionId());
                replyMsg.addObjPart(chunk);
                if (logger.isDebugEnabled()) {
                    logger.debug("sending chunk at index {} last chunk={} numParts={}", (Object)i, (Object)lastChunk, (Object)replyMsg.getNumberOfParts());
                }
                replyMsg.sendChunk(servConn);
            }
        } else {
            replyMsg.setLastChunk(true);
            if (logger.isDebugEnabled()) {
                logger.debug("sending first and only part of chunked message");
            }
            replyMsg.sendChunk(servConn);
        }
        pr.getPrStats().incPRMetaDataSentCount();
        if (logger.isTraceEnabled()) {
            logger.trace("{}: rpl with REFRESH_METADATA tx: {}", (Object)servConn.getName(), (Object)origMsg.getTransactionId());
        }
    }
}

