/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.operation;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.control.RebalanceFactory;
import org.apache.geode.cache.control.RebalanceOperation;
import org.apache.geode.cache.control.RebalanceResults;
import org.apache.geode.cache.control.ResourceManager;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.geode.internal.serialization.Version;
import org.apache.geode.management.DistributedRegionMXBean;
import org.apache.geode.management.ManagementService;
import org.apache.geode.management.internal.MBeanJMXAdapter;
import org.apache.geode.management.internal.cli.functions.RebalanceFunction;
import org.apache.geode.management.internal.exceptions.NoMembersException;
import org.apache.geode.management.internal.operation.OperationPerformer;
import org.apache.geode.management.internal.operation.RebalanceRegionResultImpl;
import org.apache.geode.management.internal.operation.RebalanceResultImpl;
import org.apache.geode.management.internal.util.ManagementUtils;
import org.apache.geode.management.runtime.RebalanceRegionResult;
import org.apache.geode.management.runtime.RebalanceResult;
import org.jetbrains.annotations.NotNull;

@Experimental
public class RebalanceOperationPerformer
implements OperationPerformer<org.apache.geode.management.operation.RebalanceOperation, RebalanceResult> {
    @Override
    public RebalanceResult perform(Cache cache, org.apache.geode.management.operation.RebalanceOperation parameters) {
        List includeRegions = parameters.getIncludeRegions();
        List excludeRegions = parameters.getExcludeRegions();
        boolean simulate = parameters.isSimulate();
        RebalanceResultImpl result = new RebalanceResultImpl();
        result.setSuccess(false);
        if (!includeRegions.isEmpty()) {
            ArrayList<RebalanceRegionResult> rebalanceRegionResults = new ArrayList<RebalanceRegionResult>();
            Throwable latestNoMembersException = null;
            for (String regionName : includeRegions) {
                RebalanceRegionResult rebalanceResult;
                try {
                    rebalanceResult = this.performRebalance(cache, regionName, simulate);
                }
                catch (NoMembersException ex) {
                    latestNoMembersException = ex;
                    continue;
                }
                catch (Exception e) {
                    result.setStatusMessage(e.getMessage());
                    continue;
                }
                rebalanceRegionResults.add(rebalanceResult);
                result.setSuccess(true);
            }
            if (latestNoMembersException != null && !result.getSuccess()) {
                result.setStatusMessage(latestNoMembersException.getMessage());
            } else {
                result.setRebalanceSummary(rebalanceRegionResults);
            }
            return result;
        }
        result = (RebalanceResultImpl)this.executeRebalanceOnDS(ManagementService.getManagementService(cache), (InternalCache)cache, String.valueOf(simulate), excludeRegions, new FunctionExecutor());
        return result;
    }

    private RebalanceRegionResult performRebalance(Cache cache, String regionName, boolean simulate) throws InterruptedException {
        Region region = cache.getRegion(regionName = regionName.startsWith("/") ? regionName : "/" + regionName);
        if (region == null) {
            DistributedMember member = RebalanceOperationPerformer.getAssociatedMembers(regionName, (InternalCache)cache);
            if (member == null) {
                throw new NoMembersException(MessageFormat.format("For the region {0}, no member was found", regionName));
            }
            Object[] functionArgs = new Object[3];
            functionArgs[0] = simulate ? "true" : "false";
            HashSet<String> setRegionName = new HashSet<String>();
            setRegionName.add(regionName);
            functionArgs[1] = setRegionName;
            functionArgs[2] = null;
            Function function = this.getRebalanceFunction((InternalDistributedMember)member);
            List resultList = null;
            try {
                resultList = (List)ManagementUtils.executeFunction(function, functionArgs, Collections.singleton(member)).getResult();
            }
            catch (Exception exception) {
                // empty catch block
            }
            RebalanceRegionResultImpl result = new RebalanceRegionResultImpl();
            if (resultList != null && !resultList.isEmpty()) {
                List<String> rstList = Arrays.asList(((String)resultList.get(0)).split(","));
                result = RebalanceOperationPerformer.toRebalanceRegionResult(rstList);
            }
            return result;
        }
        ResourceManager manager = cache.getResourceManager();
        RebalanceFactory rbFactory = manager.createRebalanceFactory();
        HashSet<String> includeRegionSet = new HashSet<String>();
        includeRegionSet.add(regionName);
        rbFactory.includeRegions(includeRegionSet);
        RebalanceOperation op = simulate ? manager.createRebalanceFactory().simulate() : manager.createRebalanceFactory().start();
        RebalanceResults results = op.getResults();
        RebalanceRegionResultImpl result = new RebalanceRegionResultImpl();
        result.setRegionName(regionName.replace("/", ""));
        result.setBucketCreateBytes(results.getTotalBucketCreateBytes());
        result.setBucketCreateTimeInMilliseconds(results.getTotalBucketCreateTime());
        result.setBucketCreatesCompleted(results.getTotalBucketCreatesCompleted());
        result.setBucketTransferBytes(results.getTotalBucketTransferBytes());
        result.setBucketTransferTimeInMilliseconds(results.getTotalBucketTransferTime());
        result.setBucketTransfersCompleted(results.getTotalBucketTransfersCompleted());
        result.setPrimaryTransferTimeInMilliseconds(results.getTotalPrimaryTransferTime());
        result.setPrimaryTransfersCompleted(results.getTotalPrimaryTransfersCompleted());
        result.setNumOfMembers(results.getTotalMembersExecutedOn());
        result.setTimeInMilliseconds(results.getTotalTime());
        return result;
    }

    public static DistributedMember getAssociatedMembers(String region, InternalCache cache) {
        DistributedRegionMXBean bean = ManagementService.getManagementService(cache).getDistributedRegionMXBean(region);
        DistributedMember member = null;
        if (bean == null) {
            return null;
        }
        String[] membersName = bean.getMembers();
        Set<DistributedMember> dsMembers = ManagementUtils.getAllMembers(cache);
        Iterator<DistributedMember> it = dsMembers.iterator();
        boolean matchFound = false;
        if (membersName.length > 1) {
            block0: while (it.hasNext() && !matchFound) {
                DistributedMember dsMember = it.next();
                for (String memberName : membersName) {
                    if (!MBeanJMXAdapter.getMemberNameOrUniqueId(dsMember).equals(memberName)) continue;
                    member = dsMember;
                    matchFound = true;
                    continue block0;
                }
            }
        }
        return member;
    }

    public static List<MemberPRInfo> getMemberRegionList(ManagementService managementService, InternalCache cache, List<String> listExcludedRegion) {
        ArrayList<MemberPRInfo> listMemberPRInfo = new ArrayList<MemberPRInfo>();
        String[] listDSRegions = managementService.getDistributedSystemMXBean().listRegions();
        Set<DistributedMember> dsMembers = ManagementUtils.getAllMembers(cache);
        for (String regionName : listDSRegions) {
            DistributedRegionMXBean bean;
            boolean excludedRegionMatch = false;
            if (listExcludedRegion != null) {
                for (String aListExcludedRegion : listExcludedRegion) {
                    String excludedRegion = aListExcludedRegion.trim();
                    if (regionName.startsWith("/") && !excludedRegion.startsWith("/")) {
                        excludedRegion = "/" + excludedRegion;
                    }
                    if (excludedRegion.startsWith("/") && !regionName.startsWith("/")) {
                        regionName = "/" + regionName;
                    }
                    if (!excludedRegion.equals(regionName)) continue;
                    excludedRegionMatch = true;
                    break;
                }
            }
            if (excludedRegionMatch) continue;
            if (!regionName.startsWith("/")) {
                regionName = "/" + regionName;
            }
            if ((bean = managementService.getDistributedRegionMXBean(regionName)) == null || !bean.getRegionType().equals(DataPolicy.PARTITION.toString()) && !bean.getRegionType().equals(DataPolicy.PERSISTENT_PARTITION.toString())) continue;
            String[] memberNames = bean.getMembers();
            block2: for (DistributedMember dsMember : dsMembers) {
                for (String memberName : memberNames) {
                    if (!MBeanJMXAdapter.getMemberNameOrUniqueId(dsMember).equals(memberName)) continue;
                    MemberPRInfo memberAndItsPRRegions = new MemberPRInfo();
                    memberAndItsPRRegions.region = regionName;
                    memberAndItsPRRegions.dsMemberList.add(dsMember);
                    if (listMemberPRInfo.contains(memberAndItsPRRegions)) {
                        int index = listMemberPRInfo.indexOf(memberAndItsPRRegions);
                        MemberPRInfo listMember = (MemberPRInfo)listMemberPRInfo.get(index);
                        listMember.dsMemberList.add(dsMember);
                        continue block2;
                    }
                    listMemberPRInfo.add(memberAndItsPRRegions);
                    continue block2;
                }
            }
        }
        return listMemberPRInfo;
    }

    private boolean checkMemberPresence(InternalCache cache, DistributedMember dsMember) {
        Set<DistributedMember> dsMemberList = ManagementUtils.getAllNormalMembers(cache);
        return dsMemberList.contains(dsMember);
    }

    private String listOfAllMembers(List<DistributedMember> dsMemberList) {
        StringBuilder listMembersId = new StringBuilder();
        for (int j = 0; j < dsMemberList.size() - 1; ++j) {
            listMembersId.append(dsMemberList.get(j).getId());
            listMembersId.append(" ; ");
        }
        return listMembersId.toString();
    }

    private boolean checkResultList(List<String> errors, List<Object> resultList, DistributedMember member) {
        boolean toContinueForOtherMembers = false;
        if (CollectionUtils.isNotEmpty(resultList)) {
            for (Object object : resultList) {
                if (object instanceof Exception) {
                    errors.add(MessageFormat.format("Could not execute for member:{0}", member.getId()) + ": " + ((Exception)object).getMessage());
                    toContinueForOtherMembers = true;
                } else {
                    if (!(object instanceof Throwable)) continue;
                    errors.add(MessageFormat.format("Could not execute for member:{0}", member.getId()) + ": " + ((Throwable)object).getMessage());
                    toContinueForOtherMembers = true;
                }
                break;
            }
        } else {
            toContinueForOtherMembers = true;
        }
        return toContinueForOtherMembers;
    }

    @VisibleForTesting
    RebalanceResult executeRebalanceOnDS(ManagementService managementService, InternalCache cache, String simulate, List<String> excludeRegionsList, FunctionExecutor functionExecutor) {
        RebalanceResultImpl rebalanceResult = new RebalanceResultImpl();
        rebalanceResult.setSuccess(false);
        ArrayList<String> errors = new ArrayList<String>();
        List<MemberPRInfo> listMemberRegion = RebalanceOperationPerformer.getMemberRegionList(managementService, cache, excludeRegionsList);
        if (listMemberRegion.isEmpty()) {
            rebalanceResult.setStatusMessage("Distributed system has no regions that can be rebalanced");
            rebalanceResult.setSuccess(true);
            return rebalanceResult;
        }
        Iterator<MemberPRInfo> iterator = listMemberRegion.iterator();
        boolean flagToContinueWithRebalance = false;
        while (iterator.hasNext()) {
            if (iterator.next().dsMemberList.size() <= 1) continue;
            flagToContinueWithRebalance = true;
            break;
        }
        if (!flagToContinueWithRebalance) {
            rebalanceResult.setStatusMessage("Distributed system has no regions that can be rebalanced");
            rebalanceResult.setSuccess(true);
            return rebalanceResult;
        }
        ArrayList<RebalanceRegionResult> rebalanceRegionResults = new ArrayList<RebalanceRegionResult>();
        block5: for (MemberPRInfo memberPR : listMemberRegion) {
            try {
                if (memberPR.dsMemberList.size() <= 1) continue;
                for (int i = 0; i < memberPR.dsMemberList.size(); ++i) {
                    List<String> rstList;
                    HashSet excludeRegionSet;
                    DistributedMember dsMember = memberPR.dsMemberList.get(i);
                    Function rebalanceFunction = this.getRebalanceFunction((InternalDistributedMember)dsMember);
                    Object[] functionArgs = new Object[3];
                    functionArgs[0] = simulate;
                    HashSet<String> regionSet = new HashSet<String>();
                    regionSet.add(memberPR.region);
                    functionArgs[1] = regionSet;
                    functionArgs[2] = excludeRegionSet = new HashSet();
                    List<Object> resultList = new ArrayList();
                    try {
                        if (this.checkMemberPresence(cache, dsMember)) {
                            resultList = functionExecutor.execute(rebalanceFunction, functionArgs, dsMember);
                            if (this.checkResultList(errors, resultList, dsMember)) continue;
                            rstList = Arrays.asList(((String)resultList.get(0)).split(","));
                            rebalanceRegionResults.add(RebalanceOperationPerformer.toRebalanceRegionResult(rstList));
                            rebalanceResult.setSuccess(true);
                            continue block5;
                        }
                        if (i != memberPR.dsMemberList.size() - 1) continue;
                        continue block5;
                    }
                    catch (Exception ex) {
                        if (i != memberPR.dsMemberList.size() - 1) continue;
                        errors.add(MessageFormat.format("Could not execute rebalance for region: {0} on members : {1} ", memberPR.region, this.listOfAllMembers(memberPR.dsMemberList)) + ", " + " Reason : " + ex.getMessage());
                        if (this.checkResultList(errors, resultList, dsMember)) continue;
                        rstList = Arrays.asList(((String)resultList.get(0)).split(","));
                        rebalanceRegionResults.add(RebalanceOperationPerformer.toRebalanceRegionResult(rstList));
                        rebalanceResult.setSuccess(true);
                    }
                }
            }
            catch (NoMembersException e) {
                rebalanceResult.setStatusMessage(e.getMessage());
                rebalanceResult.setRebalanceSummary(rebalanceRegionResults);
                return rebalanceResult;
            }
        }
        rebalanceResult.setRebalanceSummary(rebalanceRegionResults);
        if (rebalanceRegionResults.isEmpty()) {
            rebalanceResult.setSuccess(false);
        }
        return rebalanceResult;
    }

    @NotNull
    private Function getRebalanceFunction(InternalDistributedMember dsMember) {
        org.apache.geode.management.internal.functions.RebalanceFunction rebalanceFunction = dsMember.getVersion().isOlderThan((Version)KnownVersion.GEODE_1_12_0) ? new RebalanceFunction() : new org.apache.geode.management.internal.functions.RebalanceFunction();
        return rebalanceFunction;
    }

    private static RebalanceRegionResult toRebalanceRegionResult(List<String> rstList) {
        RebalanceRegionResultImpl result = new RebalanceRegionResultImpl();
        result.setBucketCreateBytes(Long.parseLong(rstList.get(0)));
        result.setBucketCreateTimeInMilliseconds(Long.parseLong(rstList.get(1)));
        result.setBucketCreatesCompleted(Integer.parseInt(rstList.get(2)));
        result.setBucketTransferBytes(Long.parseLong(rstList.get(3)));
        result.setBucketTransferTimeInMilliseconds(Long.parseLong(rstList.get(4)));
        result.setBucketTransfersCompleted(Integer.parseInt(rstList.get(5)));
        result.setPrimaryTransferTimeInMilliseconds(Long.parseLong(rstList.get(6)));
        result.setPrimaryTransfersCompleted(Integer.parseInt(rstList.get(7)));
        result.setTimeInMilliseconds(Long.parseLong(rstList.get(8)));
        if (rstList.size() < 11) {
            result.setNumOfMembers(-1);
            result.setRegionName(rstList.get(9).replace("/", ""));
        } else {
            result.setNumOfMembers(Integer.parseInt(rstList.get(9)));
            result.setRegionName(rstList.get(10).replace("/", ""));
        }
        return result;
    }

    public static class MemberPRInfo {
        public List<DistributedMember> dsMemberList = new ArrayList<DistributedMember>();
        public String region = "";

        public boolean equals(Object o2) {
            if (o2 instanceof MemberPRInfo) {
                return this.region.equals(((MemberPRInfo)o2).region);
            }
            return false;
        }

        public int hashCode() {
            return this.region.hashCode();
        }
    }

    @VisibleForTesting
    static class FunctionExecutor {
        FunctionExecutor() {
        }

        public List<Object> execute(Function rebalanceFunction, Object[] functionArgs, DistributedMember dsMember) {
            return (List)ManagementUtils.executeFunction(rebalanceFunction, functionArgs, Collections.singleton(dsMember)).getResult();
        }
    }
}

