/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.membership.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.geode.distributed.internal.membership.api.MemberIdentifier;

public class MembershipView<ID extends MemberIdentifier> {
    private final int viewId;
    private final List<ID> members;
    private final Set<ID> shutdownMembers;
    private final Set<ID> crashedMembers;
    private final ID creator;
    private final Set<ID> hashedMembers;

    public MembershipView() {
        this(null, -1, Collections.emptyList());
    }

    public MembershipView(ID creator, int viewId, List<ID> members) {
        this(creator, viewId, members, Collections.emptySet(), Collections.emptySet());
    }

    public MembershipView(ID creator, int viewId, List<ID> members, Set<ID> shutdowns, Set<ID> crashes) {
        this.creator = creator;
        this.viewId = viewId;
        this.members = Collections.unmodifiableList(new ArrayList<ID>(members));
        this.shutdownMembers = Collections.unmodifiableSet(new HashSet<ID>(shutdowns));
        this.crashedMembers = Collections.unmodifiableSet(new HashSet<ID>(crashes));
        this.hashedMembers = Collections.unmodifiableSet(new HashSet<ID>(members));
    }

    public int getViewId() {
        return this.viewId;
    }

    public ID getCreator() {
        return this.creator;
    }

    public List<ID> getMembers() {
        return this.members;
    }

    public Object get(int i) {
        return this.members.get(i);
    }

    public MembershipView<ID> createNewViewWithMember(ID member) {
        return new MembershipView<ID>(this.creator, this.viewId, Stream.concat(this.members.stream(), Stream.of(member)).collect(Collectors.toList()), this.shutdownMembers, this.crashedMembers);
    }

    public MembershipView<ID> createNewViewWithoutMember(ID member) {
        return new MembershipView<ID>(this.creator, this.viewId, this.members.stream().filter(m -> !m.equals(member)).collect(Collectors.toList()), this.shutdownMembers, this.crashedMembers);
    }

    public boolean contains(MemberIdentifier mbr) {
        return this.hashedMembers.contains(mbr);
    }

    public int size() {
        return this.members.size();
    }

    public ID getLeadMember() {
        for (MemberIdentifier mbr : this.members) {
            if (mbr.getVmKind() != 10) continue;
            return (ID)mbr;
        }
        return null;
    }

    public ID getCanonicalID(ID id) {
        if (this.hashedMembers.contains(id)) {
            for (MemberIdentifier m : this.members) {
                if (!id.equals(m)) continue;
                return (ID)m;
            }
        }
        return id;
    }

    public ID getCoordinator() {
        for (MemberIdentifier addr : this.members) {
            if (!addr.preferredForCoordinator()) continue;
            return (ID)addr;
        }
        if (this.members.size() > 0) {
            return (ID)((MemberIdentifier)this.members.get(0));
        }
        return null;
    }

    public Set<ID> getCrashedMembers() {
        return this.crashedMembers;
    }

    public String toString() {
        ID lead = this.getLeadMember();
        StringBuilder sb = new StringBuilder(200);
        sb.append("View[").append(this.creator).append('|').append(this.viewId).append("] members: [");
        boolean first = true;
        for (MemberIdentifier mbr : this.members) {
            if (!first) {
                sb.append(", ");
            }
            sb.append(mbr);
            if (mbr == lead) {
                sb.append("{lead}");
            }
            first = false;
        }
        if (!this.shutdownMembers.isEmpty()) {
            sb.append("]  shutdown: [");
            first = true;
            for (MemberIdentifier mbr : this.shutdownMembers) {
                if (!first) {
                    sb.append(", ");
                }
                sb.append(mbr);
                first = false;
            }
        }
        if (!this.crashedMembers.isEmpty()) {
            sb.append("]  crashed: [");
            first = true;
            for (MemberIdentifier mbr : this.crashedMembers) {
                if (!first) {
                    sb.append(", ");
                }
                sb.append(mbr);
                first = false;
            }
        }
        sb.append("]");
        return sb.toString();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof MembershipView) {
            return this.members.equals(((MembershipView)other).getMembers());
        }
        return false;
    }

    public int hashCode() {
        return this.members.hashCode();
    }
}

