/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.cache.EntryDestroyedException;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.query.FunctionDomainException;
import org.apache.geode.cache.query.NameResolutionException;
import org.apache.geode.cache.query.QueryInvocationTargetException;
import org.apache.geode.cache.query.QueryService;
import org.apache.geode.cache.query.Struct;
import org.apache.geode.cache.query.TypeMismatchException;
import org.apache.geode.cache.query.internal.AbstractCompiledValue;
import org.apache.geode.cache.query.internal.CompiledValue;
import org.apache.geode.cache.query.internal.DefaultQueryService;
import org.apache.geode.cache.query.internal.ExecutionContext;
import org.apache.geode.cache.query.internal.MethodDispatch;
import org.apache.geode.cache.query.internal.RuntimeIterator;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.pdx.PdxInstance;
import org.apache.geode.pdx.PdxSerializationException;
import org.apache.geode.pdx.internal.InternalPdxInstance;
import org.apache.geode.pdx.internal.PdxString;

public class CompiledOperation
extends AbstractCompiledValue {
    private final CompiledValue receiver;
    private final String methodName;
    private final List args;
    @MakeNotStatic
    private static final ConcurrentMap cache = new ConcurrentHashMap();

    public CompiledOperation(CompiledValue receiver, String methodName, List args) {
        this.receiver = receiver;
        this.methodName = methodName;
        this.args = args;
    }

    @Override
    public List getChildren() {
        ArrayList<CompiledValue> list = new ArrayList<CompiledValue>();
        if (this.receiver != null) {
            list.add(this.receiver);
        }
        list.addAll(this.args);
        return list;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public List getArguments() {
        return this.args;
    }

    @Override
    public int getType() {
        return 54;
    }

    public CompiledValue getReceiver(ExecutionContext cxt) {
        if (this.receiver == null && cxt != null) {
            return (CompiledValue)cxt.cacheGet(this);
        }
        return this.receiver;
    }

    @Override
    public boolean hasIdentifierAtLeafNode() {
        if (this.receiver.getType() == 35) {
            return true;
        }
        return this.receiver.hasIdentifierAtLeafNode();
    }

    @Override
    public CompiledValue getReceiver() {
        return this.getReceiver(null);
    }

    @Override
    public Object evaluate(ExecutionContext context) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        Object evalRcvr;
        CompiledValue rcvr = this.getReceiver(context);
        if (rcvr == null) {
            RuntimeIterator rcvrItr = context.resolveImplicitOperationName(this.methodName, this.args.size(), true);
            evalRcvr = rcvrItr.evaluate(context);
        } else {
            evalRcvr = rcvr.evaluate(context);
        }
        if (evalRcvr == null) {
            return QueryService.UNDEFINED;
        }
        if (context.isCqQueryContext() && evalRcvr instanceof Region.Entry) {
            Region.Entry re = (Region.Entry)evalRcvr;
            if (re.isDestroyed()) {
                return QueryService.UNDEFINED;
            }
            try {
                evalRcvr = re.getValue();
            }
            catch (EntryDestroyedException ede) {
                return QueryService.UNDEFINED;
            }
        }
        Class resolveClass = null;
        if (evalRcvr instanceof PdxInstance) {
            String className = ((PdxInstance)evalRcvr).getClassName();
            try {
                resolveClass = InternalDataSerializer.getCachedClass(className);
            }
            catch (ClassNotFoundException cnfe) {
                throw new QueryInvocationTargetException(cnfe);
            }
        } else {
            resolveClass = evalRcvr instanceof PdxString ? String.class : evalRcvr.getClass();
        }
        Object result = this.eval0(evalRcvr, resolveClass, context);
        PartitionedRegion pr = context.getPartitionedRegion();
        if (pr != null && result instanceof Region && pr.getFullPath().equals(((Region)result).getFullPath())) {
            result = context.getBucketRegion();
        }
        return result;
    }

    @Override
    public Set computeDependencies(ExecutionContext context) throws TypeMismatchException, NameResolutionException {
        List args = this.args;
        for (Object arg : args) {
            context.addDependencies(this, ((CompiledValue)arg).computeDependencies(context));
        }
        CompiledValue rcvr = this.getReceiver(context);
        if (rcvr == null) {
            RuntimeIterator rcvrItr = context.resolveImplicitOperationName(this.methodName, this.args.size(), true);
            if (rcvrItr == null) {
                throw new TypeMismatchException(String.format("Could not resolve method named ' %s '", this.methodName));
            }
            context.cachePut(this, rcvrItr);
            return context.addDependency(this, rcvrItr);
        }
        return context.addDependencies(this, rcvr.computeDependencies(context));
    }

    @SuppressWarnings(value={"RV_RETURN_VALUE_OF_PUTIFABSENT_IGNORED"}, justification="Does not matter if the methodDispatch that isn't stored in the map is used")
    private Object eval0(Object receiver, Class resolutionType, ExecutionContext context) throws TypeMismatchException, FunctionDomainException, NameResolutionException, QueryInvocationTargetException {
        if (receiver == null || receiver == QueryService.UNDEFINED) {
            return QueryService.UNDEFINED;
        }
        ArrayList<Object> args = new ArrayList<Object>();
        ArrayList argTypes = new ArrayList();
        for (Object value : this.args) {
            CompiledValue arg = (CompiledValue)value;
            Object o = arg.evaluate(context);
            if (o == QueryService.UNDEFINED) {
                return QueryService.UNDEFINED;
            }
            args.add(o);
            if (o == null) {
                argTypes.add(null);
                continue;
            }
            argTypes.add(o.getClass());
        }
        List<Object> key = Arrays.asList(resolutionType, this.methodName, argTypes);
        MethodDispatch methodDispatch = (MethodDispatch)cache.get(key);
        if (methodDispatch == null) {
            try {
                methodDispatch = new MethodDispatch(resolutionType, this.methodName, argTypes);
            }
            catch (NameResolutionException nre) {
                if (!Struct.class.isAssignableFrom(resolutionType) && (DefaultQueryService.QUERY_HETEROGENEOUS_OBJECTS || DefaultQueryService.TEST_QUERY_HETEROGENEOUS_OBJECTS)) {
                    return QueryService.UNDEFINED;
                }
                throw nre;
            }
            cache.putIfAbsent(key, methodDispatch);
        }
        if (receiver instanceof InternalPdxInstance) {
            try {
                receiver = ((InternalPdxInstance)receiver).getCachedObject();
            }
            catch (PdxSerializationException ex) {
                throw new QueryInvocationTargetException(ex);
            }
        } else if (receiver instanceof PdxString) {
            receiver = receiver.toString();
        }
        return methodDispatch.invoke(receiver, args, context);
    }

    @Override
    public void generateCanonicalizedExpression(StringBuilder clauseBuffer, ExecutionContext context) throws TypeMismatchException, NameResolutionException {
        int len;
        if (this.methodName.startsWith("get") && (len = this.methodName.length()) > 3 && (this.args == null || this.args.isEmpty())) {
            clauseBuffer.insert(0, len > 4 ? this.methodName.substring(4) : "");
            clauseBuffer.insert(0, Character.toLowerCase(this.methodName.charAt(3)));
        } else if (this.args == null || this.args.isEmpty()) {
            clauseBuffer.insert(0, "()").insert(0, this.methodName);
        } else {
            clauseBuffer.insert(0, ')');
            CompiledValue cv = null;
            int j = this.args.size();
            while (j > 0) {
                cv = (CompiledValue)this.args.get(--j);
                cv.generateCanonicalizedExpression(clauseBuffer, context);
                clauseBuffer.insert(0, ',');
            }
            clauseBuffer.deleteCharAt(0).insert(0, '(').insert(0, this.methodName);
        }
        clauseBuffer.insert(0, '.');
        CompiledValue rcvr = this.receiver;
        if (rcvr == null) {
            rcvr = context.resolveImplicitOperationName(this.methodName, this.args.size(), true);
        }
        rcvr.generateCanonicalizedExpression(clauseBuffer, context);
    }
}

