/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.metrics.context.filter;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigValueFactory;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.gobblin.metrics.context.filter.AllContextFilter;
import org.apache.gobblin.metrics.context.filter.ContextFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextFilterFactory {
    private static final Logger log = LoggerFactory.getLogger(ContextFilterFactory.class);
    public static final String CONTEXT_FILTER_CLASS = "context.filter.class";

    public static Config setContextFilterClass(Config config, Class<? extends ContextFilter> klazz) {
        return config.withValue(CONTEXT_FILTER_CLASS, ConfigValueFactory.fromAnyRef((Object)klazz.getCanonicalName()));
    }

    public static ContextFilter createContextFilter(Config config) {
        if (config.hasPath(CONTEXT_FILTER_CLASS)) {
            try {
                return (ContextFilter)ContextFilter.class.cast(ConstructorUtils.invokeConstructor(Class.forName(config.getString(CONTEXT_FILTER_CLASS)), (Object[])new Object[]{config}));
            }
            catch (ReflectiveOperationException rfe) {
                log.error("Failed to instantiate context filter with class " + config.getString(CONTEXT_FILTER_CLASS), (Throwable)rfe);
            }
        }
        return new AllContextFilter();
    }
}

