/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.metrics.event;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.gobblin.metrics.event.EventSubmitter;

public class TimingEvent {
    public static final String METADATA_START_TIME = "startTime";
    public static final String METADATA_END_TIME = "endTime";
    public static final String METADATA_DURATION = "durationMillis";
    public static final String METADATA_TIMING_EVENT = "timingEvent";
    private final String name;
    private final Long startTime;
    private final EventSubmitter submitter;
    private boolean stopped = false;

    public TimingEvent(EventSubmitter submitter, String name) {
        this.name = name;
        this.submitter = submitter;
        this.startTime = System.currentTimeMillis();
    }

    public void stop() {
        this.stop(Maps.newHashMap());
    }

    public void stop(Map<String, String> additionalMetadata) {
        if (this.stopped) {
            return;
        }
        this.stopped = true;
        long endTime = System.currentTimeMillis();
        long duration = endTime - this.startTime;
        HashMap finalMetadata = Maps.newHashMap();
        finalMetadata.putAll(additionalMetadata);
        finalMetadata.put("eventType", METADATA_TIMING_EVENT);
        finalMetadata.put(METADATA_START_TIME, Long.toString(this.startTime));
        finalMetadata.put(METADATA_END_TIME, Long.toString(endTime));
        finalMetadata.put(METADATA_DURATION, Long.toString(duration));
        this.submitter.submit(this.name, finalMetadata);
    }

    public static class RunJobTimings {
        public static final String JOB_LOCAL_SETUP = "JobLocalSetupTimer";
        public static final String WORK_UNITS_RUN = "WorkUnitsRunTimer";
        public static final String WORK_UNITS_PREPARATION = "WorkUnitsPreparationTimer";
        public static final String MR_STAGING_DATA_CLEAN = "JobMrStagingDataCleanTimer";
        public static final String MR_DISTRIBUTED_CACHE_SETUP = "JobMrDistributedCacheSetupTimer";
        public static final String MR_JOB_SETUP = "JobMrSetupTimer";
        public static final String MR_JOB_RUN = "JobMrRunTimer";
        public static final String HELIX_JOB_SUBMISSION = "JobHelixSubmissionTimer";
        public static final String HELIX_JOB_RUN = "JobHelixRunTimer";
    }

    public static class LauncherTimings {
        public static final String FULL_JOB_EXECUTION = "FullJobExecutionTimer";
        public static final String WORK_UNITS_CREATION = "WorkUnitsCreationTimer";
        public static final String WORK_UNITS_PREPARATION = "WorkUnitsPreparationTimer";
        public static final String JOB_PREPARE = "JobPrepareTimer";
        public static final String JOB_START = "JobStartTimer";
        public static final String JOB_RUN = "JobRunTimer";
        public static final String JOB_COMMIT = "JobCommitTimer";
        public static final String JOB_CLEANUP = "JobCleanupTimer";
        public static final String JOB_CANCEL = "JobCancelTimer";
        public static final String JOB_COMPLETE = "JobCompleteTimer";
        public static final String JOB_FAILED = "JobFailedTimer";
    }
}

