/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.metrics.event.lineage;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.gobblin.dataset.DatasetDescriptor;
import org.apache.gobblin.metrics.GobblinTrackingEvent;
import org.apache.gobblin.metrics.event.GobblinEventBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LineageEventBuilder
extends GobblinEventBuilder {
    private static final Logger log = LoggerFactory.getLogger(LineageEventBuilder.class);
    static final String LIENAGE_EVENT_NAMESPACE = LineageEventBuilder.getKey("gobblin.event", "lineage");
    static final String SOURCE = "source";
    static final String DESTINATION = "destination";
    static final String LINEAGE_EVENT_TYPE = "LineageEvent";
    private static final Gson GSON = new Gson();
    private DatasetDescriptor source;
    private DatasetDescriptor destination;

    public LineageEventBuilder(String name) {
        super(name, LIENAGE_EVENT_NAMESPACE);
        this.addMetadata("eventType", LINEAGE_EVENT_TYPE);
    }

    @Override
    public GobblinTrackingEvent build() {
        this.source.toDataMap().forEach((key, value) -> this.metadata.put(LineageEventBuilder.getKey(SOURCE, key), value));
        this.destination.toDataMap().forEach((key, value) -> this.metadata.put(LineageEventBuilder.getKey(DESTINATION, key), value));
        return new GobblinTrackingEvent(0L, this.namespace, this.name, this.metadata);
    }

    public String toString() {
        return GSON.toJson((Object)this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LineageEventBuilder event = (LineageEventBuilder)o;
        if (!(this.namespace.equals(event.namespace) && this.name.equals(event.name) && this.metadata.equals(event.metadata))) {
            return false;
        }
        if (this.source != null ? !this.source.equals((Object)event.source) : event.source != null) {
            return false;
        }
        return this.destination != null ? this.destination.equals((Object)event.destination) : event.destination == null;
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.namespace.hashCode();
        result = 31 * result + this.metadata.hashCode();
        result = 31 * result + (this.source != null ? this.source.hashCode() : 0);
        result = 31 * result + (this.destination != null ? this.destination.hashCode() : 0);
        return result;
    }

    public static boolean isLineageEvent(GobblinTrackingEvent event) {
        String eventType = event.getMetadata().get("eventType");
        return StringUtils.isNotEmpty((String)eventType) && eventType.equals(LINEAGE_EVENT_TYPE);
    }

    public static LineageEventBuilder fromEvent(GobblinTrackingEvent event) {
        Map<String, String> metadata = event.getMetadata();
        LineageEventBuilder lineageEvent = new LineageEventBuilder(event.getName());
        String sourcePrefix = LineageEventBuilder.getKey(SOURCE, "");
        HashMap sourceDataMap = Maps.newHashMap();
        String destinationPrefix = LineageEventBuilder.getKey(DESTINATION, "");
        HashMap destinationDataMap = Maps.newHashMap();
        metadata.forEach((key, value) -> {
            if (key.startsWith(sourcePrefix)) {
                sourceDataMap.put(key.substring(sourcePrefix.length()), value);
            } else if (key.startsWith(destinationPrefix)) {
                destinationDataMap.put(key.substring(destinationPrefix.length()), value);
            } else {
                lineageEvent.addMetadata((String)key, (String)value);
            }
        });
        lineageEvent.setSource(DatasetDescriptor.fromDataMap((Map)sourceDataMap));
        lineageEvent.setDestination(DatasetDescriptor.fromDataMap((Map)destinationDataMap));
        return lineageEvent;
    }

    static String getKey(Object ... parts) {
        return Joiner.on((String)".").join(parts);
    }

    public DatasetDescriptor getSource() {
        return this.source;
    }

    public void setSource(DatasetDescriptor source) {
        this.source = source;
    }

    public DatasetDescriptor getDestination() {
        return this.destination;
    }

    public void setDestination(DatasetDescriptor destination) {
        this.destination = destination;
    }
}

