/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.cli;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.gobblin.cli.Command;
import org.apache.gobblin.cli.JobCommand;

public class Cli {
    private static final Map<String, Command> commandList = ImmutableMap.of((Object)"jobs", (Object)new JobCommand());
    private static final String HOST_OPT = "host";
    private static final String PORT_OPT = "port";
    private static final String DEFAULT_REST_SERVER_HOST = "localhost";
    private static final int DEFAULT_REST_SERVER_PORT = 8080;
    private String[] args;
    private Options options;

    public static Collection<String> getCommandNames() {
        return commandList.keySet();
    }

    public static void main(String[] args) {
        Cli cli = new Cli(args);
        cli.parseAndExecuteCommand();
    }

    public Cli(String[] args) {
        this.args = args;
        this.options = new Options();
        this.options.addOption("H", HOST_OPT, true, "Specify host (default:localhost)");
        this.options.addOption("P", PORT_OPT, true, "Specify port (default:8080)");
    }

    public void parseAndExecuteCommand() {
        DefaultParser parser = new DefaultParser();
        try {
            CommandLine parsedOpts = parser.parse(this.options, this.args, true);
            GlobalOptions globalOptions = this.createGlobalOptions(parsedOpts);
            String[] remainingArgs = parsedOpts.getArgs();
            if (remainingArgs.length == 0) {
                this.printHelpAndExit("Command not specified!");
            }
            String commandName = remainingArgs[0].toLowerCase();
            remainingArgs = remainingArgs.length > 1 ? Arrays.copyOfRange(remainingArgs, 1, remainingArgs.length) : new String[]{};
            Command command = commandList.get(commandName);
            if (command == null) {
                System.out.println("Command " + commandName + " not known.");
                this.printHelpAndExit();
            } else {
                command.execute(globalOptions, remainingArgs);
            }
        }
        catch (ParseException e) {
            this.printHelpAndExit("Ran into an error parsing args.");
        }
    }

    private GlobalOptions createGlobalOptions(CommandLine parsedOpts) {
        String host = parsedOpts.hasOption(HOST_OPT) ? parsedOpts.getOptionValue(HOST_OPT) : DEFAULT_REST_SERVER_HOST;
        int port = 8080;
        try {
            if (parsedOpts.hasOption(PORT_OPT)) {
                port = Integer.parseInt(parsedOpts.getOptionValue(PORT_OPT));
            }
        }
        catch (NumberFormatException e) {
            this.printHelpAndExit("The port must be a valid integer.");
        }
        return new GlobalOptions(host, port);
    }

    private void printHelpAndExit() {
        System.out.println("Common usages:");
        System.out.println("  gobblin-admin.sh jobs --list");
        System.out.println("  gobblin-admin.sh jobs --list --name JobName");
        System.out.println("  gobblin-admin.sh jobs --details --id job_id");
        System.out.println("  gobblin-admin.sh jobs --properties --<id|name> <job_id|JobName>");
        System.out.println();
        this.printHelpAndExit(0);
    }

    private void printHelpAndExit(String errorMessage) {
        System.err.println(errorMessage);
        this.printHelpAndExit(1);
    }

    private void printHelpAndExit(int exitCode) {
        HelpFormatter hf = new HelpFormatter();
        hf.printHelp("gobblin-admin.sh <command> [options]", this.options);
        System.out.println("Valid commands:");
        for (String command : Cli.getCommandNames()) {
            System.out.println(command);
        }
        System.exit(exitCode);
    }

    static class GlobalOptions {
        private final String adminServerHost;
        private final int adminServerPort;

        public GlobalOptions(String adminServerHost, int adminServerPort) {
            this.adminServerHost = adminServerHost;
            this.adminServerPort = adminServerPort;
        }

        public String getAdminServerHost() {
            return this.adminServerHost;
        }

        public int getAdminServerPort() {
            return this.adminServerPort;
        }
    }
}

