/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.client;

import com.linkedin.data.DataList;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.template.DataTemplate;
import com.linkedin.data.template.DynamicRecordMetadata;
import com.linkedin.data.template.DynamicRecordTemplate;
import com.linkedin.data.template.FieldDef;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.restli.client.AbstractRequestBuilder;
import com.linkedin.restli.client.ActionRequest;
import com.linkedin.restli.client.RestliRequestOptions;
import com.linkedin.restli.common.ResourceSpec;
import com.linkedin.restli.common.TypeSpec;
import com.linkedin.restli.common.attachments.RestLiAttachmentDataSourceWriter;
import com.linkedin.restli.common.attachments.RestLiDataSourceIterator;
import com.linkedin.restli.internal.client.ActionResponseDecoder;
import com.linkedin.util.ArgumentUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ActionRequestBuilder<K, V>
extends AbstractRequestBuilder<K, V, ActionRequest<V>> {
    private final TypeSpec<V> _elementType;
    private K _id;
    private String _name;
    private final Map<FieldDef<?>, Object> _actionParams = new HashMap();
    private List<Object> _streamingAttachments;

    public ActionRequestBuilder(String baseUriTemplate, Class<V> elementClass, ResourceSpec resourceSpec, RestliRequestOptions requestOptions) {
        this(baseUriTemplate, new TypeSpec(elementClass), resourceSpec, requestOptions);
    }

    public ActionRequestBuilder(String baseUriTemplate, TypeSpec<V> elementType, ResourceSpec resourceSpec, RestliRequestOptions requestOptions) {
        super(baseUriTemplate, resourceSpec, requestOptions);
        this._elementType = elementType;
    }

    public ActionRequestBuilder<K, V> name(String name) {
        this._name = name;
        this.setParam("action", (Object)this._name);
        return this;
    }

    public ActionRequestBuilder<K, V> id(K id) {
        this._id = id;
        return this;
    }

    public ActionRequestBuilder<K, V> appendSingleAttachment(RestLiAttachmentDataSourceWriter streamingAttachment) {
        if (this._streamingAttachments == null) {
            this._streamingAttachments = new ArrayList<Object>();
        }
        this._streamingAttachments.add(streamingAttachment);
        return this;
    }

    public ActionRequestBuilder<K, V> appendMultipleAttachments(RestLiDataSourceIterator dataSourceIterator) {
        if (this._streamingAttachments == null) {
            this._streamingAttachments = new ArrayList<Object>();
        }
        this._streamingAttachments.add(dataSourceIterator);
        return this;
    }

    public ActionRequestBuilder<K, V> setParam(FieldDef<?> key, Object value) {
        this._actionParams.put(key, value);
        return this;
    }

    public ActionRequestBuilder<K, V> setReqParam(FieldDef<?> key, Object value) {
        ArgumentUtil.notNull((Object)value, (String)"value");
        return this.setParam(key, value);
    }

    public ActionRequestBuilder<K, V> addParam(FieldDef<?> key, Object value) {
        if (value != null) {
            DataList newList;
            Object existingData = this._actionParams.get(key);
            if (existingData == null) {
                return this.setParam(key, value);
            }
            if (existingData instanceof DataList) {
                newList = (DataList)existingData;
                newList.add(value);
            } else {
                newList = new DataList(Arrays.asList(existingData, value));
            }
            this._actionParams.put(key, newList);
        }
        return this;
    }

    public ActionRequestBuilder<K, V> addReqParam(FieldDef<?> key, Object value) {
        ArgumentUtil.notNull((Object)value, (String)"value");
        return this.addParam(key, value);
    }

    public ActionRequestBuilder<K, V> setHeader(String key, String value) {
        super.setHeader(key, value);
        return this;
    }

    public ActionRequestBuilder<K, V> setHeaders(Map<String, String> headers) {
        super.setHeaders(headers);
        return this;
    }

    public ActionRequestBuilder<K, V> addHeader(String key, String value) {
        super.addHeader(key, value);
        return this;
    }

    public ActionRequestBuilder<K, V> pathKey(String name, Object value) {
        super.pathKey(name, value);
        return this;
    }

    @Override
    public ActionRequest<V> build() {
        RecordDataSchema actionResponseDataSchema;
        FieldDef responseFieldDef;
        RecordDataSchema requestDataSchema;
        if (this._name == null) {
            throw new IllegalStateException("name required to build action request");
        }
        if (this._resourceSpec.getRequestMetadata(this._name) == null) {
            Collection<Object> responseFieldDefCollection;
            requestDataSchema = DynamicRecordMetadata.buildSchema((String)this._name, this._actionParams.keySet());
            if (this._elementType.getType() == Void.class) {
                responseFieldDef = null;
                responseFieldDefCollection = Collections.emptyList();
            } else {
                responseFieldDef = new FieldDef("value", this._elementType.getType(), this._elementType.getSchema());
                responseFieldDefCollection = Collections.singleton(responseFieldDef);
            }
            actionResponseDataSchema = DynamicRecordMetadata.buildSchema((String)this._name, responseFieldDefCollection);
        } else {
            requestDataSchema = this._resourceSpec.getRequestMetadata(this._name).getRecordDataSchema();
            actionResponseDataSchema = this._resourceSpec.getActionResponseMetadata(this._name).getRecordDataSchema();
            responseFieldDef = this._resourceSpec.getActionResponseMetadata(this._name).getFieldDef("value");
        }
        ActionResponseDecoder actionResponseDecoder = new ActionResponseDecoder(responseFieldDef, actionResponseDataSchema);
        DynamicRecordTemplate inputParameters = new DynamicRecordTemplate(requestDataSchema, this.buildReadOnlyActionParameters());
        inputParameters.data().setReadOnly();
        return new ActionRequest((RecordTemplate)inputParameters, this.buildReadOnlyHeaders(), this.buildReadOnlyCookies(), actionResponseDecoder, this._resourceSpec, this.buildReadOnlyQueryParameters(), this.getQueryParamClasses(), this._name, this.getBaseUriTemplate(), this.buildReadOnlyPathKeys(), this.getRequestOptions(), this.buildReadOnlyId(), this._streamingAttachments == null ? null : Collections.unmodifiableList(this._streamingAttachments));
    }

    private Map<FieldDef<?>, Object> buildReadOnlyActionParameters() {
        try {
            HashMap readOnlyParameters = new HashMap(this._actionParams.size());
            for (Map.Entry<FieldDef<?>, Object> originalParameterEntry : this._actionParams.entrySet()) {
                readOnlyParameters.put(originalParameterEntry.getKey(), this.getReadOnlyActionParameter(originalParameterEntry.getValue()));
            }
            return readOnlyParameters;
        }
        catch (CloneNotSupportedException cloneException) {
            throw new IllegalArgumentException("Action parameters cannot be cloned", cloneException);
        }
    }

    private Object getReadOnlyActionParameter(Object original) throws CloneNotSupportedException {
        if (original == null) {
            return null;
        }
        Object[] result = original;
        if (original.getClass().isArray()) {
            Object[] items = original;
            Object[] readOnlyItems = new Object[items.length];
            for (int i = 0; i < items.length; ++i) {
                readOnlyItems[i] = this.getReadOnlyActionParameter(items[i]);
            }
            result = readOnlyItems;
        } else if (DataTemplate.class.isAssignableFrom(original.getClass())) {
            result = this.getReadOnlyOrCopyDataTemplate((DataTemplate)original);
        }
        return result;
    }

    private K buildReadOnlyId() {
        try {
            return this.getReadOnlyOrCopyKey(this._id);
        }
        catch (CloneNotSupportedException cloneException) {
            throw new IllegalArgumentException("Key cannot be copied.", cloneException);
        }
    }
}

