/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.client.uribuilders;

import com.linkedin.restli.client.ActionRequest;
import com.linkedin.restli.client.BatchCreateIdEntityRequest;
import com.linkedin.restli.client.BatchCreateIdRequest;
import com.linkedin.restli.client.BatchCreateRequest;
import com.linkedin.restli.client.BatchDeleteRequest;
import com.linkedin.restli.client.BatchGetEntityRequest;
import com.linkedin.restli.client.BatchGetKVRequest;
import com.linkedin.restli.client.BatchGetRequest;
import com.linkedin.restli.client.BatchPartialUpdateRequest;
import com.linkedin.restli.client.BatchUpdateRequest;
import com.linkedin.restli.client.CreateIdEntityRequest;
import com.linkedin.restli.client.CreateIdRequest;
import com.linkedin.restli.client.CreateRequest;
import com.linkedin.restli.client.DeleteRequest;
import com.linkedin.restli.client.FindRequest;
import com.linkedin.restli.client.GetAllRequest;
import com.linkedin.restli.client.GetRequest;
import com.linkedin.restli.client.OptionsRequest;
import com.linkedin.restli.client.PartialUpdateRequest;
import com.linkedin.restli.client.Request;
import com.linkedin.restli.client.UpdateRequest;
import com.linkedin.restli.client.uribuilders.ActionRequestUriBuilder;
import com.linkedin.restli.client.uribuilders.BatchCreateIdEntityRequestUriBuilder;
import com.linkedin.restli.client.uribuilders.BatchCreateIdRequestUriBuilder;
import com.linkedin.restli.client.uribuilders.BatchCreateRequestUriBuilder;
import com.linkedin.restli.client.uribuilders.BatchDeleteRequestUriBuilder;
import com.linkedin.restli.client.uribuilders.BatchGetEntityRequestUriBuilder;
import com.linkedin.restli.client.uribuilders.BatchGetKVRequestUriBuilder;
import com.linkedin.restli.client.uribuilders.BatchGetRequestUriBuilder;
import com.linkedin.restli.client.uribuilders.BatchPartialUpdateRequestUriBuilder;
import com.linkedin.restli.client.uribuilders.BatchUpdateRequestUriBuilder;
import com.linkedin.restli.client.uribuilders.CreateIdEntityRequestUriBuilder;
import com.linkedin.restli.client.uribuilders.CreateIdRequestUriBuilder;
import com.linkedin.restli.client.uribuilders.CreateRequestUriBuilder;
import com.linkedin.restli.client.uribuilders.DeleteRequestUriBuilder;
import com.linkedin.restli.client.uribuilders.FindRequestUriBuilder;
import com.linkedin.restli.client.uribuilders.GetAllRequestUriBuilder;
import com.linkedin.restli.client.uribuilders.GetRequestUriBuilder;
import com.linkedin.restli.client.uribuilders.OptionsRequestUriBuilder;
import com.linkedin.restli.client.uribuilders.PartialUpdateRequestUriBuilder;
import com.linkedin.restli.client.uribuilders.RestliUriBuilder;
import com.linkedin.restli.client.uribuilders.UpdateRequestUriBuilder;
import com.linkedin.restli.common.ProtocolVersion;

public class RestliUriBuilderUtil {
    public static RestliUriBuilder createUriBuilder(Request<?> request, ProtocolVersion version) {
        return RestliUriBuilderUtil.createUriBuilder(request, "", version);
    }

    public static RestliUriBuilder createUriBuilder(Request<?> request, String uriPrefix, ProtocolVersion version) {
        switch (request.getMethod()) {
            case ACTION: {
                return new ActionRequestUriBuilder((ActionRequest)request, uriPrefix, version);
            }
            case GET: {
                return new GetRequestUriBuilder((GetRequest)request, uriPrefix, version);
            }
            case BATCH_GET: {
                if (request instanceof BatchGetRequest) {
                    return new BatchGetRequestUriBuilder((BatchGetRequest)request, uriPrefix, version);
                }
                if (request instanceof BatchGetKVRequest) {
                    return new BatchGetKVRequestUriBuilder((BatchGetKVRequest)request, uriPrefix, version);
                }
                if (request instanceof BatchGetEntityRequest) {
                    return new BatchGetEntityRequestUriBuilder((BatchGetEntityRequest)request, uriPrefix, version);
                }
                throw new IllegalArgumentException("Batch Get request of unknown type: " + request.getClass());
            }
            case FINDER: {
                return new FindRequestUriBuilder((FindRequest)request, uriPrefix, version);
            }
            case CREATE: {
                if (request instanceof CreateRequest) {
                    return new CreateRequestUriBuilder((CreateRequest)request, uriPrefix, version);
                }
                if (request instanceof CreateIdRequest) {
                    return new CreateIdRequestUriBuilder((CreateIdRequest)request, uriPrefix, version);
                }
                if (request instanceof CreateIdEntityRequest) {
                    return new CreateIdEntityRequestUriBuilder((CreateIdEntityRequest)request, uriPrefix, version);
                }
                throw new IllegalArgumentException("Create request of unknown type: " + request.getClass());
            }
            case BATCH_CREATE: {
                if (request instanceof BatchCreateRequest) {
                    return new BatchCreateRequestUriBuilder((BatchCreateRequest)request, uriPrefix, version);
                }
                if (request instanceof BatchCreateIdRequest) {
                    return new BatchCreateIdRequestUriBuilder((BatchCreateIdRequest)request, uriPrefix, version);
                }
                if (request instanceof BatchCreateIdEntityRequest) {
                    return new BatchCreateIdEntityRequestUriBuilder((BatchCreateIdEntityRequest)request, uriPrefix, version);
                }
                throw new IllegalArgumentException("batch create request of unknown type: " + request.getClass());
            }
            case PARTIAL_UPDATE: {
                return new PartialUpdateRequestUriBuilder((PartialUpdateRequest)request, uriPrefix, version);
            }
            case UPDATE: {
                return new UpdateRequestUriBuilder((UpdateRequest)request, uriPrefix, version);
            }
            case BATCH_UPDATE: {
                return new BatchUpdateRequestUriBuilder((BatchUpdateRequest)request, uriPrefix, version);
            }
            case DELETE: {
                return new DeleteRequestUriBuilder((DeleteRequest)request, uriPrefix, version);
            }
            case BATCH_PARTIAL_UPDATE: {
                return new BatchPartialUpdateRequestUriBuilder((BatchPartialUpdateRequest)request, uriPrefix, version);
            }
            case BATCH_DELETE: {
                return new BatchDeleteRequestUriBuilder((BatchDeleteRequest)request, uriPrefix, version);
            }
            case GET_ALL: {
                return new GetAllRequestUriBuilder((GetAllRequest)request, uriPrefix, version);
            }
            case OPTIONS: {
                return new OptionsRequestUriBuilder((OptionsRequest)request, uriPrefix, version);
            }
        }
        throw new IllegalArgumentException("Unknown Request method " + request.getMethod());
    }
}

