/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.internal.client;

import com.linkedin.common.Version;
import com.linkedin.data.DataComplex;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.template.DataTemplate;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.transform.filter.request.MaskCreator;
import com.linkedin.restli.common.ComplexResourceKey;
import com.linkedin.restli.common.CompoundKey;
import com.linkedin.restli.common.ProtocolVersion;
import com.linkedin.restli.common.RestConstants;
import com.linkedin.restli.internal.common.AllProtocolVersions;
import com.linkedin.restli.internal.common.URIParamUtils;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class QueryParamsUtil {
    public static DataMap convertToDataMap(Map<String, Object> queryParams) {
        return QueryParamsUtil.convertToDataMap(queryParams, Collections.emptyMap(), AllProtocolVersions.RESTLI_PROTOCOL_1_0_0.getProtocolVersion());
    }

    public static DataMap convertToDataMap(Map<String, Object> queryParams, Map<String, Class<?>> queryParamClasses, ProtocolVersion version) {
        DataMap result = new DataMap(queryParams.size());
        for (Map.Entry<String, Object> entry : queryParams.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (RestConstants.PROJECTION_PARAMETERS.contains(key)) {
                List pathSpecs = (List)value;
                result.put((Object)key, (Object)MaskCreator.createPositiveMask((Collection)pathSpecs).getDataMap());
                continue;
            }
            result.put((Object)key, QueryParamsUtil.paramToDataObject(value, queryParamClasses.get(key), version));
        }
        result.makeReadOnly();
        return result;
    }

    private static Object paramToDataObject(Object param, Class<?> paramClass, ProtocolVersion version) {
        if (param == null) {
            return null;
        }
        if (param instanceof ComplexResourceKey) {
            return ((ComplexResourceKey)param).toDataMap();
        }
        if (version.compareTo((Version)AllProtocolVersions.RESTLI_PROTOCOL_2_0_0.getProtocolVersion()) >= 0 && param instanceof CompoundKey) {
            return URIParamUtils.compoundKeyToDataMap((CompoundKey)((CompoundKey)param));
        }
        if (param instanceof DataTemplate) {
            DataTemplate dataTemplate = (DataTemplate)param;
            return dataTemplate.data();
        }
        if (param instanceof DataComplex) {
            return param;
        }
        if (param instanceof List) {
            return QueryParamsUtil.coerceList((List)param, paramClass, version);
        }
        return DataTemplateUtil.stringify((Object)param, paramClass);
    }

    private static Object coerceList(List<?> values, Class<?> elementClass, ProtocolVersion version) {
        assert (values != null);
        DataList dataList = new DataList();
        for (Object value : values) {
            if (value == null) continue;
            dataList.add(QueryParamsUtil.paramToDataObject(value, elementClass, version));
        }
        return dataList;
    }

    private static List<String> stringifyArray(Object array) {
        assert (array != null && array.getClass().isArray());
        int len = Array.getLength(array);
        ArrayList<String> strings = new ArrayList<String>(len);
        for (int i = 0; i < len; ++i) {
            Object value = Array.get(array, i);
            if (value == null) continue;
            strings.add(value.toString());
        }
        return strings;
    }
}

