/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.internal.client;

import com.linkedin.r2.RemoteInvocationException;
import com.linkedin.restli.client.ErrorHandlingBehavior;
import com.linkedin.restli.client.Response;
import com.linkedin.restli.client.ResponseFuture;
import com.linkedin.restli.client.RestLiResponseException;
import com.linkedin.restli.internal.client.ExceptionUtil;
import com.linkedin.restli.internal.client.ResponseImpl;
import com.linkedin.restli.internal.common.CookieUtil;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class ResponseFutureImpl<T>
implements ResponseFuture<T> {
    private final Future<Response<T>> _responseFuture;
    private final ErrorHandlingBehavior _errorHandlingBehavior;

    public ResponseFutureImpl(Future<Response<T>> responseFuture) {
        this._responseFuture = responseFuture;
        this._errorHandlingBehavior = ErrorHandlingBehavior.FAIL_ON_ERROR;
    }

    public ResponseFutureImpl(Future<Response<T>> responseFuture, ErrorHandlingBehavior errorHandlingBehavior) {
        this._responseFuture = responseFuture;
        this._errorHandlingBehavior = errorHandlingBehavior;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this._responseFuture.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this._responseFuture.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this._responseFuture.isDone();
    }

    @Override
    public Response<T> get() throws ExecutionException, InterruptedException {
        return this._responseFuture.get();
    }

    @Override
    public Response<T> get(long timeout, TimeUnit unit) throws ExecutionException, TimeoutException, InterruptedException {
        return this._responseFuture.get(timeout, unit);
    }

    @Override
    public Response<T> getResponse() throws RemoteInvocationException {
        try {
            return this.getResponseImpl(FutureDereferenceStrategy.IGNORE_TIMEOUT, 0L, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Response<T> getResponse(long timeout, TimeUnit unit) throws RemoteInvocationException, TimeoutException {
        return this.getResponseImpl(FutureDereferenceStrategy.USE_TIMEOUT, timeout, unit);
    }

    private Response<T> getResponseImpl(FutureDereferenceStrategy dereferenceStrategy, long timeout, TimeUnit unit) throws TimeoutException, RemoteInvocationException {
        try {
            if (dereferenceStrategy.equals((Object)FutureDereferenceStrategy.IGNORE_TIMEOUT)) {
                return this._responseFuture.get();
            }
            return this._responseFuture.get(timeout, unit);
        }
        catch (InterruptedException e) {
            throw new RemoteInvocationException((Throwable)e);
        }
        catch (ExecutionException e) {
            RemoteInvocationException exception = ExceptionUtil.wrapThrowable(e.getCause());
            if (this._errorHandlingBehavior == ErrorHandlingBehavior.FAIL_ON_ERROR || !(exception instanceof RestLiResponseException)) {
                throw exception;
            }
            return this.createResponseFromError((RestLiResponseException)exception);
        }
    }

    private Response<T> createResponseFromError(RestLiResponseException restLiResponseException) throws RemoteInvocationException {
        ResponseImpl<RestLiResponseException> response = null;
        response = restLiResponseException.hasDecodedResponse() ? new ResponseImpl<RestLiResponseException>(restLiResponseException.getDecodedResponse(), restLiResponseException) : new ResponseImpl(restLiResponseException.getStatus(), restLiResponseException.getResponse().getHeaders(), CookieUtil.decodeSetCookies((List)restLiResponseException.getResponse().getCookies()), restLiResponseException);
        return response;
    }

    @Override
    public T getResponseEntity() throws RemoteInvocationException {
        return this.getResponse().getEntity();
    }

    @Override
    public T getResponseEntity(long timeout, TimeUnit unit) throws TimeoutException, RemoteInvocationException {
        return this.getResponse(timeout, unit).getEntity();
    }

    public String toString() {
        return "ResponseFutureImpl{_responseFuture=" + this._responseFuture + '}';
    }

    private static enum FutureDereferenceStrategy {
        USE_TIMEOUT,
        IGNORE_TIMEOUT;

    }
}

