/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.reflect.Field;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javolution.util.FastBitSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluatorFactory;
import org.apache.hadoop.hive.ql.exec.KeyWrapper;
import org.apache.hadoop.hive.ql.exec.KeyWrapperFactory;
import org.apache.hadoop.hive.ql.exec.MapredContext;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.OpParseContext;
import org.apache.hadoop.hive.ql.plan.AggregationDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.serde2.lazy.ByteArrayRef;
import org.apache.hadoop.hive.serde2.lazy.LazyBinary;
import org.apache.hadoop.hive.serde2.lazy.LazyPrimitive;
import org.apache.hadoop.hive.serde2.lazy.LazyString;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.UnionObject;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;

public class GroupByOperator
extends Operator<GroupByDesc>
implements Serializable {
    private static final Log LOG = LogFactory.getLog((String)GroupByOperator.class.getName());
    private static final boolean isTraceEnabled = LOG.isTraceEnabled();
    private static final long serialVersionUID = 1L;
    private static final int NUMROWSESTIMATESIZE = 1000;
    protected transient ExprNodeEvaluator[] keyFields;
    protected transient ObjectInspector[] keyObjectInspectors;
    protected transient ExprNodeEvaluator[][] aggregationParameterFields;
    protected transient ObjectInspector[][] aggregationParameterObjectInspectors;
    protected transient ObjectInspector[][] aggregationParameterStandardObjectInspectors;
    protected transient Object[][] aggregationParameterObjects;
    protected transient boolean[] aggregationIsDistinct;
    protected transient Map<Integer, Set<Integer>> distinctKeyAggrs = new HashMap<Integer, Set<Integer>>();
    protected transient Map<Integer, Set<Integer>> nonDistinctKeyAggrs = new HashMap<Integer, Set<Integer>>();
    protected transient List<Integer> nonDistinctAggrs = new ArrayList<Integer>();
    transient ExprNodeEvaluator unionExprEval = null;
    transient GenericUDAFEvaluator[] aggregationEvaluators;
    transient boolean[] estimableAggregationEvaluators;
    protected transient ArrayList<ObjectInspector> objectInspectors;
    transient ArrayList<String> fieldNames;
    protected transient KeyWrapper currentKeys;
    protected transient KeyWrapper newKeys;
    protected transient GenericUDAFEvaluator.AggregationBuffer[] aggregations;
    protected transient Object[][] aggregationsParametersLastInvoke;
    protected transient HashMap<KeyWrapper, GenericUDAFEvaluator.AggregationBuffer[]> hashAggregations;
    protected transient HashSet<KeyWrapper> keysCurrentGroup;
    transient boolean firstRow;
    transient long totalMemory;
    protected transient boolean hashAggr;
    transient boolean groupKeyIsNotReduceKey;
    transient boolean firstRowInGroup;
    transient long numRowsInput;
    transient long numRowsHashTbl;
    transient int groupbyMapAggrInterval;
    transient long numRowsCompareHashAggr;
    transient float minReductionHashAggr;
    protected transient ObjectInspector[] currentKeyObjectInspectors;
    transient StructObjectInspector newKeyObjectInspector;
    transient StructObjectInspector currentKeyObjectInspector;
    public static MemoryMXBean memoryMXBean;
    protected long maxMemory;
    protected float memoryThreshold;
    private boolean groupingSetsPresent;
    private int groupingSetsPosition;
    private List<Integer> groupingSets;
    private List<FastBitSet> groupingSetsBitSet;
    private transient List<Object> newKeysGroupingSets;
    transient List<Integer> keyPositionsSize;
    transient List<Field>[] aggrPositions;
    transient int fixedRowSize;
    protected transient long maxHashTblMemory;
    transient int totalVariableSize;
    transient int numEntriesVarSize;
    protected transient int numEntriesHashTable;
    transient int countAfterReport;
    transient int heartbeatInterval;
    public static final int javaObjectOverHead = 64;
    public static final int javaHashEntryOverHead = 64;
    public static final int javaSizePrimitiveType = 16;
    public static final int javaSizeUnknownType = 256;
    transient Object[] forwardCache;

    public static FastBitSet groupingSet2BitSet(int value) {
        FastBitSet bits = new FastBitSet();
        int index = 0;
        while (value != 0) {
            if (value % 2 != 0) {
                bits.set(index);
            }
            ++index;
            value >>>= 1;
        }
        return bits;
    }

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        int i;
        int i2;
        StructField sf;
        List keysfs;
        ObjectInspector keyObjInspector;
        StructField keyField;
        List sfs;
        this.totalMemory = Runtime.getRuntime().totalMemory();
        this.numRowsInput = 0L;
        this.numRowsHashTbl = 0L;
        this.heartbeatInterval = HiveConf.getIntVar((Configuration)hconf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVESENDHEARTBEAT);
        this.countAfterReport = 0;
        this.groupingSetsPresent = ((GroupByDesc)this.conf).isGroupingSetsPresent();
        ObjectInspector rowInspector = this.inputObjInspectors[0];
        int numKeys = ((GroupByDesc)this.conf).getKeys().size();
        this.keyFields = new ExprNodeEvaluator[numKeys];
        this.keyObjectInspectors = new ObjectInspector[numKeys];
        this.currentKeyObjectInspectors = new ObjectInspector[numKeys];
        for (int i3 = 0; i3 < numKeys; ++i3) {
            this.keyFields[i3] = ExprNodeEvaluatorFactory.get(((GroupByDesc)this.conf).getKeys().get(i3));
            this.keyObjectInspectors[i3] = this.keyFields[i3].initialize(rowInspector);
            this.currentKeyObjectInspectors[i3] = ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)this.keyObjectInspectors[i3], (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
        }
        if (this.groupingSetsPresent) {
            this.groupingSets = ((GroupByDesc)this.conf).getListGroupingSets();
            this.groupingSetsPosition = ((GroupByDesc)this.conf).getGroupingSetPosition();
            this.newKeysGroupingSets = new ArrayList<Object>();
            this.groupingSetsBitSet = new ArrayList<FastBitSet>();
            for (Integer groupingSet : this.groupingSets) {
                ExprNodeEvaluator groupingSetValueEvaluator = ExprNodeEvaluatorFactory.get(new ExprNodeConstantDesc(String.valueOf(groupingSet)));
                this.newKeysGroupingSets.add(groupingSetValueEvaluator.evaluate(null));
                this.groupingSetsBitSet.add(GroupByOperator.groupingSet2BitSet(groupingSet));
            }
        }
        if ((sfs = ((StructObjectInspector)rowInspector).getAllStructFieldRefs()).size() > 0 && (keyField = (StructField)sfs.get(0)).getFieldName().toUpperCase().equals(Utilities.ReduceField.KEY.name()) && (keyObjInspector = keyField.getFieldObjectInspector()) instanceof StructObjectInspector && (keysfs = ((StructObjectInspector)keyObjInspector).getAllStructFieldRefs()).size() > 0 && (sf = (StructField)keysfs.get(keysfs.size() - 1)).getFieldObjectInspector().getCategory().equals((Object)ObjectInspector.Category.UNION)) {
            this.unionExprEval = ExprNodeEvaluatorFactory.get(new ExprNodeColumnDesc(TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)sf.getFieldObjectInspector()), keyField.getFieldName() + "." + sf.getFieldName(), null, false));
            this.unionExprEval.initialize(rowInspector);
        }
        ArrayList<AggregationDesc> aggrs = ((GroupByDesc)this.conf).getAggregators();
        this.aggregationParameterFields = new ExprNodeEvaluator[aggrs.size()][];
        this.aggregationParameterObjectInspectors = new ObjectInspector[aggrs.size()][];
        this.aggregationParameterStandardObjectInspectors = new ObjectInspector[aggrs.size()][];
        this.aggregationParameterObjects = new Object[aggrs.size()][];
        this.aggregationIsDistinct = new boolean[aggrs.size()];
        for (i2 = 0; i2 < aggrs.size(); ++i2) {
            AggregationDesc aggr = aggrs.get(i2);
            ArrayList<ExprNodeDesc> parameters = aggr.getParameters();
            this.aggregationParameterFields[i2] = new ExprNodeEvaluator[parameters.size()];
            this.aggregationParameterObjectInspectors[i2] = new ObjectInspector[parameters.size()];
            this.aggregationParameterStandardObjectInspectors[i2] = new ObjectInspector[parameters.size()];
            this.aggregationParameterObjects[i2] = new Object[parameters.size()];
            for (int j = 0; j < parameters.size(); ++j) {
                this.aggregationParameterFields[i2][j] = ExprNodeEvaluatorFactory.get(parameters.get(j));
                this.aggregationParameterObjectInspectors[i2][j] = this.aggregationParameterFields[i2][j].initialize(rowInspector);
                if (this.unionExprEval != null) {
                    String[] names = parameters.get(j).getExprString().split("\\.");
                    if (Utilities.ReduceField.KEY.name().equals(names[0]) && names.length > 2) {
                        Set<Integer> set;
                        String name = names[names.length - 2];
                        int tag = Integer.parseInt(name.split("\\:")[1]);
                        if (aggr.getDistinct()) {
                            set = this.distinctKeyAggrs.get(tag);
                            if (null == set) {
                                set = new HashSet<Integer>();
                                this.distinctKeyAggrs.put(tag, set);
                            }
                            if (!set.contains(i2)) {
                                set.add(i2);
                            }
                        } else {
                            set = this.nonDistinctKeyAggrs.get(tag);
                            if (null == set) {
                                set = new HashSet<Integer>();
                                this.nonDistinctKeyAggrs.put(tag, set);
                            }
                            if (!set.contains(i2)) {
                                set.add(i2);
                            }
                        }
                    } else if (!this.nonDistinctAggrs.contains(i2)) {
                        this.nonDistinctAggrs.add(i2);
                    }
                } else if (aggr.getDistinct()) {
                    this.aggregationIsDistinct[i2] = true;
                }
                this.aggregationParameterStandardObjectInspectors[i2][j] = ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)this.aggregationParameterObjectInspectors[i2][j], (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
                this.aggregationParameterObjects[i2][j] = null;
            }
            if (parameters.size() != 0 || this.nonDistinctAggrs.contains(i2)) continue;
            this.nonDistinctAggrs.add(i2);
        }
        this.aggregationEvaluators = new GenericUDAFEvaluator[((GroupByDesc)this.conf).getAggregators().size()];
        for (i2 = 0; i2 < this.aggregationEvaluators.length; ++i2) {
            AggregationDesc agg = ((GroupByDesc)this.conf).getAggregators().get(i2);
            this.aggregationEvaluators[i2] = agg.getGenericUDAFEvaluator();
        }
        int totalFields = this.keyFields.length + this.aggregationEvaluators.length;
        this.objectInspectors = new ArrayList(totalFields);
        for (ExprNodeEvaluator keyField2 : this.keyFields) {
            this.objectInspectors.add(null);
        }
        MapredContext context = MapredContext.get();
        if (context != null) {
            for (GenericUDAFEvaluator genericUDAFEvaluator : this.aggregationEvaluators) {
                context.setup(genericUDAFEvaluator);
            }
        }
        for (i = 0; i < this.aggregationEvaluators.length; ++i) {
            ObjectInspector roi = this.aggregationEvaluators[i].init(((GroupByDesc)this.conf).getAggregators().get(i).getMode(), this.aggregationParameterObjectInspectors[i]);
            this.objectInspectors.add(roi);
        }
        this.aggregationsParametersLastInvoke = new Object[((GroupByDesc)this.conf).getAggregators().size()][];
        if ((((GroupByDesc)this.conf).getMode() != GroupByDesc.Mode.HASH || ((GroupByDesc)this.conf).getBucketGroup()) && !this.groupingSetsPresent) {
            this.aggregations = this.newAggregations();
            this.hashAggr = false;
        } else {
            this.hashAggregations = new HashMap(256);
            this.aggregations = this.newAggregations();
            this.hashAggr = true;
            this.keyPositionsSize = new ArrayList<Integer>();
            this.aggrPositions = new List[this.aggregations.length];
            this.groupbyMapAggrInterval = HiveConf.getIntVar((Configuration)hconf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEGROUPBYMAPINTERVAL);
            this.numRowsCompareHashAggr = this.groupbyMapAggrInterval;
            this.minReductionHashAggr = HiveConf.getFloatVar((Configuration)hconf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEMAPAGGRHASHMINREDUCTION);
            this.groupKeyIsNotReduceKey = ((GroupByDesc)this.conf).getGroupKeyNotReductionKey();
            if (this.groupKeyIsNotReduceKey) {
                this.keysCurrentGroup = new HashSet();
            }
        }
        this.fieldNames = ((GroupByDesc)this.conf).getOutputColumnNames();
        for (i = 0; i < this.keyFields.length; ++i) {
            this.objectInspectors.set(i, this.currentKeyObjectInspectors[i]);
        }
        ArrayList<String> keyNames = new ArrayList<String>(this.keyFields.length);
        for (int i4 = 0; i4 < this.keyFields.length; ++i4) {
            keyNames.add(this.fieldNames.get(i4));
        }
        this.newKeyObjectInspector = ObjectInspectorFactory.getStandardStructObjectInspector(keyNames, Arrays.asList(this.keyObjectInspectors));
        this.currentKeyObjectInspector = ObjectInspectorFactory.getStandardStructObjectInspector(keyNames, Arrays.asList(this.currentKeyObjectInspectors));
        this.outputObjInspector = ObjectInspectorFactory.getStandardStructObjectInspector(this.fieldNames, this.objectInspectors);
        KeyWrapperFactory keyWrapperFactory = new KeyWrapperFactory(this.keyFields, this.keyObjectInspectors, this.currentKeyObjectInspectors);
        this.newKeys = keyWrapperFactory.getKeyWrapper();
        this.firstRow = true;
        if (this.hashAggr) {
            this.computeMaxEntriesHashAggr(hconf);
        }
        memoryMXBean = ManagementFactory.getMemoryMXBean();
        this.maxMemory = memoryMXBean.getHeapMemoryUsage().getMax();
        this.memoryThreshold = ((GroupByDesc)this.getConf()).getMemoryThreshold();
        this.initializeChildren(hconf);
    }

    private void computeMaxEntriesHashAggr(Configuration hconf) throws HiveException {
        float memoryPercentage = ((GroupByDesc)this.getConf()).getGroupByMemoryUsage();
        this.maxHashTblMemory = (long)(memoryPercentage * (float)Runtime.getRuntime().maxMemory());
        this.estimateRowSize();
    }

    private int getSize(int pos, PrimitiveObjectInspector.PrimitiveCategory category) {
        switch (category) {
            case VOID: 
            case BOOLEAN: 
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                return 16;
            }
            case STRING: {
                this.keyPositionsSize.add(new Integer(pos));
                return 64;
            }
            case BINARY: {
                this.keyPositionsSize.add(new Integer(pos));
                return 64;
            }
            case TIMESTAMP: {
                return 80;
            }
        }
        return 256;
    }

    private int getSize(int pos, Class<?> c, Field f) {
        if (c.isPrimitive() || c.isInstance(true) || c.isInstance((byte)0) || c.isInstance((short)0) || c.isInstance(0) || c.isInstance(0L) || c.isInstance(new Float(0.0f)) || c.isInstance(new Double(0.0))) {
            return 16;
        }
        if (c.isInstance(new Timestamp(0L))) {
            return 80;
        }
        if (c.isInstance(new String()) || c.isInstance(new ByteArrayRef())) {
            if (this.aggrPositions[pos] == null) {
                this.aggrPositions[pos] = new ArrayList<Field>();
            }
            this.aggrPositions[pos].add(f);
            return 64;
        }
        return 256;
    }

    private int getSize(int pos, TypeInfo typeInfo) {
        if (typeInfo instanceof PrimitiveTypeInfo) {
            return this.getSize(pos, ((PrimitiveTypeInfo)typeInfo).getPrimitiveCategory());
        }
        return 256;
    }

    private void estimateRowSize() throws HiveException {
        this.fixedRowSize = 64;
        ArrayList<ExprNodeDesc> keys = ((GroupByDesc)this.conf).getKeys();
        for (int pos = 0; pos < keys.size(); ++pos) {
            this.fixedRowSize += this.getSize(pos, keys.get(pos).getTypeInfo());
        }
        this.estimableAggregationEvaluators = new boolean[this.aggregationEvaluators.length];
        for (int i = 0; i < this.aggregationEvaluators.length; ++i) {
            Field[] fArr;
            this.fixedRowSize += 64;
            GenericUDAFEvaluator.AggregationBuffer agg = this.aggregationEvaluators[i].getNewAggregationBuffer();
            if (GenericUDAFEvaluator.isEstimable(agg)) {
                this.estimableAggregationEvaluators[i] = true;
                continue;
            }
            for (Field f : fArr = ObjectInspectorUtils.getDeclaredNonStaticFields(agg.getClass())) {
                this.fixedRowSize += this.getSize(i, f.getType(), f);
            }
        }
    }

    protected GenericUDAFEvaluator.AggregationBuffer[] newAggregations() throws HiveException {
        GenericUDAFEvaluator.AggregationBuffer[] aggs = new GenericUDAFEvaluator.AggregationBuffer[this.aggregationEvaluators.length];
        for (int i = 0; i < this.aggregationEvaluators.length; ++i) {
            aggs[i] = this.aggregationEvaluators[i].getNewAggregationBuffer();
        }
        return aggs;
    }

    protected void resetAggregations(GenericUDAFEvaluator.AggregationBuffer[] aggs) throws HiveException {
        for (int i = 0; i < aggs.length; ++i) {
            this.aggregationEvaluators[i].reset(aggs[i]);
        }
    }

    protected void updateAggregations(GenericUDAFEvaluator.AggregationBuffer[] aggs, Object row, ObjectInspector rowInspector, boolean hashAggr, boolean newEntryForHashAggr, Object[][] lastInvoke) throws HiveException {
        block21: {
            block20: {
                int pi;
                Object[] o;
                if (this.unionExprEval == null) {
                    for (int ai = 0; ai < aggs.length; ++ai) {
                        int pi2;
                        Object[] o2 = new Object[this.aggregationParameterFields[ai].length];
                        for (pi2 = 0; pi2 < this.aggregationParameterFields[ai].length; ++pi2) {
                            o2[pi2] = this.aggregationParameterFields[ai][pi2].evaluate(row);
                        }
                        if (this.aggregationIsDistinct[ai]) {
                            if (hashAggr) {
                                if (!newEntryForHashAggr) continue;
                                this.aggregationEvaluators[ai].aggregate(aggs[ai], o2);
                                continue;
                            }
                            if (lastInvoke[ai] == null) {
                                lastInvoke[ai] = new Object[o2.length];
                            }
                            if (ObjectInspectorUtils.compare((Object[])o2, (ObjectInspector[])this.aggregationParameterObjectInspectors[ai], (Object[])lastInvoke[ai], (ObjectInspector[])this.aggregationParameterStandardObjectInspectors[ai]) == 0) continue;
                            this.aggregationEvaluators[ai].aggregate(aggs[ai], o2);
                            for (pi2 = 0; pi2 < o2.length; ++pi2) {
                                lastInvoke[ai][pi2] = ObjectInspectorUtils.copyToStandardObject((Object)o2[pi2], (ObjectInspector)this.aggregationParameterObjectInspectors[ai][pi2], (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
                            }
                            continue;
                        }
                        this.aggregationEvaluators[ai].aggregate(aggs[ai], o2);
                    }
                    return;
                }
                if (this.distinctKeyAggrs.size() <= 0) break block20;
                UnionObject uo = (UnionObject)this.unionExprEval.evaluate(row);
                byte unionTag = uo.getTag();
                if (this.nonDistinctKeyAggrs.get(unionTag) != null) {
                    for (int pos : this.nonDistinctKeyAggrs.get(unionTag)) {
                        o = new Object[this.aggregationParameterFields[pos].length];
                        for (pi = 0; pi < this.aggregationParameterFields[pos].length; ++pi) {
                            o[pi] = this.aggregationParameterFields[pos][pi].evaluate(row);
                        }
                        this.aggregationEvaluators[pos].aggregate(aggs[pos], o);
                    }
                }
                if (this.distinctKeyAggrs.get(unionTag) != null) {
                    for (int i : this.distinctKeyAggrs.get(unionTag)) {
                        o = new Object[this.aggregationParameterFields[i].length];
                        for (pi = 0; pi < this.aggregationParameterFields[i].length; ++pi) {
                            o[pi] = this.aggregationParameterFields[i][pi].evaluate(row);
                        }
                        if (hashAggr) {
                            if (!newEntryForHashAggr) continue;
                            this.aggregationEvaluators[i].aggregate(aggs[i], o);
                            continue;
                        }
                        if (lastInvoke[i] == null) {
                            lastInvoke[i] = new Object[o.length];
                        }
                        if (ObjectInspectorUtils.compare((Object[])o, (ObjectInspector[])this.aggregationParameterObjectInspectors[i], (Object[])lastInvoke[i], (ObjectInspector[])this.aggregationParameterStandardObjectInspectors[i]) == 0) continue;
                        this.aggregationEvaluators[i].aggregate(aggs[i], o);
                        for (pi = 0; pi < o.length; ++pi) {
                            lastInvoke[i][pi] = ObjectInspectorUtils.copyToStandardObject((Object)o[pi], (ObjectInspector)this.aggregationParameterObjectInspectors[i][pi], (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
                        }
                    }
                }
                if (unionTag != 0) break block21;
                for (int pos : this.nonDistinctAggrs) {
                    o = new Object[this.aggregationParameterFields[pos].length];
                    for (pi = 0; pi < this.aggregationParameterFields[pos].length; ++pi) {
                        o[pi] = this.aggregationParameterFields[pos][pi].evaluate(row);
                    }
                    this.aggregationEvaluators[pos].aggregate(aggs[pos], o);
                }
                break block21;
            }
            for (int ai = 0; ai < aggs.length; ++ai) {
                Object[] o = new Object[this.aggregationParameterFields[ai].length];
                for (int pi = 0; pi < this.aggregationParameterFields[ai].length; ++pi) {
                    o[pi] = this.aggregationParameterFields[ai][pi].evaluate(row);
                }
                this.aggregationEvaluators[ai].aggregate(aggs[ai], o);
            }
        }
    }

    @Override
    public void startGroup() throws HiveException {
        this.firstRowInGroup = true;
        super.startGroup();
    }

    @Override
    public void endGroup() throws HiveException {
        if (this.groupKeyIsNotReduceKey) {
            this.keysCurrentGroup.clear();
        }
    }

    private void processKey(Object row, ObjectInspector rowInspector) throws HiveException {
        if (this.hashAggr) {
            this.newKeys.setHashKey();
            this.processHashAggr(row, rowInspector, this.newKeys);
        } else {
            this.processAggr(row, rowInspector, this.newKeys);
        }
        this.firstRowInGroup = false;
        if (this.countAfterReport != 0 && this.countAfterReport % this.heartbeatInterval == 0 && this.reporter != null) {
            this.reporter.progress();
            this.countAfterReport = 0;
        }
    }

    @Override
    public void processOp(Object row, int tag) throws HiveException {
        this.firstRow = false;
        ObjectInspector rowInspector = this.inputObjInspectors[tag];
        if (this.hashAggr && !this.groupKeyIsNotReduceKey) {
            ++this.numRowsInput;
            if (this.numRowsInput == this.numRowsCompareHashAggr) {
                this.numRowsCompareHashAggr += (long)this.groupbyMapAggrInterval;
                if ((float)this.numRowsHashTbl > (float)this.numRowsInput * this.minReductionHashAggr) {
                    LOG.warn((Object)("Disable Hash Aggr: #hash table = " + this.numRowsHashTbl + " #total = " + this.numRowsInput + " reduction = " + 1.0 * (double)(this.numRowsHashTbl / this.numRowsInput) + " minReduction = " + this.minReductionHashAggr));
                    this.flushHashTable(true);
                    this.hashAggr = false;
                } else if (isTraceEnabled) {
                    LOG.trace((Object)("Hash Aggr Enabled: #hash table = " + this.numRowsHashTbl + " #total = " + this.numRowsInput + " reduction = " + 1.0 * (double)(this.numRowsHashTbl / this.numRowsInput) + " minReduction = " + this.minReductionHashAggr));
                }
            }
        }
        try {
            ++this.countAfterReport;
            this.newKeys.getNewKey(row, rowInspector);
            if (this.groupingSetsPresent) {
                Object[] newKeysArray = this.newKeys.getKeyArray();
                Object[] cloneNewKeysArray = new Object[newKeysArray.length];
                for (int keyPos = 0; keyPos < this.groupingSetsPosition; ++keyPos) {
                    cloneNewKeysArray[keyPos] = newKeysArray[keyPos];
                }
                for (int groupingSetPos = 0; groupingSetPos < this.groupingSets.size(); ++groupingSetPos) {
                    for (int keyPos = 0; keyPos < this.groupingSetsPosition; ++keyPos) {
                        newKeysArray[keyPos] = null;
                    }
                    FastBitSet bitset = this.groupingSetsBitSet.get(groupingSetPos);
                    int keyPos = bitset.nextSetBit(0);
                    while (keyPos >= 0) {
                        newKeysArray[keyPos] = cloneNewKeysArray[keyPos];
                        keyPos = bitset.nextSetBit(keyPos + 1);
                    }
                    newKeysArray[this.groupingSetsPosition] = this.newKeysGroupingSets.get(groupingSetPos);
                    this.processKey(row, rowInspector);
                }
            } else {
                this.processKey(row, rowInspector);
            }
        }
        catch (HiveException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    private void processHashAggr(Object row, ObjectInspector rowInspector, KeyWrapper newKeys) throws HiveException {
        GenericUDAFEvaluator.AggregationBuffer[] aggs = null;
        boolean newEntryForHashAggr = false;
        aggs = this.hashAggregations.get(newKeys);
        if (aggs == null) {
            KeyWrapper newKeyProber = newKeys.copyKey();
            aggs = this.newAggregations();
            this.hashAggregations.put(newKeyProber, aggs);
            newEntryForHashAggr = true;
            ++this.numRowsHashTbl;
        }
        if (this.groupKeyIsNotReduceKey) {
            newEntryForHashAggr = this.keysCurrentGroup.add(newKeys.copyKey());
        }
        this.updateAggregations(aggs, row, rowInspector, true, newEntryForHashAggr, null);
        if ((!this.groupKeyIsNotReduceKey || this.firstRowInGroup) && this.shouldBeFlushed(newKeys)) {
            this.flushHashTable(false);
        }
    }

    private void processAggr(Object row, ObjectInspector rowInspector, KeyWrapper newKeys) throws HiveException {
        boolean keysAreEqual;
        GenericUDAFEvaluator.AggregationBuffer[] aggs = null;
        Object[][] lastInvoke = null;
        boolean bl = keysAreEqual = this.currentKeys != null && newKeys != null ? newKeys.equals(this.currentKeys) : false;
        if (this.currentKeys != null && !keysAreEqual && !((GroupByDesc)this.conf).isDontResetAggrsDistinct()) {
            this.forward(this.currentKeys.getKeyArray(), this.aggregations);
            this.countAfterReport = 0;
        }
        if (this.currentKeys == null || !keysAreEqual) {
            if (this.currentKeys == null) {
                this.currentKeys = newKeys.copyKey();
            } else {
                this.currentKeys.copyKey(newKeys);
            }
            if (!((GroupByDesc)this.conf).isDontResetAggrsDistinct()) {
                this.resetAggregations(this.aggregations);
            }
            for (int i = 0; i < this.aggregationsParametersLastInvoke.length; ++i) {
                this.aggregationsParametersLastInvoke[i] = null;
            }
        }
        aggs = this.aggregations;
        lastInvoke = this.aggregationsParametersLastInvoke;
        this.updateAggregations(aggs, row, rowInspector, false, false, lastInvoke);
    }

    private boolean shouldBeFlushed(KeyWrapper newKeys) {
        int numEntries = this.hashAggregations.size();
        if (this.numEntriesHashTable == 0 || numEntries % 1000 == 0) {
            long usedMemory = memoryMXBean.getHeapMemoryUsage().getUsed();
            float rate = (float)usedMemory / (float)this.maxMemory;
            if (rate > this.memoryThreshold) {
                return true;
            }
            for (Integer pos : this.keyPositionsSize) {
                Object key = newKeys.getKeyArray()[pos];
                if (key == null) continue;
                if (key instanceof LazyString) {
                    this.totalVariableSize += ((Text)((LazyPrimitive)key).getWritableObject()).getLength();
                    continue;
                }
                if (key instanceof String) {
                    this.totalVariableSize += ((String)key).length();
                    continue;
                }
                if (key instanceof Text) {
                    this.totalVariableSize += ((Text)key).getLength();
                    continue;
                }
                if (key instanceof LazyBinary) {
                    this.totalVariableSize += ((BytesWritable)((LazyPrimitive)key).getWritableObject()).getLength();
                    continue;
                }
                if (key instanceof BytesWritable) {
                    this.totalVariableSize += ((BytesWritable)key).getLength();
                    continue;
                }
                if (!(key instanceof ByteArrayRef)) continue;
                this.totalVariableSize += ((ByteArrayRef)key).getData().length;
            }
            GenericUDAFEvaluator.AggregationBuffer[] aggs = this.hashAggregations.get(newKeys);
            for (int i = 0; i < aggs.length; ++i) {
                GenericUDAFEvaluator.AggregationBuffer agg = aggs[i];
                if (this.estimableAggregationEvaluators[i]) {
                    this.totalVariableSize += ((GenericUDAFEvaluator.AbstractAggregationBuffer)agg).estimate();
                    continue;
                }
                if (this.aggrPositions[i] == null) continue;
                this.totalVariableSize += this.estimateSize(agg, this.aggrPositions[i]);
            }
            ++this.numEntriesVarSize;
            this.numEntriesHashTable = (int)(this.maxHashTblMemory / (long)(this.fixedRowSize + this.totalVariableSize / this.numEntriesVarSize));
            if (isTraceEnabled) {
                LOG.trace((Object)("Hash Aggr: #hash table = " + numEntries + " #max in hash table = " + this.numEntriesHashTable));
            }
        }
        return numEntries >= this.numEntriesHashTable;
    }

    private int estimateSize(GenericUDAFEvaluator.AggregationBuffer agg, List<Field> fields) {
        int length = 0;
        for (Field f : fields) {
            try {
                Object o = f.get(agg);
                if (o instanceof String) {
                    length += ((String)o).length();
                    continue;
                }
                if (!(o instanceof ByteArrayRef)) continue;
                length += ((ByteArrayRef)o).getData().length;
            }
            catch (Exception e) {}
        }
        return length;
    }

    private void flushHashTable(boolean complete) throws HiveException {
        this.countAfterReport = 0;
        if (complete) {
            for (Map.Entry<KeyWrapper, GenericUDAFEvaluator.AggregationBuffer[]> m : this.hashAggregations.entrySet()) {
                this.forward(m.getKey().getKeyArray(), m.getValue());
            }
            this.hashAggregations.clear();
            this.hashAggregations = null;
            LOG.info((Object)"Hash Table completed flushed");
            return;
        }
        int oldSize = this.hashAggregations.size();
        LOG.info((Object)("Hash Tbl flush: #hash table = " + oldSize));
        Iterator<Map.Entry<KeyWrapper, GenericUDAFEvaluator.AggregationBuffer[]>> iter = this.hashAggregations.entrySet().iterator();
        int numDel = 0;
        while (iter.hasNext()) {
            Map.Entry<KeyWrapper, GenericUDAFEvaluator.AggregationBuffer[]> m = iter.next();
            this.forward(m.getKey().getKeyArray(), m.getValue());
            iter.remove();
            if (++numDel * 10 < oldSize) continue;
            LOG.info((Object)("Hash Table flushed: new size = " + this.hashAggregations.size()));
            return;
        }
    }

    protected void forward(Object[] keys, GenericUDAFEvaluator.AggregationBuffer[] aggs) throws HiveException {
        int i;
        int totalFields = keys.length + aggs.length;
        if (this.forwardCache == null) {
            this.forwardCache = new Object[totalFields];
        }
        for (i = 0; i < keys.length; ++i) {
            this.forwardCache[i] = keys[i];
        }
        for (i = 0; i < aggs.length; ++i) {
            this.forwardCache[keys.length + i] = this.aggregationEvaluators[i].evaluate(aggs[i]);
        }
        this.forward((Object)this.forwardCache, this.outputObjInspector);
    }

    @Override
    public void flush() throws HiveException {
        try {
            if (this.hashAggregations != null) {
                LOG.info((Object)("Begin Hash Table flush: size = " + this.hashAggregations.size()));
                Iterator<Map.Entry<KeyWrapper, GenericUDAFEvaluator.AggregationBuffer[]>> iter = this.hashAggregations.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry<KeyWrapper, GenericUDAFEvaluator.AggregationBuffer[]> m = iter.next();
                    this.forward(m.getKey().getKeyArray(), m.getValue());
                    iter.remove();
                }
                this.hashAggregations.clear();
            } else if (this.aggregations != null) {
                if (this.currentKeys != null) {
                    this.forward(this.currentKeys.getKeyArray(), this.aggregations);
                }
                this.currentKeys = null;
            }
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    @Override
    public void closeOp(boolean abort) throws HiveException {
        if (!abort) {
            try {
                if (this.firstRow && this.keyFields.length == 0) {
                    this.firstRow = false;
                    for (int ai = 0; ai < this.aggregations.length; ++ai) {
                        Object[] o = this.aggregationParameterFields[ai].length > 0 ? new Object[this.aggregationParameterFields[ai].length] : null;
                        for (int pi = 0; pi < this.aggregationParameterFields[ai].length; ++pi) {
                            o[pi] = null;
                        }
                        this.aggregationEvaluators[ai].aggregate(this.aggregations[ai], o);
                    }
                    this.forward(new Object[0], this.aggregations);
                } else {
                    this.flush();
                }
            }
            catch (Exception e) {
                throw new HiveException(e);
            }
        }
    }

    public List<String> genColLists(HashMap<Operator<? extends OperatorDesc>, OpParseContext> opParseCtx) {
        List<String> colLists = new ArrayList<String>();
        ArrayList<ExprNodeDesc> keys = ((GroupByDesc)this.conf).getKeys();
        for (ExprNodeDesc key : keys) {
            colLists = Utilities.mergeUniqElems(colLists, key.getCols());
        }
        ArrayList<AggregationDesc> aggrs = ((GroupByDesc)this.conf).getAggregators();
        for (AggregationDesc aggr : aggrs) {
            ArrayList<ExprNodeDesc> params = aggr.getParameters();
            for (ExprNodeDesc param : params) {
                colLists = Utilities.mergeUniqElems(colLists, param.getCols());
            }
        }
        return colLists;
    }

    @Override
    public String getName() {
        return GroupByOperator.getOperatorName();
    }

    public static String getOperatorName() {
        return "GBY";
    }

    @Override
    public OperatorType getType() {
        return OperatorType.GROUPBY;
    }

    @Override
    public boolean acceptLimitPushdown() {
        return ((GroupByDesc)this.getConf()).getMode() == GroupByDesc.Mode.MERGEPARTIAL || ((GroupByDesc)this.getConf()).getMode() == GroupByDesc.Mode.COMPLETE;
    }
}

