/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.ExtractOperator;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContextRegion;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ExtractDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;

public class VectorExtractOperator
extends ExtractOperator
implements VectorizationContextRegion {
    private static final long serialVersionUID = 1L;
    private List<TypeInfo> reduceTypeInfos;
    private VectorizationContext vOutContext;
    private int[] projectedColumns;

    private String removeValueDotPrefix(String columnName) {
        return columnName.substring("VALUE.".length());
    }

    public VectorExtractOperator(VectorizationContext vContext, OperatorDesc conf) throws HiveException {
        this();
        this.conf = (ExtractDesc)conf;
        List<String> reduceColumnNames = vContext.getProjectionColumnNames();
        int reduceColCount = reduceColumnNames.size();
        this.vOutContext = new VectorizationContext(vContext);
        this.vOutContext.setFileKey(vContext.getFileKey() + "/_EXTRACT_");
        this.vOutContext.resetProjectionColumns();
        for (int i = 0; i < reduceColCount; ++i) {
            String columnName = reduceColumnNames.get(i);
            if (!columnName.startsWith("VALUE.")) continue;
            this.vOutContext.addProjectionColumn(this.removeValueDotPrefix(columnName), i);
        }
    }

    public VectorExtractOperator() {
    }

    public void setReduceTypeInfos(List<TypeInfo> reduceTypeInfos) {
        this.reduceTypeInfos = reduceTypeInfos;
    }

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        int projectionSize = this.vOutContext.getProjectedColumns().size();
        this.projectedColumns = new int[projectionSize];
        ArrayList<String> columnNames = new ArrayList<String>();
        ArrayList<ObjectInspector> ois = new ArrayList<ObjectInspector>();
        for (int i = 0; i < projectionSize; ++i) {
            int projectedIndex;
            this.projectedColumns[i] = projectedIndex = this.vOutContext.getProjectedColumns().get(i).intValue();
            String colName = this.vOutContext.getProjectionColumnNames().get(i);
            columnNames.add(colName);
            TypeInfo typeInfo = this.reduceTypeInfos.get(projectedIndex);
            ObjectInspector oi = TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo((TypeInfo)typeInfo);
            ois.add(oi);
        }
        this.outputObjInspector = ObjectInspectorFactory.getStandardStructObjectInspector(columnNames, ois);
        this.initializeChildren(hconf);
    }

    @Override
    public void processOp(Object row, int tag) throws HiveException {
        VectorizedRowBatch vrg = (VectorizedRowBatch)row;
        int[] originalProjections = vrg.projectedColumns;
        int originalProjectionSize = vrg.projectionSize;
        vrg.projectionSize = this.projectedColumns.length;
        vrg.projectedColumns = this.projectedColumns;
        this.forward(vrg, null);
        vrg.projectionSize = originalProjectionSize;
        vrg.projectedColumns = originalProjections;
    }

    @Override
    public VectorizationContext getOuputVectorizationContext() {
        return this.vOutContext;
    }
}

