/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.HashMap;
import org.antlr.runtime.tree.Tree;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ColumnStatsSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.DDLSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ExplainSQRewriteSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ExplainSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ExportSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.FunctionSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ImportSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.LoadSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.MacroSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.UpdateDeleteSemanticAnalyzer;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.hadoop.hive.ql.session.SessionState;

public final class SemanticAnalyzerFactory {
    static HashMap<Integer, HiveOperation> commandType = new HashMap();
    static HashMap<Integer, HiveOperation[]> tablePartitionCommandType = new HashMap();

    public static BaseSemanticAnalyzer get(HiveConf conf, ASTNode tree) throws SemanticException {
        if (tree.getToken() == null) {
            throw new RuntimeException("Empty Syntax Tree");
        }
        SemanticAnalyzerFactory.setSessionCommandType(commandType.get(tree.getType()));
        switch (tree.getType()) {
            case 669: {
                return new ExplainSemanticAnalyzer(conf);
            }
            case 670: {
                return new ExplainSQRewriteSemanticAnalyzer(conf);
            }
            case 718: {
                return new LoadSemanticAnalyzer(conf);
            }
            case 672: {
                return new ExportSemanticAnalyzer(conf);
            }
            case 699: {
                return new ImportSemanticAnalyzer(conf);
            }
            case 585: {
                Tree child = tree.getChild(1);
                switch (child.getType()) {
                    case 586: 
                    case 587: 
                    case 588: 
                    case 593: 
                    case 594: 
                    case 595: 
                    case 599: 
                    case 600: 
                    case 602: 
                    case 603: 
                    case 605: 
                    case 608: 
                    case 610: 
                    case 611: {
                        SemanticAnalyzerFactory.setSessionCommandType(commandType.get(child.getType()));
                        return new DDLSemanticAnalyzer(conf);
                    }
                }
                HiveOperation commandType = tablePartitionCommandType.get(child.getType())[tree.getChildCount() > 2 ? 1 : 0];
                SemanticAnalyzerFactory.setSessionCommandType(commandType);
                return new DDLSemanticAnalyzer(conf);
            }
            case 613: {
                Tree child = tree.getChild(1);
                switch (child.getType()) {
                    case 614: 
                    case 615: 
                    case 616: 
                    case 617: 
                    case 618: {
                        SemanticAnalyzerFactory.setSessionCommandType(commandType.get(child.getType()));
                        return new DDLSemanticAnalyzer(conf);
                    }
                }
                assert (child.getType() == 773);
                SemanticAnalyzerFactory.setSessionCommandType(HiveOperation.ALTERVIEW_AS);
                return new SemanticAnalyzer(conf);
            }
            case 581: 
            case 582: 
            case 583: 
            case 584: 
            case 591: 
            case 631: 
            case 633: 
            case 636: 
            case 653: 
            case 654: 
            case 655: 
            case 661: 
            case 663: 
            case 665: 
            case 666: 
            case 667: 
            case 682: 
            case 684: 
            case 720: 
            case 721: 
            case 724: 
            case 781: 
            case 782: 
            case 794: 
            case 795: 
            case 796: 
            case 797: 
            case 798: 
            case 799: 
            case 800: 
            case 801: 
            case 802: 
            case 803: 
            case 804: 
            case 805: 
            case 806: 
            case 807: 
            case 808: 
            case 809: 
            case 810: 
            case 811: 
            case 812: 
            case 829: 
            case 870: 
            case 874: 
            case 875: {
                return new DDLSemanticAnalyzer(conf);
            }
            case 632: 
            case 662: {
                return new FunctionSemanticAnalyzer(conf);
            }
            case 619: {
                return new ColumnStatsSemanticAnalyzer(conf);
            }
            case 635: 
            case 664: {
                return new MacroSemanticAnalyzer(conf);
            }
            case 652: 
            case 876: {
                return new UpdateDeleteSemanticAnalyzer(conf);
            }
        }
        return new SemanticAnalyzer(conf);
    }

    private static void setSessionCommandType(HiveOperation commandType) {
        if (SessionState.get() != null) {
            SessionState.get().setCommandType(commandType);
        }
    }

    private SemanticAnalyzerFactory() {
    }

    static {
        commandType.put(669, HiveOperation.EXPLAIN);
        commandType.put(718, HiveOperation.LOAD);
        commandType.put(672, HiveOperation.EXPORT);
        commandType.put(699, HiveOperation.IMPORT);
        commandType.put(631, HiveOperation.CREATEDATABASE);
        commandType.put(661, HiveOperation.DROPDATABASE);
        commandType.put(829, HiveOperation.SWITCHDATABASE);
        commandType.put(637, HiveOperation.CREATETABLE);
        commandType.put(870, HiveOperation.TRUNCATETABLE);
        commandType.put(666, HiveOperation.DROPTABLE);
        commandType.put(655, HiveOperation.DESCTABLE);
        commandType.put(654, HiveOperation.DESCFUNCTION);
        commandType.put(724, HiveOperation.MSCK);
        commandType.put(586, HiveOperation.ALTERTABLE_ADDCOLS);
        commandType.put(605, HiveOperation.ALTERTABLE_REPLACECOLS);
        commandType.put(603, HiveOperation.ALTERTABLE_RENAMECOL);
        commandType.put(602, HiveOperation.ALTERTABLE_RENAME);
        commandType.put(593, HiveOperation.ALTERTABLE_DROPPARTS);
        commandType.put(587, HiveOperation.ALTERTABLE_ADDPARTS);
        commandType.put(610, HiveOperation.ALTERTABLE_TOUCH);
        commandType.put(588, HiveOperation.ALTERTABLE_ARCHIVE);
        commandType.put(611, HiveOperation.ALTERTABLE_UNARCHIVE);
        commandType.put(600, HiveOperation.ALTERTABLE_PROPERTIES);
        commandType.put(594, HiveOperation.ALTERTABLE_PROPERTIES);
        commandType.put(796, HiveOperation.SHOWDATABASES);
        commandType.put(802, HiveOperation.SHOWTABLES);
        commandType.put(794, HiveOperation.SHOWCOLUMNS);
        commandType.put(810, HiveOperation.SHOW_TABLESTATUS);
        commandType.put(811, HiveOperation.SHOW_TBLPROPERTIES);
        commandType.put(804, HiveOperation.SHOW_CREATETABLE);
        commandType.put(798, HiveOperation.SHOWFUNCTIONS);
        commandType.put(799, HiveOperation.SHOWINDEXES);
        commandType.put(801, HiveOperation.SHOWPARTITIONS);
        commandType.put(800, HiveOperation.SHOWLOCKS);
        commandType.put(797, HiveOperation.SHOWLOCKS);
        commandType.put(795, HiveOperation.SHOWCONF);
        commandType.put(632, HiveOperation.CREATEFUNCTION);
        commandType.put(662, HiveOperation.DROPFUNCTION);
        commandType.put(635, HiveOperation.CREATEMACRO);
        commandType.put(664, HiveOperation.DROPMACRO);
        commandType.put(638, HiveOperation.CREATEVIEW);
        commandType.put(667, HiveOperation.DROPVIEW);
        commandType.put(633, HiveOperation.CREATEINDEX);
        commandType.put(663, HiveOperation.DROPINDEX);
        commandType.put(584, HiveOperation.ALTERINDEX_REBUILD);
        commandType.put(583, HiveOperation.ALTERINDEX_PROPS);
        commandType.put(617, HiveOperation.ALTERVIEW_PROPERTIES);
        commandType.put(616, HiveOperation.ALTERVIEW_PROPERTIES);
        commandType.put(614, HiveOperation.ALTERTABLE_ADDPARTS);
        commandType.put(615, HiveOperation.ALTERTABLE_DROPPARTS);
        commandType.put(618, HiveOperation.ALTERVIEW_RENAME);
        commandType.put(613, HiveOperation.ALTERVIEW_AS);
        commandType.put(773, HiveOperation.QUERY);
        commandType.put(721, HiveOperation.LOCKTABLE);
        commandType.put(875, HiveOperation.UNLOCKTABLE);
        commandType.put(720, HiveOperation.LOCKDB);
        commandType.put(874, HiveOperation.UNLOCKDB);
        commandType.put(636, HiveOperation.CREATEROLE);
        commandType.put(665, HiveOperation.DROPROLE);
        commandType.put(682, HiveOperation.GRANT_PRIVILEGE);
        commandType.put(781, HiveOperation.REVOKE_PRIVILEGE);
        commandType.put(805, HiveOperation.SHOW_GRANT);
        commandType.put(684, HiveOperation.GRANT_ROLE);
        commandType.put(782, HiveOperation.REVOKE_ROLE);
        commandType.put(806, HiveOperation.SHOW_ROLES);
        commandType.put(809, HiveOperation.SHOW_ROLES);
        commandType.put(808, HiveOperation.SHOW_ROLE_PRINCIPALS);
        commandType.put(807, HiveOperation.SHOW_ROLE_GRANT);
        commandType.put(582, HiveOperation.ALTERDATABASE);
        commandType.put(581, HiveOperation.ALTERDATABASE_OWNER);
        commandType.put(653, HiveOperation.DESCDATABASE);
        commandType.put(608, HiveOperation.ALTERTABLE_SKEWED);
        commandType.put(619, HiveOperation.ANALYZE_TABLE);
        commandType.put(599, HiveOperation.ALTERTABLE_PARTCOLTYPE);
        commandType.put(803, HiveOperation.SHOW_COMPACTIONS);
        commandType.put(812, HiveOperation.SHOW_TRANSACTIONS);
        tablePartitionCommandType.put(601, new HiveOperation[]{HiveOperation.ALTERTABLE_PROTECTMODE, HiveOperation.ALTERPARTITION_PROTECTMODE});
        tablePartitionCommandType.put(596, new HiveOperation[]{HiveOperation.ALTERTABLE_FILEFORMAT, HiveOperation.ALTERPARTITION_FILEFORMAT});
        tablePartitionCommandType.put(597, new HiveOperation[]{HiveOperation.ALTERTABLE_LOCATION, HiveOperation.ALTERPARTITION_LOCATION});
        tablePartitionCommandType.put(598, new HiveOperation[]{HiveOperation.ALTERTABLE_MERGEFILES, HiveOperation.ALTERPARTITION_MERGEFILES});
        tablePartitionCommandType.put(607, new HiveOperation[]{HiveOperation.ALTERTABLE_SERIALIZER, HiveOperation.ALTERPARTITION_SERIALIZER});
        tablePartitionCommandType.put(606, new HiveOperation[]{HiveOperation.ALTERTABLE_SERDEPROPERTIES, HiveOperation.ALTERPARTITION_SERDEPROPERTIES});
        tablePartitionCommandType.put(604, new HiveOperation[]{null, HiveOperation.ALTERTABLE_RENAMEPART});
        tablePartitionCommandType.put(592, new HiveOperation[]{HiveOperation.ALTERTABLE_COMPACT, HiveOperation.ALTERTABLE_COMPACT});
        tablePartitionCommandType.put(609, new HiveOperation[]{HiveOperation.ALTERTBLPART_SKEWED_LOCATION, HiveOperation.ALTERTBLPART_SKEWED_LOCATION});
        tablePartitionCommandType.put(589, new HiveOperation[]{HiveOperation.ALTERTABLE_BUCKETNUM, HiveOperation.ALTERPARTITION_BUCKETNUM});
        tablePartitionCommandType.put(591, new HiveOperation[]{HiveOperation.ALTERTABLE_CLUSTER_SORT, HiveOperation.ALTERTABLE_CLUSTER_SORT});
        tablePartitionCommandType.put(612, new HiveOperation[]{HiveOperation.ALTERTABLE_UPDATETABLESTATS, HiveOperation.ALTERTABLE_UPDATEPARTSTATS});
    }
}

