/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.io.BytesWritable;

@Description(name="encode", value="_FUNC_(str, str) - Encode the first argument using the second argument character set", extended="Possible options for the character set are 'US_ASCII', 'ISO-8859-1',\n'UTF-8', 'UTF-16BE', 'UTF-16LE', and 'UTF-16'. If either argument\nis null, the result will also be null")
public class GenericUDFEncode
extends GenericUDF {
    private transient CharsetEncoder encoder = null;
    private transient PrimitiveObjectInspector stringOI = null;
    private transient PrimitiveObjectInspector charsetOI = null;
    private transient BytesWritable result = new BytesWritable();

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 2) {
            throw new UDFArgumentLengthException("Encode() requires exactly two arguments");
        }
        if (arguments[0].getCategory() != ObjectInspector.Category.PRIMITIVE || PrimitiveObjectInspectorUtils.PrimitiveGrouping.STRING_GROUP != PrimitiveObjectInspectorUtils.getPrimitiveGrouping((PrimitiveObjectInspector.PrimitiveCategory)((PrimitiveObjectInspector)arguments[0]).getPrimitiveCategory())) {
            throw new UDFArgumentTypeException(0, "The first argument to Encode() must be a string/varchar");
        }
        this.stringOI = (PrimitiveObjectInspector)arguments[0];
        if (arguments[1].getCategory() != ObjectInspector.Category.PRIMITIVE || PrimitiveObjectInspectorUtils.PrimitiveGrouping.STRING_GROUP != PrimitiveObjectInspectorUtils.getPrimitiveGrouping((PrimitiveObjectInspector.PrimitiveCategory)((PrimitiveObjectInspector)arguments[1]).getPrimitiveCategory())) {
            throw new UDFArgumentTypeException(1, "The second argument to Encode() must be a string/varchar");
        }
        this.charsetOI = (PrimitiveObjectInspector)arguments[1];
        if (this.charsetOI instanceof ConstantObjectInspector) {
            String charSetName = ((ConstantObjectInspector)arguments[1]).getWritableConstantValue().toString();
            this.encoder = Charset.forName(charSetName).newEncoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        }
        this.result = new BytesWritable();
        return PrimitiveObjectInspectorFactory.writableBinaryObjectInspector;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        ByteBuffer encoded;
        String value = PrimitiveObjectInspectorUtils.getString((Object)arguments[0].get(), (PrimitiveObjectInspector)this.stringOI);
        if (value == null) {
            return null;
        }
        if (this.encoder != null) {
            try {
                encoded = this.encoder.encode(CharBuffer.wrap(value));
            }
            catch (CharacterCodingException e) {
                throw new HiveException(e);
            }
        } else {
            encoded = Charset.forName(PrimitiveObjectInspectorUtils.getString((Object)arguments[1].get(), (PrimitiveObjectInspector)this.charsetOI)).encode(value);
        }
        this.result.setSize(encoded.limit());
        encoded.get(this.result.getBytes(), 0, encoded.limit());
        return this.result;
    }

    @Override
    public String getDisplayString(String[] children) {
        assert (children.length == 2);
        StringBuilder sb = new StringBuilder();
        sb.append("encode(");
        sb.append(children[0]).append(",");
        sb.append(children[1]).append(")");
        return sb.toString();
    }
}

