/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashSet;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;

@Description(name="in_file", value="_FUNC_(str, filename) - Returns true if str appears in the file")
public class GenericUDFInFile
extends GenericUDF {
    private HashSet<String> set;
    private transient ObjectInspector strObjectInspector;
    private transient ObjectInspector fileObjectInspector;

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 2) {
            throw new UDFArgumentLengthException("IN_FILE() accepts exactly 2 arguments.");
        }
        this.strObjectInspector = arguments[0];
        this.fileObjectInspector = arguments[1];
        if (!this.isTypeCompatible(this.strObjectInspector)) {
            throw new UDFArgumentTypeException(0, "The first argument of function IN_FILE must be a string, char or varchar but " + this.strObjectInspector.toString() + " was given.");
        }
        if (((PrimitiveObjectInspector)this.fileObjectInspector).getPrimitiveCategory() != PrimitiveObjectInspector.PrimitiveCategory.STRING || !ObjectInspectorUtils.isConstantObjectInspector((ObjectInspector)this.fileObjectInspector)) {
            throw new UDFArgumentTypeException(1, "The second argument of IN_FILE() must be a constant string but " + this.fileObjectInspector.toString() + " was given.");
        }
        return PrimitiveObjectInspectorFactory.javaBooleanObjectInspector;
    }

    private boolean isTypeCompatible(ObjectInspector argument) {
        PrimitiveObjectInspector poi = (PrimitiveObjectInspector)argument;
        return poi.getPrimitiveCategory() == PrimitiveObjectInspector.PrimitiveCategory.STRING || poi.getPrimitiveCategory() == PrimitiveObjectInspector.PrimitiveCategory.CHAR || poi.getPrimitiveCategory() == PrimitiveObjectInspector.PrimitiveCategory.VARCHAR;
    }

    @Override
    public String[] getRequiredFiles() {
        return new String[]{ObjectInspectorUtils.getWritableConstantValue((ObjectInspector)this.fileObjectInspector).toString()};
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        if (arguments[0].get() == null || arguments[1].get() == null) {
            return null;
        }
        String str = ObjectInspectorUtils.copyToStandardJavaObject((Object)arguments[0].get(), (ObjectInspector)this.strObjectInspector).toString();
        if (this.set == null) {
            String fileName = (String)ObjectInspectorUtils.copyToStandardJavaObject((Object)arguments[1].get(), (ObjectInspector)this.fileObjectInspector);
            try {
                this.load(new FileInputStream(new File(fileName).getName()));
            }
            catch (FileNotFoundException e) {
                throw new HiveException(e);
            }
        }
        return this.set.contains(str);
    }

    public void load(InputStream is) throws HiveException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        this.set = new HashSet();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                this.set.add(line);
            }
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    @Override
    public String getDisplayString(String[] children) {
        assert (children.length == 2);
        return "in_file(" + children[0] + ", " + children[1] + ")";
    }
}

