/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime;

import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.gobblin.Constructs;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.converter.Converter;
import org.apache.gobblin.converter.DataConversionException;
import org.apache.gobblin.converter.EmptyIterable;
import org.apache.gobblin.converter.IdentityConverter;
import org.apache.gobblin.converter.SchemaConversionException;
import org.apache.gobblin.converter.SingleRecordIterable;
import org.apache.gobblin.state.ConstructState;

public class MultiConverter
extends Converter<Object, Object, Object, Object> {
    private final List<Converter<?, ?, ?, ?>> converters;
    private final Map<Converter<?, ?, ?, ?>, Object> convertedSchemaMap = Maps.newHashMap();

    public MultiConverter(List<Converter<?, ?, ?, ?>> converters) {
        this.converters = Lists.newArrayList(converters);
    }

    public void close() throws IOException {
        for (Converter<?, ?, ?, ?> converter : this.converters) {
            converter.close();
        }
    }

    public Object convertSchema(Object inputSchema, WorkUnitState workUnit) throws SchemaConversionException {
        Object schema = inputSchema;
        for (Converter<?, ?, ?, ?> converter : this.converters) {
            schema = converter.convertSchema(schema, workUnit);
            this.convertedSchemaMap.put(converter, schema);
        }
        return schema;
    }

    public Iterable<Object> convertRecord(Object outputSchema, final Object inputRecord, final WorkUnitState workUnit) throws DataConversionException {
        if (this.convertedSchemaMap.size() != this.converters.size()) {
            throw new RuntimeException("convertRecord should be called only after convertSchema is called");
        }
        return new Iterable<Object>(){

            @Override
            public Iterator<Object> iterator() {
                try {
                    return new MultiConverterIterator(inputRecord, workUnit);
                }
                catch (DataConversionException dce) {
                    throw new RuntimeException(dce);
                }
            }
        };
    }

    public State getFinalState() {
        ConstructState state = new ConstructState(super.getFinalState());
        for (int i = 0; i < this.converters.size(); ++i) {
            state.addConstructState(Constructs.CONVERTER, new ConstructState(this.converters.get(i).getFinalState()), Integer.toString(i));
        }
        return state;
    }

    public List<Converter<?, ?, ?, ?>> getConverters() {
        return this.converters;
    }

    private class MultiConverterIterator
    implements Iterator<Object> {
        private final WorkUnitState workUnitState;
        private Iterator<Object> chainedConverterIterator;

        public MultiConverterIterator(Object inputRecord, WorkUnitState workUnitState) throws DataConversionException {
            this.workUnitState = workUnitState;
            this.chainedConverterIterator = new ChainedConverterIterator(new SingleRecordIterable(inputRecord).iterator(), (Converter)(MultiConverter.this.converters.isEmpty() ? new IdentityConverter() : (Converter)MultiConverter.this.converters.get(0)));
            for (int i = 1; i < MultiConverter.this.converters.size(); ++i) {
                this.chainedConverterIterator = new ChainedConverterIterator(this.chainedConverterIterator, (Converter)MultiConverter.this.converters.get(i));
            }
        }

        @Override
        public boolean hasNext() {
            return this.chainedConverterIterator.hasNext();
        }

        @Override
        public Object next() {
            return this.chainedConverterIterator.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private class ChainedConverterIterator
        implements Iterator<Object> {
            private final Converter converter;
            private final Iterator<Object> prevIterator;
            private Iterator<Object> currentIterator;

            public ChainedConverterIterator(Iterator<Object> prevIterator, Converter converter) throws DataConversionException {
                this.converter = converter;
                this.prevIterator = prevIterator;
                this.currentIterator = this.prevIterator.hasNext() ? converter.convertRecord(MultiConverter.this.convertedSchemaMap.get(converter), this.prevIterator.next(), MultiConverterIterator.this.workUnitState).iterator() : new EmptyIterable().iterator();
            }

            @Override
            public boolean hasNext() {
                if (this.currentIterator.hasNext()) {
                    return true;
                }
                while (this.prevIterator.hasNext()) {
                    try {
                        this.currentIterator = this.converter.convertRecord(MultiConverter.this.convertedSchemaMap.get(this.converter), this.prevIterator.next(), MultiConverterIterator.this.workUnitState).iterator();
                    }
                    catch (DataConversionException e) {
                        Throwables.propagate((Throwable)e);
                    }
                    if (!this.currentIterator.hasNext()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public Object next() {
                if (this.hasNext()) {
                    return this.currentIterator.next();
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

