/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.task;

import com.google.common.base.Optional;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.runtime.task.TaskFactory;

public class TaskUtils {
    private static final String TASK_FACTORY_CLASS = "org.apache.gobblin.runtime.taskFactoryClass";

    public static Optional<TaskFactory> getTaskFactory(State state) {
        try {
            if (state.contains(TASK_FACTORY_CLASS)) {
                return Optional.of((Object)((TaskFactory)Class.forName(state.getProp(TASK_FACTORY_CLASS)).newInstance()));
            }
            return Optional.absent();
        }
        catch (ReflectiveOperationException roe) {
            throw new RuntimeException("Could not create task factory.", roe);
        }
    }

    public static void setTaskFactoryClass(State state, Class<? extends TaskFactory> klazz) {
        state.setProp(TASK_FACTORY_CLASS, (Object)klazz.getName());
    }
}

