/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.template;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigMergeable;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.gobblin.runtime.api.JobCatalogWithTemplates;
import org.apache.gobblin.runtime.api.JobTemplate;
import org.apache.gobblin.runtime.api.SpecNotFoundException;

public abstract class InheritingJobTemplate
implements JobTemplate {
    private final List<URI> superTemplateUris;
    private final JobCatalogWithTemplates catalog;
    private List<JobTemplate> superTemplates;
    private boolean resolved;

    public InheritingJobTemplate(List<URI> superTemplateUris, JobCatalogWithTemplates catalog) {
        this.superTemplateUris = superTemplateUris;
        this.catalog = catalog;
        this.resolved = false;
    }

    public InheritingJobTemplate(List<JobTemplate> superTemplates) {
        this.superTemplateUris = Lists.newArrayList();
        this.catalog = null;
        this.superTemplates = superTemplates;
        this.resolved = true;
    }

    private synchronized void ensureTemplatesResolved() throws SpecNotFoundException, JobTemplate.TemplateException {
        if (this.resolved) {
            return;
        }
        HashMap loadedTemplates = Maps.newHashMap();
        loadedTemplates.put(this.getUri(), this);
        this.resolveTemplates(loadedTemplates);
    }

    private void resolveTemplates(Map<URI, JobTemplate> loadedTemplates) throws SpecNotFoundException, JobTemplate.TemplateException {
        if (this.resolved) {
            return;
        }
        this.superTemplates = Lists.newArrayList();
        for (URI uri : this.superTemplateUris) {
            if (!loadedTemplates.containsKey(uri)) {
                JobTemplate newTemplate = this.catalog.getTemplate(uri);
                loadedTemplates.put(uri, newTemplate);
                if (newTemplate instanceof InheritingJobTemplate) {
                    ((InheritingJobTemplate)newTemplate).resolveTemplates(loadedTemplates);
                }
            }
            this.superTemplates.add(loadedTemplates.get(uri));
        }
        this.resolved = true;
    }

    public Collection<JobTemplate> getSuperTemplates() throws SpecNotFoundException, JobTemplate.TemplateException {
        this.ensureTemplatesResolved();
        return ImmutableList.copyOf(this.superTemplates);
    }

    @Override
    public Config getRawTemplateConfig() throws SpecNotFoundException, JobTemplate.TemplateException {
        this.ensureTemplatesResolved();
        return this.getRawTemplateConfigHelper(Sets.newHashSet());
    }

    private Config getRawTemplateConfigHelper(Set<JobTemplate> alreadyInheritedTemplates) throws SpecNotFoundException, JobTemplate.TemplateException {
        Config rawTemplate = this.getLocalRawTemplate();
        for (JobTemplate template : Lists.reverse(this.superTemplates)) {
            if (alreadyInheritedTemplates.contains(template)) continue;
            alreadyInheritedTemplates.add(template);
            Config thisFallback = template instanceof InheritingJobTemplate ? ((InheritingJobTemplate)template).getRawTemplateConfigHelper(alreadyInheritedTemplates) : template.getRawTemplateConfig();
            rawTemplate = rawTemplate.withFallback((ConfigMergeable)thisFallback);
        }
        return rawTemplate;
    }

    protected abstract Config getLocalRawTemplate();

    @Override
    public Collection<String> getRequiredConfigList() throws SpecNotFoundException, JobTemplate.TemplateException {
        this.ensureTemplatesResolved();
        Set<String> allRequired = this.getRequiredConfigListHelper(Sets.newHashSet());
        final Config rawConfig = this.getRawTemplateConfig();
        Set filteredRequired = Sets.filter(allRequired, (Predicate)new Predicate<String>(){

            public boolean apply(String input) {
                return !rawConfig.hasPath(input);
            }
        });
        return filteredRequired;
    }

    private Set<String> getRequiredConfigListHelper(Set<JobTemplate> alreadyLoadedTemplates) throws SpecNotFoundException, JobTemplate.TemplateException {
        HashSet requiredConfigs = Sets.newHashSet(this.getLocallyRequiredConfigList());
        for (JobTemplate template : this.superTemplates) {
            if (alreadyLoadedTemplates.contains(template)) continue;
            alreadyLoadedTemplates.add(template);
            requiredConfigs.addAll(template instanceof InheritingJobTemplate ? ((InheritingJobTemplate)template).getRequiredConfigListHelper(alreadyLoadedTemplates) : template.getRequiredConfigList());
        }
        return requiredConfigs;
    }

    protected abstract Collection<String> getLocallyRequiredConfigList();

    @Override
    public Config getResolvedConfig(Config userConfig) throws SpecNotFoundException, JobTemplate.TemplateException {
        this.ensureTemplatesResolved();
        return this.getResolvedConfigHelper(userConfig, Sets.newHashSet());
    }

    private Config getResolvedConfigHelper(Config userConfig, Set<JobTemplate> alreadyLoadedTemplates) throws SpecNotFoundException, JobTemplate.TemplateException {
        Config config = this.getLocallyResolvedConfig(userConfig);
        for (JobTemplate template : Lists.reverse(this.superTemplates)) {
            if (alreadyLoadedTemplates.contains(template)) continue;
            alreadyLoadedTemplates.add(template);
            Config fallback = template instanceof InheritingJobTemplate ? ((InheritingJobTemplate)template).getResolvedConfigHelper(config, alreadyLoadedTemplates) : template.getResolvedConfig(config);
            config = config.withFallback((ConfigMergeable)fallback);
        }
        return config;
    }

    protected abstract Config getLocallyResolvedConfig(Config var1) throws JobTemplate.TemplateException;
}

