/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.util;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueFactory;
import java.util.Map;
import org.apache.gobblin.metastore.StateStore;
import org.apache.gobblin.runtime.JobState;
import org.apache.gobblin.runtime.TaskState;
import org.apache.gobblin.source.workunit.MultiWorkUnit;
import org.apache.gobblin.source.workunit.WorkUnit;
import org.apache.gobblin.util.ClassAliasResolver;
import org.apache.gobblin.util.ConfigUtils;
import org.apache.hadoop.fs.Path;

public class StateStores {
    private final StateStore<TaskState> taskStateStore;
    private final StateStore<WorkUnit> wuStateStore;
    private final StateStore<MultiWorkUnit> mwuStateStore;
    private final StateStore<JobState> jobStateStore;

    public StateStores(Config config, Path taskStoreBase, String taskStoreTable, Path workUnitStoreBase, String workUnitStoreTable, Path jobStateStoreBase, String jobStateStoreTable) {
        StateStore.Factory stateStoreFactory;
        String stateStoreType = ConfigUtils.getString((Config)config, (String)"intermediate.state.store.type", (String)ConfigUtils.getString((Config)config, (String)"state.store.type", (String)"fs"));
        ClassAliasResolver resolver = new ClassAliasResolver(StateStore.Factory.class);
        try {
            stateStoreFactory = (StateStore.Factory)resolver.resolveClass(stateStoreType).newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException(cnfe);
        }
        catch (InstantiationException ie) {
            throw new RuntimeException(ie);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException(iae);
        }
        Path inputWorkUnitDir = new Path(workUnitStoreBase, workUnitStoreTable);
        Config wuStateStoreConfig = StateStores.getStateStoreConfig(config, inputWorkUnitDir.toString(), workUnitStoreTable);
        Path taskStateOutputDir = new Path(taskStoreBase, taskStoreTable);
        Config taskStateStoreConfig = StateStores.getStateStoreConfig(config, taskStateOutputDir.toString(), taskStoreTable);
        this.taskStateStore = stateStoreFactory.createStateStore(taskStateStoreConfig, TaskState.class);
        this.wuStateStore = stateStoreFactory.createStateStore(wuStateStoreConfig, WorkUnit.class);
        this.mwuStateStore = stateStoreFactory.createStateStore(wuStateStoreConfig, MultiWorkUnit.class);
        if (ConfigUtils.getBoolean((Config)config, (String)"state.store.jobStateInStateStore", (boolean)false)) {
            Path jobStateOutputDir = new Path(jobStateStoreBase, jobStateStoreTable);
            Config jobStateStoreConfig = StateStores.getStateStoreConfig(config, jobStateOutputDir.toString(), jobStateStoreTable);
            this.jobStateStore = stateStoreFactory.createStateStore(jobStateStoreConfig, JobState.class);
        } else {
            this.jobStateStore = null;
        }
    }

    public boolean haveJobStateStore() {
        return this.jobStateStore != null;
    }

    private static Config getStateStoreConfig(Config config, String rootDir, String dbTableKey) {
        Config fallbackConfig = ConfigFactory.empty().withFallback((ConfigMergeable)config).withValue("state.store.dir", ConfigValueFactory.fromAnyRef((Object)rootDir)).withValue("state.store.db.table", ConfigValueFactory.fromAnyRef((Object)dbTableKey));
        Config scopedConfig = ConfigFactory.empty();
        for (Map.Entry entry : config.withOnlyPath("intermediate").entrySet()) {
            scopedConfig.withValue(((String)entry.getKey()).substring("intermediate".length()), (ConfigValue)entry.getValue());
        }
        return scopedConfig.withFallback((ConfigMergeable)fallbackConfig);
    }

    public StateStore<TaskState> getTaskStateStore() {
        return this.taskStateStore;
    }

    public StateStore<WorkUnit> getWuStateStore() {
        return this.wuStateStore;
    }

    public StateStore<MultiWorkUnit> getMwuStateStore() {
        return this.mwuStateStore;
    }

    public StateStore<JobState> getJobStateStore() {
        return this.jobStateStore;
    }
}

