/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2;

import com.linkedin.d2.latencyType;
import com.linkedin.data.DataMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.SetMode;
import java.util.List;

public class D2DegraderProperties
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema((String)"{\"type\":\"record\",\"name\":\"D2DegraderProperties\",\"namespace\":\"com.linkedin.d2\",\"doc\":\"Degrader properties that is applied to all tracker clients talking to this particular D2 service\",\"fields\":[{\"name\":\"name\",\"type\":\"string\",\"doc\":\"The name of this degrader.\",\"optional\":true},{\"name\":\"logEnabled\",\"type\":\"boolean\",\"doc\":\"Whether degrader-specific logging is enabled or not. Defaults to false.\",\"default\":false},{\"name\":\"maxDropRate\",\"type\":\"double\",\"doc\":\"The maximum drop rate that this degrader can achieve. Values are from 0.0 - 1.0. Defaults to 1.0.\",\"optional\":true},{\"name\":\"upStep\",\"type\":\"double\",\"doc\":\"Degrader's step function's delta size for increasing the drop rate. Values are from 0.0 - 1.0. Defaults to 0.2.\",\"optional\":true},{\"name\":\"downStep\",\"type\":\"double\",\"doc\":\"Degrader's step function's delta size for decreasing the drop rate. Values are from 0.0 - 1.0. Defaults to 0.2.\",\"optional\":true},{\"name\":\"minCallCount\",\"type\":\"int\",\"doc\":\"The minimum number of call count that should be achieved before degrader start using the call statistics to compute drop rate. Defaults to 10.\",\"optional\":true},{\"name\":\"highLatency\",\"type\":\"int\",\"doc\":\"If the call latency during the interval exceeds this value, then we will increase the drop rate by upStep. Defaults to 3000ms.\",\"optional\":true},{\"name\":\"lowLatency\",\"type\":\"int\",\"doc\":\"If the call latency during the interval is under this value, then we will decrease the drop rate by downStep. Defaults to 500ms.\",\"optional\":true},{\"name\":\"highErrorRate\",\"type\":\"double\",\"doc\":\"If the error rate during the interval exceeds this value, then we will increase the drop rate by upStep. Values are from 0.0 - 1.0. Defaults to 1.1.\",\"optional\":true},{\"name\":\"lowErrorRate\",\"type\":\"double\",\"doc\":\"If the error rate during the interval is under this value, then we will decrease the drop rate by downStep. Values are from 0.0 - 1.0. Defaults to 1.1.\",\"optional\":true},{\"name\":\"highOutstanding\",\"type\":\"int\",\"doc\":\"If the latency of outstanding calls during the interval exceeds this value, then we will increase the drop rate by upStep. Defaults to 10000ms.\",\"optional\":true},{\"name\":\"lowOutstanding\",\"type\":\"int\",\"doc\":\"If the latency of outstanding calls during the interval is under this value, then we will decrease the drop rate by downStep. Defaults to 500ms.\",\"optional\":true},{\"name\":\"minOutstandingCount\",\"type\":\"int\",\"doc\":\"If the number of minOutstanding calls exceeds this value then we will consider outstanding latency to compute drop rate. Defaults to 5.\",\"optional\":true},{\"name\":\"maxDropDuration\",\"type\":\"long\",\"doc\":\"maximum duration that is allowed when all requests are dropped. For example, if maxDropDuration is 1 min and the last request that should not be dropped is older than 1 min, then the next request should not be dropped. Defaults to 60000ms.\",\"optional\":true},{\"name\":\"latencyToUse\",\"type\":{\"type\":\"enum\",\"name\":\"latencyType\",\"symbols\":[\"AVERAGE\",\"PCT50\",\"PCT90\",\"PCT95\",\"PCT99\"],\"symbolDocs\":{\"AVERAGE\":\"Average latency\",\"PCT50\":\"50th percentile latency\",\"PCT90\":\"90th percentile latency\",\"PCT95\":\"95th percentile latency\",\"PCT99\":\"99th percentile latency\"}},\"doc\":\"latency used to calculate the drop rate. Defaults to AVERAGE.\",\"optional\":true},{\"name\":\"initialDropRate\",\"type\":\"double\",\"doc\":\"The initial drop rate that this degrader should start with. Defaults to 0.0. For values greater than 0, it means the tracker client corresponding to this degrader will receive less than 100% of the normal traffic initially and slowly recover from there.\",\"optional\":true},{\"name\":\"slowStartThreshold\",\"type\":\"double\",\"doc\":\"The drop rate threshold that controls whether the degrader should perform slow start(by doubling the transmission rate) or the normal stepUp/Down operation. Defaults to 0.0 which means no slow start phase will be performed.\",\"optional\":true}]}");
    private static final RecordDataSchema.Field FIELD_Name = SCHEMA.getField("name");
    private static final RecordDataSchema.Field FIELD_LogEnabled = SCHEMA.getField("logEnabled");
    private static final RecordDataSchema.Field FIELD_MaxDropRate = SCHEMA.getField("maxDropRate");
    private static final RecordDataSchema.Field FIELD_UpStep = SCHEMA.getField("upStep");
    private static final RecordDataSchema.Field FIELD_DownStep = SCHEMA.getField("downStep");
    private static final RecordDataSchema.Field FIELD_MinCallCount = SCHEMA.getField("minCallCount");
    private static final RecordDataSchema.Field FIELD_HighLatency = SCHEMA.getField("highLatency");
    private static final RecordDataSchema.Field FIELD_LowLatency = SCHEMA.getField("lowLatency");
    private static final RecordDataSchema.Field FIELD_HighErrorRate = SCHEMA.getField("highErrorRate");
    private static final RecordDataSchema.Field FIELD_LowErrorRate = SCHEMA.getField("lowErrorRate");
    private static final RecordDataSchema.Field FIELD_HighOutstanding = SCHEMA.getField("highOutstanding");
    private static final RecordDataSchema.Field FIELD_LowOutstanding = SCHEMA.getField("lowOutstanding");
    private static final RecordDataSchema.Field FIELD_MinOutstandingCount = SCHEMA.getField("minOutstandingCount");
    private static final RecordDataSchema.Field FIELD_MaxDropDuration = SCHEMA.getField("maxDropDuration");
    private static final RecordDataSchema.Field FIELD_LatencyToUse = SCHEMA.getField("latencyToUse");
    private static final RecordDataSchema.Field FIELD_InitialDropRate = SCHEMA.getField("initialDropRate");
    private static final RecordDataSchema.Field FIELD_SlowStartThreshold = SCHEMA.getField("slowStartThreshold");

    public D2DegraderProperties() {
        super(new DataMap(), SCHEMA);
    }

    public D2DegraderProperties(DataMap data) {
        super(data, SCHEMA);
    }

    public static Fields fields() {
        return _fields;
    }

    public boolean hasName() {
        return this.contains(FIELD_Name);
    }

    public void removeName() {
        this.remove(FIELD_Name);
    }

    public String getName(GetMode mode) {
        return (String)this.obtainDirect(FIELD_Name, String.class, mode);
    }

    public String getName() {
        return (String)this.obtainDirect(FIELD_Name, String.class, GetMode.STRICT);
    }

    public D2DegraderProperties setName(String value, SetMode mode) {
        this.putDirect(FIELD_Name, String.class, String.class, value, mode);
        return this;
    }

    public D2DegraderProperties setName(String value) {
        this.putDirect(FIELD_Name, String.class, String.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasLogEnabled() {
        return this.contains(FIELD_LogEnabled);
    }

    public void removeLogEnabled() {
        this.remove(FIELD_LogEnabled);
    }

    public Boolean isLogEnabled(GetMode mode) {
        return (Boolean)this.obtainDirect(FIELD_LogEnabled, Boolean.class, mode);
    }

    public Boolean isLogEnabled() {
        return (Boolean)this.obtainDirect(FIELD_LogEnabled, Boolean.class, GetMode.STRICT);
    }

    public D2DegraderProperties setLogEnabled(Boolean value, SetMode mode) {
        this.putDirect(FIELD_LogEnabled, Boolean.class, Boolean.class, value, mode);
        return this;
    }

    public D2DegraderProperties setLogEnabled(Boolean value) {
        this.putDirect(FIELD_LogEnabled, Boolean.class, Boolean.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public D2DegraderProperties setLogEnabled(boolean value) {
        this.putDirect(FIELD_LogEnabled, Boolean.class, Boolean.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasMaxDropRate() {
        return this.contains(FIELD_MaxDropRate);
    }

    public void removeMaxDropRate() {
        this.remove(FIELD_MaxDropRate);
    }

    public Double getMaxDropRate(GetMode mode) {
        return (Double)this.obtainDirect(FIELD_MaxDropRate, Double.class, mode);
    }

    public Double getMaxDropRate() {
        return (Double)this.obtainDirect(FIELD_MaxDropRate, Double.class, GetMode.STRICT);
    }

    public D2DegraderProperties setMaxDropRate(Double value, SetMode mode) {
        this.putDirect(FIELD_MaxDropRate, Double.class, Double.class, value, mode);
        return this;
    }

    public D2DegraderProperties setMaxDropRate(Double value) {
        this.putDirect(FIELD_MaxDropRate, Double.class, Double.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public D2DegraderProperties setMaxDropRate(double value) {
        this.putDirect(FIELD_MaxDropRate, Double.class, Double.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasUpStep() {
        return this.contains(FIELD_UpStep);
    }

    public void removeUpStep() {
        this.remove(FIELD_UpStep);
    }

    public Double getUpStep(GetMode mode) {
        return (Double)this.obtainDirect(FIELD_UpStep, Double.class, mode);
    }

    public Double getUpStep() {
        return (Double)this.obtainDirect(FIELD_UpStep, Double.class, GetMode.STRICT);
    }

    public D2DegraderProperties setUpStep(Double value, SetMode mode) {
        this.putDirect(FIELD_UpStep, Double.class, Double.class, value, mode);
        return this;
    }

    public D2DegraderProperties setUpStep(Double value) {
        this.putDirect(FIELD_UpStep, Double.class, Double.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public D2DegraderProperties setUpStep(double value) {
        this.putDirect(FIELD_UpStep, Double.class, Double.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasDownStep() {
        return this.contains(FIELD_DownStep);
    }

    public void removeDownStep() {
        this.remove(FIELD_DownStep);
    }

    public Double getDownStep(GetMode mode) {
        return (Double)this.obtainDirect(FIELD_DownStep, Double.class, mode);
    }

    public Double getDownStep() {
        return (Double)this.obtainDirect(FIELD_DownStep, Double.class, GetMode.STRICT);
    }

    public D2DegraderProperties setDownStep(Double value, SetMode mode) {
        this.putDirect(FIELD_DownStep, Double.class, Double.class, value, mode);
        return this;
    }

    public D2DegraderProperties setDownStep(Double value) {
        this.putDirect(FIELD_DownStep, Double.class, Double.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public D2DegraderProperties setDownStep(double value) {
        this.putDirect(FIELD_DownStep, Double.class, Double.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasMinCallCount() {
        return this.contains(FIELD_MinCallCount);
    }

    public void removeMinCallCount() {
        this.remove(FIELD_MinCallCount);
    }

    public Integer getMinCallCount(GetMode mode) {
        return (Integer)this.obtainDirect(FIELD_MinCallCount, Integer.class, mode);
    }

    public Integer getMinCallCount() {
        return (Integer)this.obtainDirect(FIELD_MinCallCount, Integer.class, GetMode.STRICT);
    }

    public D2DegraderProperties setMinCallCount(Integer value, SetMode mode) {
        this.putDirect(FIELD_MinCallCount, Integer.class, Integer.class, value, mode);
        return this;
    }

    public D2DegraderProperties setMinCallCount(Integer value) {
        this.putDirect(FIELD_MinCallCount, Integer.class, Integer.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public D2DegraderProperties setMinCallCount(int value) {
        this.putDirect(FIELD_MinCallCount, Integer.class, Integer.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasHighLatency() {
        return this.contains(FIELD_HighLatency);
    }

    public void removeHighLatency() {
        this.remove(FIELD_HighLatency);
    }

    public Integer getHighLatency(GetMode mode) {
        return (Integer)this.obtainDirect(FIELD_HighLatency, Integer.class, mode);
    }

    public Integer getHighLatency() {
        return (Integer)this.obtainDirect(FIELD_HighLatency, Integer.class, GetMode.STRICT);
    }

    public D2DegraderProperties setHighLatency(Integer value, SetMode mode) {
        this.putDirect(FIELD_HighLatency, Integer.class, Integer.class, value, mode);
        return this;
    }

    public D2DegraderProperties setHighLatency(Integer value) {
        this.putDirect(FIELD_HighLatency, Integer.class, Integer.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public D2DegraderProperties setHighLatency(int value) {
        this.putDirect(FIELD_HighLatency, Integer.class, Integer.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasLowLatency() {
        return this.contains(FIELD_LowLatency);
    }

    public void removeLowLatency() {
        this.remove(FIELD_LowLatency);
    }

    public Integer getLowLatency(GetMode mode) {
        return (Integer)this.obtainDirect(FIELD_LowLatency, Integer.class, mode);
    }

    public Integer getLowLatency() {
        return (Integer)this.obtainDirect(FIELD_LowLatency, Integer.class, GetMode.STRICT);
    }

    public D2DegraderProperties setLowLatency(Integer value, SetMode mode) {
        this.putDirect(FIELD_LowLatency, Integer.class, Integer.class, value, mode);
        return this;
    }

    public D2DegraderProperties setLowLatency(Integer value) {
        this.putDirect(FIELD_LowLatency, Integer.class, Integer.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public D2DegraderProperties setLowLatency(int value) {
        this.putDirect(FIELD_LowLatency, Integer.class, Integer.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasHighErrorRate() {
        return this.contains(FIELD_HighErrorRate);
    }

    public void removeHighErrorRate() {
        this.remove(FIELD_HighErrorRate);
    }

    public Double getHighErrorRate(GetMode mode) {
        return (Double)this.obtainDirect(FIELD_HighErrorRate, Double.class, mode);
    }

    public Double getHighErrorRate() {
        return (Double)this.obtainDirect(FIELD_HighErrorRate, Double.class, GetMode.STRICT);
    }

    public D2DegraderProperties setHighErrorRate(Double value, SetMode mode) {
        this.putDirect(FIELD_HighErrorRate, Double.class, Double.class, value, mode);
        return this;
    }

    public D2DegraderProperties setHighErrorRate(Double value) {
        this.putDirect(FIELD_HighErrorRate, Double.class, Double.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public D2DegraderProperties setHighErrorRate(double value) {
        this.putDirect(FIELD_HighErrorRate, Double.class, Double.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasLowErrorRate() {
        return this.contains(FIELD_LowErrorRate);
    }

    public void removeLowErrorRate() {
        this.remove(FIELD_LowErrorRate);
    }

    public Double getLowErrorRate(GetMode mode) {
        return (Double)this.obtainDirect(FIELD_LowErrorRate, Double.class, mode);
    }

    public Double getLowErrorRate() {
        return (Double)this.obtainDirect(FIELD_LowErrorRate, Double.class, GetMode.STRICT);
    }

    public D2DegraderProperties setLowErrorRate(Double value, SetMode mode) {
        this.putDirect(FIELD_LowErrorRate, Double.class, Double.class, value, mode);
        return this;
    }

    public D2DegraderProperties setLowErrorRate(Double value) {
        this.putDirect(FIELD_LowErrorRate, Double.class, Double.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public D2DegraderProperties setLowErrorRate(double value) {
        this.putDirect(FIELD_LowErrorRate, Double.class, Double.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasHighOutstanding() {
        return this.contains(FIELD_HighOutstanding);
    }

    public void removeHighOutstanding() {
        this.remove(FIELD_HighOutstanding);
    }

    public Integer getHighOutstanding(GetMode mode) {
        return (Integer)this.obtainDirect(FIELD_HighOutstanding, Integer.class, mode);
    }

    public Integer getHighOutstanding() {
        return (Integer)this.obtainDirect(FIELD_HighOutstanding, Integer.class, GetMode.STRICT);
    }

    public D2DegraderProperties setHighOutstanding(Integer value, SetMode mode) {
        this.putDirect(FIELD_HighOutstanding, Integer.class, Integer.class, value, mode);
        return this;
    }

    public D2DegraderProperties setHighOutstanding(Integer value) {
        this.putDirect(FIELD_HighOutstanding, Integer.class, Integer.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public D2DegraderProperties setHighOutstanding(int value) {
        this.putDirect(FIELD_HighOutstanding, Integer.class, Integer.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasLowOutstanding() {
        return this.contains(FIELD_LowOutstanding);
    }

    public void removeLowOutstanding() {
        this.remove(FIELD_LowOutstanding);
    }

    public Integer getLowOutstanding(GetMode mode) {
        return (Integer)this.obtainDirect(FIELD_LowOutstanding, Integer.class, mode);
    }

    public Integer getLowOutstanding() {
        return (Integer)this.obtainDirect(FIELD_LowOutstanding, Integer.class, GetMode.STRICT);
    }

    public D2DegraderProperties setLowOutstanding(Integer value, SetMode mode) {
        this.putDirect(FIELD_LowOutstanding, Integer.class, Integer.class, value, mode);
        return this;
    }

    public D2DegraderProperties setLowOutstanding(Integer value) {
        this.putDirect(FIELD_LowOutstanding, Integer.class, Integer.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public D2DegraderProperties setLowOutstanding(int value) {
        this.putDirect(FIELD_LowOutstanding, Integer.class, Integer.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasMinOutstandingCount() {
        return this.contains(FIELD_MinOutstandingCount);
    }

    public void removeMinOutstandingCount() {
        this.remove(FIELD_MinOutstandingCount);
    }

    public Integer getMinOutstandingCount(GetMode mode) {
        return (Integer)this.obtainDirect(FIELD_MinOutstandingCount, Integer.class, mode);
    }

    public Integer getMinOutstandingCount() {
        return (Integer)this.obtainDirect(FIELD_MinOutstandingCount, Integer.class, GetMode.STRICT);
    }

    public D2DegraderProperties setMinOutstandingCount(Integer value, SetMode mode) {
        this.putDirect(FIELD_MinOutstandingCount, Integer.class, Integer.class, value, mode);
        return this;
    }

    public D2DegraderProperties setMinOutstandingCount(Integer value) {
        this.putDirect(FIELD_MinOutstandingCount, Integer.class, Integer.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public D2DegraderProperties setMinOutstandingCount(int value) {
        this.putDirect(FIELD_MinOutstandingCount, Integer.class, Integer.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasMaxDropDuration() {
        return this.contains(FIELD_MaxDropDuration);
    }

    public void removeMaxDropDuration() {
        this.remove(FIELD_MaxDropDuration);
    }

    public Long getMaxDropDuration(GetMode mode) {
        return (Long)this.obtainDirect(FIELD_MaxDropDuration, Long.class, mode);
    }

    public Long getMaxDropDuration() {
        return (Long)this.obtainDirect(FIELD_MaxDropDuration, Long.class, GetMode.STRICT);
    }

    public D2DegraderProperties setMaxDropDuration(Long value, SetMode mode) {
        this.putDirect(FIELD_MaxDropDuration, Long.class, Long.class, value, mode);
        return this;
    }

    public D2DegraderProperties setMaxDropDuration(Long value) {
        this.putDirect(FIELD_MaxDropDuration, Long.class, Long.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public D2DegraderProperties setMaxDropDuration(long value) {
        this.putDirect(FIELD_MaxDropDuration, Long.class, Long.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasLatencyToUse() {
        return this.contains(FIELD_LatencyToUse);
    }

    public void removeLatencyToUse() {
        this.remove(FIELD_LatencyToUse);
    }

    public latencyType getLatencyToUse(GetMode mode) {
        return (latencyType)((Object)this.obtainDirect(FIELD_LatencyToUse, latencyType.class, mode));
    }

    public latencyType getLatencyToUse() {
        return (latencyType)((Object)this.obtainDirect(FIELD_LatencyToUse, latencyType.class, GetMode.STRICT));
    }

    public D2DegraderProperties setLatencyToUse(latencyType value, SetMode mode) {
        this.putDirect(FIELD_LatencyToUse, latencyType.class, String.class, (Object)value, mode);
        return this;
    }

    public D2DegraderProperties setLatencyToUse(latencyType value) {
        this.putDirect(FIELD_LatencyToUse, latencyType.class, String.class, (Object)value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasInitialDropRate() {
        return this.contains(FIELD_InitialDropRate);
    }

    public void removeInitialDropRate() {
        this.remove(FIELD_InitialDropRate);
    }

    public Double getInitialDropRate(GetMode mode) {
        return (Double)this.obtainDirect(FIELD_InitialDropRate, Double.class, mode);
    }

    public Double getInitialDropRate() {
        return (Double)this.obtainDirect(FIELD_InitialDropRate, Double.class, GetMode.STRICT);
    }

    public D2DegraderProperties setInitialDropRate(Double value, SetMode mode) {
        this.putDirect(FIELD_InitialDropRate, Double.class, Double.class, value, mode);
        return this;
    }

    public D2DegraderProperties setInitialDropRate(Double value) {
        this.putDirect(FIELD_InitialDropRate, Double.class, Double.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public D2DegraderProperties setInitialDropRate(double value) {
        this.putDirect(FIELD_InitialDropRate, Double.class, Double.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasSlowStartThreshold() {
        return this.contains(FIELD_SlowStartThreshold);
    }

    public void removeSlowStartThreshold() {
        this.remove(FIELD_SlowStartThreshold);
    }

    public Double getSlowStartThreshold(GetMode mode) {
        return (Double)this.obtainDirect(FIELD_SlowStartThreshold, Double.class, mode);
    }

    public Double getSlowStartThreshold() {
        return (Double)this.obtainDirect(FIELD_SlowStartThreshold, Double.class, GetMode.STRICT);
    }

    public D2DegraderProperties setSlowStartThreshold(Double value, SetMode mode) {
        this.putDirect(FIELD_SlowStartThreshold, Double.class, Double.class, value, mode);
        return this;
    }

    public D2DegraderProperties setSlowStartThreshold(Double value) {
        this.putDirect(FIELD_SlowStartThreshold, Double.class, Double.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public D2DegraderProperties setSlowStartThreshold(double value) {
        this.putDirect(FIELD_SlowStartThreshold, Double.class, Double.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public D2DegraderProperties clone() throws CloneNotSupportedException {
        return (D2DegraderProperties)super.clone();
    }

    public D2DegraderProperties copy() throws CloneNotSupportedException {
        return (D2DegraderProperties)super.copy();
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec name() {
            return new PathSpec(this.getPathComponents(), "name");
        }

        public PathSpec logEnabled() {
            return new PathSpec(this.getPathComponents(), "logEnabled");
        }

        public PathSpec maxDropRate() {
            return new PathSpec(this.getPathComponents(), "maxDropRate");
        }

        public PathSpec upStep() {
            return new PathSpec(this.getPathComponents(), "upStep");
        }

        public PathSpec downStep() {
            return new PathSpec(this.getPathComponents(), "downStep");
        }

        public PathSpec minCallCount() {
            return new PathSpec(this.getPathComponents(), "minCallCount");
        }

        public PathSpec highLatency() {
            return new PathSpec(this.getPathComponents(), "highLatency");
        }

        public PathSpec lowLatency() {
            return new PathSpec(this.getPathComponents(), "lowLatency");
        }

        public PathSpec highErrorRate() {
            return new PathSpec(this.getPathComponents(), "highErrorRate");
        }

        public PathSpec lowErrorRate() {
            return new PathSpec(this.getPathComponents(), "lowErrorRate");
        }

        public PathSpec highOutstanding() {
            return new PathSpec(this.getPathComponents(), "highOutstanding");
        }

        public PathSpec lowOutstanding() {
            return new PathSpec(this.getPathComponents(), "lowOutstanding");
        }

        public PathSpec minOutstandingCount() {
            return new PathSpec(this.getPathComponents(), "minOutstandingCount");
        }

        public PathSpec maxDropDuration() {
            return new PathSpec(this.getPathComponents(), "maxDropDuration");
        }

        public PathSpec latencyToUse() {
            return new PathSpec(this.getPathComponents(), "latencyToUse");
        }

        public PathSpec initialDropRate() {
            return new PathSpec(this.getPathComponents(), "initialDropRate");
        }

        public PathSpec slowStartThreshold() {
            return new PathSpec(this.getPathComponents(), "slowStartThreshold");
        }
    }
}

