/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.copy.converter;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.zip.GZIPInputStream;
import javax.annotation.Nullable;
import org.apache.gobblin.data.management.copy.converter.DistcpConverter;
import org.apache.gobblin.util.io.StreamUtils;

public class UnGzipConverter
extends DistcpConverter {
    private static final String TAR_EXTENSION = ".tar";
    private static final String GZIP_EXTENSION = ".gzip";
    private static final String GZ_EXTENSION = ".gz";
    private static final String TGZ_EXTENSION = ".tgz";

    @Override
    public Function<InputStream, InputStream> inputStreamTransformation() {
        return new Function<InputStream, InputStream>(){

            @Nullable
            public InputStream apply(InputStream input) {
                try {
                    return StreamUtils.convertStream((InputStream)new GZIPInputStream(input));
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            }
        };
    }

    @Override
    public List<String> extensionsToRemove() {
        return Lists.newArrayList((Object[])new String[]{TAR_EXTENSION, GZIP_EXTENSION, GZ_EXTENSION, TGZ_EXTENSION});
    }
}

