/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.copy.replication;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.typesafe.config.Config;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.gobblin.data.management.copy.replication.HadoopFsEndPoint;
import org.apache.gobblin.data.management.copy.replication.HadoopFsReplicaConfig;
import org.apache.gobblin.data.management.copy.replication.ReplicationDataValidPathPicker;
import org.apache.gobblin.source.extractor.ComparableWatermark;
import org.apache.gobblin.source.extractor.extract.LongWatermark;
import org.apache.gobblin.util.FileListUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceHadoopFsEndPoint
extends HadoopFsEndPoint {
    private static final Logger log = LoggerFactory.getLogger(SourceHadoopFsEndPoint.class);
    private final HadoopFsReplicaConfig rc;
    private final Config selectionConfig;
    private boolean initialized = false;
    private Optional<ComparableWatermark> cachedWatermark = Optional.absent();
    private Collection<FileStatus> allFileStatus = new ArrayList<FileStatus>();

    public SourceHadoopFsEndPoint(HadoopFsReplicaConfig rc, Config selectionConfig) {
        this.rc = rc;
        this.selectionConfig = selectionConfig;
    }

    @Override
    public synchronized Collection<FileStatus> getFiles() throws IOException {
        if (!this.initialized) {
            this.getWatermark();
        }
        return this.allFileStatus;
    }

    @Override
    public synchronized Optional<ComparableWatermark> getWatermark() {
        if (this.initialized) {
            return this.cachedWatermark;
        }
        try {
            long curTs = -1L;
            FileSystem fs = FileSystem.get((URI)this.rc.getFsURI(), (Configuration)new Configuration());
            Collection<Path> validPaths = ReplicationDataValidPathPicker.getValidPaths(this);
            for (Path p : validPaths) {
                this.allFileStatus.addAll(FileListUtils.listFilesRecursively((FileSystem)fs, (Path)p, (PathFilter)super.getPathFilter(), (boolean)super.isApplyFilterToDirectories()));
            }
            for (FileStatus f : this.allFileStatus) {
                if (f.getModificationTime() <= curTs) continue;
                curTs = f.getModificationTime();
            }
            LongWatermark result = new LongWatermark(curTs);
            this.cachedWatermark = Optional.of((Object)result);
            if (this.cachedWatermark.isPresent()) {
                this.initialized = true;
            }
            return this.cachedWatermark;
        }
        catch (IOException e) {
            log.error("Error while retrieve the watermark for " + this);
            return this.cachedWatermark;
        }
    }

    @Override
    public boolean isSource() {
        return true;
    }

    @Override
    public String getEndPointName() {
        return "source";
    }

    @Override
    public String getClusterName() {
        return this.rc.getClustername();
    }

    public String toString() {
        return Objects.toStringHelper(this.getClass()).add("is source", this.isSource()).add("end point name", (Object)this.getEndPointName()).add("hadoopfs config", (Object)this.rc).toString();
    }

    @Override
    public URI getFsURI() {
        return this.rc.getFsURI();
    }

    @Override
    public Path getDatasetPath() {
        return this.rc.getPath();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.rc == null ? 0 : this.rc.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SourceHadoopFsEndPoint other = (SourceHadoopFsEndPoint)obj;
        return !(this.rc == null ? other.rc != null : !this.rc.equals(other.rc));
    }

    public HadoopFsReplicaConfig getRc() {
        return this.rc;
    }

    @Override
    public Config getSelectionConfig() {
        return this.selectionConfig;
    }
}

