/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.copy.watermark;

import com.google.common.base.Optional;
import java.io.IOException;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.data.management.copy.CopyableFile;
import org.apache.gobblin.data.management.copy.watermark.CopyableFileWatermarkGenerator;
import org.apache.gobblin.source.extractor.WatermarkInterval;

public class CopyableFileWatermarkHelper {
    public static final String WATERMARK_CREATOR = "gobblin.copy.watermarkCreator";

    public static Optional<CopyableFileWatermarkGenerator> getCopyableFileWatermarkGenerator(State state) throws IOException {
        try {
            if (state.contains(WATERMARK_CREATOR)) {
                Class<?> watermarkCreatorClass = Class.forName(state.getProp(WATERMARK_CREATOR));
                return Optional.of((Object)((CopyableFileWatermarkGenerator)watermarkCreatorClass.newInstance()));
            }
            return Optional.absent();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new IOException("Failed to instantiate watermarkCreator.");
        }
    }

    public static Optional<WatermarkInterval> getCopyableFileWatermark(CopyableFile copyableFile, Optional<CopyableFileWatermarkGenerator> watermarkGenerator) throws IOException {
        if (!watermarkGenerator.isPresent()) {
            return Optional.absent();
        }
        return ((CopyableFileWatermarkGenerator)watermarkGenerator.get()).generateWatermarkIntervalForCopyableFile(copyableFile);
    }
}

