/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.version.finder;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.gobblin.data.management.version.FileSystemDatasetVersion;
import org.apache.gobblin.data.management.version.TimestampedDatasetStateStoreVersion;
import org.apache.gobblin.data.management.version.finder.VersionFinder;
import org.apache.gobblin.dataset.Dataset;
import org.apache.gobblin.metastore.DatasetStoreDataset;
import org.apache.gobblin.metastore.metadata.DatasetStateStoreEntryManager;

public class TimestampedDatasetStateStoreVersionFinder
implements VersionFinder<TimestampedDatasetStateStoreVersion> {
    @Override
    public Class<? extends FileSystemDatasetVersion> versionClass() {
        return TimestampedDatasetStateStoreVersion.class;
    }

    @Override
    public Collection<TimestampedDatasetStateStoreVersion> findDatasetVersions(Dataset dataset) throws IOException {
        DatasetStoreDataset storeDataset = (DatasetStoreDataset)dataset;
        ArrayList versions = Lists.newArrayList();
        for (DatasetStateStoreEntryManager entry : storeDataset.getDatasetStateStoreMetadataEntries()) {
            versions.add(new TimestampedDatasetStateStoreVersion(entry));
        }
        return versions;
    }
}

