/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.yarn;

import com.google.common.base.Optional;
import com.google.common.util.concurrent.Service;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.util.Collections;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.gobblin.annotation.Alpha;
import org.apache.gobblin.cluster.GobblinClusterManager;
import org.apache.gobblin.util.JvmUtils;
import org.apache.gobblin.util.logs.Log4jConfigurationHelper;
import org.apache.gobblin.yarn.GobblinYarnLogSource;
import org.apache.gobblin.yarn.HelixMessageSubTypes;
import org.apache.gobblin.yarn.YarnContainerSecurityManager;
import org.apache.gobblin.yarn.YarnService;
import org.apache.gobblin.yarn.event.DelegationTokenUpdatedEvent;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.helix.NotificationContext;
import org.apache.helix.messaging.handling.HelixTaskResult;
import org.apache.helix.messaging.handling.MessageHandler;
import org.apache.helix.messaging.handling.MessageHandlerFactory;
import org.apache.helix.model.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alpha
public class GobblinApplicationMaster
extends GobblinClusterManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(GobblinApplicationMaster.class);

    public GobblinApplicationMaster(String applicationName, ContainerId containerId, Config config, YarnConfiguration yarnConfiguration) throws Exception {
        super(applicationName, containerId.getApplicationAttemptId().getApplicationId().toString(), config, Optional.absent());
        GobblinYarnLogSource gobblinYarnLogSource = new GobblinYarnLogSource();
        if (gobblinYarnLogSource.isLogSourcePresent()) {
            this.applicationLauncher.addService((Service)gobblinYarnLogSource.buildLogCopier(config, containerId, this.fs, this.appWorkDir));
        }
        this.applicationLauncher.addService((Service)this.buildYarnService(config, applicationName, this.applicationId, yarnConfiguration, this.fs));
        if (UserGroupInformation.isSecurityEnabled()) {
            LOGGER.info("Adding YarnContainerSecurityManager since security is enabled");
            this.applicationLauncher.addService((Service)this.buildYarnContainerSecurityManager(config, this.fs));
        }
    }

    private YarnService buildYarnService(Config config, String applicationName, String applicationId, YarnConfiguration yarnConfiguration, FileSystem fs) throws Exception {
        return new YarnService(config, applicationName, applicationId, yarnConfiguration, fs, this.eventBus);
    }

    private YarnContainerSecurityManager buildYarnContainerSecurityManager(Config config, FileSystem fs) {
        return new YarnContainerSecurityManager(config, fs, this.eventBus);
    }

    protected MessageHandlerFactory getUserDefinedMessageHandlerFactory() {
        return new ControllerUserDefinedMessageHandlerFactory();
    }

    private static Options buildOptions() {
        Options options = new Options();
        options.addOption("a", "app_name", true, "Yarn application name");
        return options;
    }

    private static void printUsage(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(GobblinApplicationMaster.class.getSimpleName(), options);
    }

    public static void main(String[] args) throws Exception {
        Options options = GobblinApplicationMaster.buildOptions();
        try {
            CommandLine cmd = new DefaultParser().parse(options, args);
            if (!cmd.hasOption("app_name")) {
                GobblinApplicationMaster.printUsage(options);
                System.exit(1);
            }
            Log4jConfigurationHelper.updateLog4jConfiguration(GobblinApplicationMaster.class, (String)"log4j-yarn.properties", (String)"log4j-yarn.properties");
            LOGGER.info(JvmUtils.getJvmInputArguments());
            ContainerId containerId = ConverterUtils.toContainerId((String)System.getenv().get(ApplicationConstants.Environment.CONTAINER_ID.key()));
            try (GobblinApplicationMaster applicationMaster = new GobblinApplicationMaster(cmd.getOptionValue("app_name"), containerId, ConfigFactory.load(), new YarnConfiguration());){
                applicationMaster.start();
            }
        }
        catch (ParseException pe) {
            GobblinApplicationMaster.printUsage(options);
            System.exit(1);
        }
    }

    private class ControllerUserDefinedMessageHandlerFactory
    implements MessageHandlerFactory {
        private ControllerUserDefinedMessageHandlerFactory() {
        }

        public MessageHandler createHandler(Message message, NotificationContext context) {
            return new ControllerUserDefinedMessageHandler(message, context);
        }

        public String getMessageType() {
            return Message.MessageType.USER_DEFINE_MSG.toString();
        }

        public List<String> getMessageTypes() {
            return Collections.singletonList(this.getMessageType());
        }

        public void reset() {
        }

        private class ControllerUserDefinedMessageHandler
        extends MessageHandler {
            public ControllerUserDefinedMessageHandler(Message message, NotificationContext context) {
                super(message, context);
            }

            public HelixTaskResult handleMessage() throws InterruptedException {
                String messageSubType = this._message.getMsgSubType();
                if (messageSubType.equalsIgnoreCase(HelixMessageSubTypes.TOKEN_FILE_UPDATED.toString())) {
                    LOGGER.info("Handling message " + HelixMessageSubTypes.TOKEN_FILE_UPDATED.toString());
                    GobblinApplicationMaster.this.eventBus.post((Object)new DelegationTokenUpdatedEvent());
                    HelixTaskResult helixTaskResult = new HelixTaskResult();
                    helixTaskResult.setSuccess(true);
                    return helixTaskResult;
                }
                throw new IllegalArgumentException(String.format("Unknown %s message subtype: %s", Message.MessageType.USER_DEFINE_MSG.toString(), messageSubType));
            }

            public void onError(Exception e, MessageHandler.ErrorCode code, MessageHandler.ErrorType type) {
                LOGGER.error(String.format("Failed to handle message with exception %s, error code %s, error type %s", e, code, type));
            }
        }
    }
}

