/*
 * Decompiled with CFR 0.152.
 */
package azkaban.utils;

import azkaban.utils.CircularBuffer;
import azkaban.utils.Pair;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.io.IOUtils;

public class FileIOUtils {
    public static String getSourcePathFromClass(Class<?> containedClass) {
        File file = new File(containedClass.getProtectionDomain().getCodeSource().getLocation().getPath());
        if (!file.isDirectory() && file.getName().endsWith(".class")) {
            String name = containedClass.getName();
            StringTokenizer tokenizer = new StringTokenizer(name, ".");
            while (tokenizer.hasMoreTokens()) {
                tokenizer.nextElement();
                file = file.getParentFile();
            }
            return file.getPath();
        }
        return containedClass.getProtectionDomain().getCodeSource().getLocation().getPath();
    }

    public static void createDeepSymlink(File sourceDir, File destDir) throws IOException {
        if (!sourceDir.exists()) {
            throw new IOException("Source directory " + sourceDir.getPath() + " doesn't exist");
        }
        if (!destDir.exists()) {
            throw new IOException("Destination directory " + destDir.getPath() + " doesn't exist");
        }
        if (sourceDir.isFile() && destDir.isFile()) {
            throw new IOException("Source or Destination is not a directory.");
        }
        HashSet<String> paths = new HashSet<String>();
        FileIOUtils.createDirsFindFiles(sourceDir, sourceDir, destDir, paths);
        StringBuffer buffer = new StringBuffer();
        for (String path : paths) {
            File sourceLink = new File(sourceDir, path);
            path = "." + path;
            buffer.append("ln -s ").append(sourceLink.getAbsolutePath()).append("/*").append(" ").append(path).append(";");
        }
        String command = buffer.toString();
        ProcessBuilder builder = new ProcessBuilder(new String[0]).command("sh", "-c", command);
        builder.directory(destDir);
        Process process = builder.start();
        NullLogger errorLogger = new NullLogger(process.getErrorStream());
        NullLogger inputLogger = new NullLogger(process.getInputStream());
        errorLogger.start();
        inputLogger.start();
        try {
            if (process.waitFor() < 0) {
                String errorMessage = errorLogger.getLastMessages();
                if (errorMessage.isEmpty()) {
                    errorMessage = inputLogger.getLastMessages();
                }
                throw new IOException(errorMessage);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private static void createDirsFindFiles(File baseDir, File sourceDir, File destDir, Set<String> paths) {
        File[] srcList = sourceDir.listFiles();
        String path = FileIOUtils.getRelativePath(baseDir, sourceDir);
        paths.add(path);
        for (File file : srcList) {
            if (!file.isDirectory()) continue;
            File newDestDir = new File(destDir, file.getName());
            newDestDir.mkdirs();
            FileIOUtils.createDirsFindFiles(baseDir, file, newDestDir, paths);
        }
    }

    private static String getRelativePath(File basePath, File sourceDir) {
        return sourceDir.getPath().substring(basePath.getPath().length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Pair<Integer, Integer> readUtf8File(File file, int offset, int length, OutputStream stream) throws IOException {
        byte[] buffer = new byte[length];
        FileInputStream fileStream = new FileInputStream(file);
        long skipped = fileStream.skip(offset);
        if (skipped < (long)offset) {
            fileStream.close();
            return new Pair<Integer, Integer>(0, 0);
        }
        BufferedInputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(fileStream);
            inputStream.read(buffer);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(inputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        Pair<Integer, Integer> utf8Range = FileIOUtils.getUtf8Range(buffer, 0, length);
        stream.write(buffer, utf8Range.getFirst(), utf8Range.getSecond());
        return new Pair<Integer, Integer>(offset + utf8Range.getFirst(), utf8Range.getSecond());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LogData readUtf8File(File file, int fileOffset, int length) throws IOException {
        byte[] buffer = new byte[length];
        FileInputStream fileStream = new FileInputStream(file);
        long skipped = fileStream.skip(fileOffset);
        if (skipped < (long)fileOffset) {
            fileStream.close();
            return new LogData(fileOffset, 0, "");
        }
        BufferedInputStream inputStream = null;
        int read = 0;
        try {
            inputStream = new BufferedInputStream(fileStream);
            read = inputStream.read(buffer);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(inputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        if (read <= 0) {
            return new LogData(fileOffset, 0, "");
        }
        Pair<Integer, Integer> utf8Range = FileIOUtils.getUtf8Range(buffer, 0, read);
        String outputString = new String(buffer, (int)utf8Range.getFirst(), (int)utf8Range.getSecond());
        return new LogData(fileOffset + utf8Range.getFirst(), utf8Range.getSecond(), outputString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JobMetaData readUtf8MetaDataFile(File file, int fileOffset, int length) throws IOException {
        byte[] buffer = new byte[length];
        FileInputStream fileStream = new FileInputStream(file);
        long skipped = fileStream.skip(fileOffset);
        if (skipped < (long)fileOffset) {
            fileStream.close();
            return new JobMetaData(fileOffset, 0, "");
        }
        BufferedInputStream inputStream = null;
        int read = 0;
        try {
            inputStream = new BufferedInputStream(fileStream);
            read = inputStream.read(buffer);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(inputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        if (read <= 0) {
            return new JobMetaData(fileOffset, 0, "");
        }
        Pair<Integer, Integer> utf8Range = FileIOUtils.getUtf8Range(buffer, 0, read);
        String outputString = new String(buffer, (int)utf8Range.getFirst(), (int)utf8Range.getSecond());
        return new JobMetaData(fileOffset + utf8Range.getFirst(), utf8Range.getSecond(), outputString);
    }

    public static Pair<Integer, Integer> getUtf8Range(byte[] buffer, int offset, int length) {
        int start = FileIOUtils.getUtf8ByteStart(buffer, offset);
        int end = FileIOUtils.getUtf8ByteEnd(buffer, offset + length - 1);
        return new Pair<Integer, Integer>(start, end - start + 1);
    }

    private static int getUtf8ByteStart(byte[] buffer, int offset) {
        for (int i = offset; i < offset + 6 && i < buffer.length; ++i) {
            byte b = buffer[i];
            if ((0x80 & b) == 0) {
                return i;
            }
            if ((0xC0 & b) != 192) continue;
            return i;
        }
        return offset;
    }

    private static int getUtf8ByteEnd(byte[] buffer, int offset) {
        for (int i = offset; i > offset - 11 && i >= 0; --i) {
            byte b = buffer[i];
            if ((0x80 & b) == 0) {
                return i;
            }
            if ((b & 0xE0) == 192) {
                if (offset - i < 1) continue;
                return i + 1;
            }
            if ((b & 0xF0) == 224) {
                if (offset - i < 2) continue;
                return i + 2;
            }
            if ((b & 0xF8) == 240) {
                if (offset - i < 3) continue;
                return i + 3;
            }
            if ((b & 0xFC) >= 248) {
                if (offset - i != 4) continue;
                return i + 4;
            }
            if ((b & 0xFE) != 252 || offset - i < 5) continue;
            return i + 5;
        }
        return offset;
    }

    public static class JobMetaData {
        private int offset;
        private int length;
        private String data;

        public JobMetaData(int offset, int length, String data) {
            this.offset = offset;
            this.length = length;
            this.data = data;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getLength() {
            return this.length;
        }

        public String getData() {
            return this.data;
        }

        public Map<String, Object> toObject() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("offset", this.offset);
            map.put("length", this.length);
            map.put("data", this.data);
            return map;
        }

        public static JobMetaData createJobMetaDataFromObject(Map<String, Object> map) {
            int offset = (Integer)map.get("offset");
            int length = (Integer)map.get("length");
            String data = (String)map.get("data");
            return new JobMetaData(offset, length, data);
        }

        public String toString() {
            return "[offset=" + this.offset + ",length=" + this.length + ",data=" + this.data + "]";
        }
    }

    public static class LogData {
        private int offset;
        private int length;
        private String data;

        public LogData(int offset, int length, String data) {
            this.offset = offset;
            this.length = length;
            this.data = data;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getLength() {
            return this.length;
        }

        public String getData() {
            return this.data;
        }

        public Map<String, Object> toObject() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("offset", this.offset);
            map.put("length", this.length);
            map.put("data", this.data);
            return map;
        }

        public static LogData createLogDataFromObject(Map<String, Object> map) {
            int offset = (Integer)map.get("offset");
            int length = (Integer)map.get("length");
            String data = (String)map.get("data");
            return new LogData(offset, length, data);
        }

        public String toString() {
            return "[offset=" + this.offset + ",length=" + this.length + ",data=" + this.data + "]";
        }
    }

    private static class NullLogger
    extends Thread {
        private final BufferedReader inputReader;
        private CircularBuffer<String> buffer = new CircularBuffer(5);

        public NullLogger(InputStream stream) {
            this.inputReader = new BufferedReader(new InputStreamReader(stream));
        }

        @Override
        public void run() {
            try {
                while (!Thread.currentThread().isInterrupted()) {
                    String line = this.inputReader.readLine();
                    if (line == null) {
                        return;
                    }
                    this.buffer.append(line);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public String getLastMessages() {
            StringBuffer messageBuffer = new StringBuffer();
            for (String message : this.buffer) {
                messageBuffer.append(message);
                messageBuffer.append("\n");
            }
            return messageBuffer.toString();
        }
    }

    public static class PrefixSuffixFileFilter
    implements FileFilter {
        private String prefix;
        private String suffix;

        public PrefixSuffixFileFilter(String prefix, String suffix) {
            this.prefix = prefix;
            this.suffix = suffix;
        }

        @Override
        public boolean accept(File pathname) {
            if (!pathname.isFile() || pathname.isHidden()) {
                return false;
            }
            String name = pathname.getName();
            int length = name.length();
            if (this.suffix.length() > length || this.prefix.length() > length) {
                return false;
            }
            return name.startsWith(this.prefix) && name.endsWith(this.suffix);
        }
    }
}

