/*
 * Decompiled with CFR 0.152.
 */
package azkaban.webapp.servlet;

import azkaban.trigger.Trigger;
import azkaban.trigger.TriggerManager;
import azkaban.trigger.TriggerManagerException;
import azkaban.user.User;
import azkaban.webapp.AzkabanWebServer;
import azkaban.webapp.servlet.LoginAbstractAzkabanServlet;
import azkaban.webapp.servlet.Page;
import azkaban.webapp.session.Session;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class TriggerManagerServlet
extends LoginAbstractAzkabanServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(TriggerManagerServlet.class);
    private TriggerManager triggerManager;

    @Override
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        AzkabanWebServer server = (AzkabanWebServer)this.getApplication();
        this.triggerManager = server.getTriggerManager();
    }

    @Override
    protected void handleGet(HttpServletRequest req, HttpServletResponse resp, Session session) throws ServletException, IOException {
        if (this.hasParam(req, "ajax")) {
            this.handleAJAXAction(req, resp, session);
        } else {
            this.handleGetAllSchedules(req, resp, session);
        }
    }

    private void handleAJAXAction(HttpServletRequest req, HttpServletResponse resp, Session session) throws ServletException, IOException {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        String ajaxName = this.getParam(req, "ajax");
        try {
            if (ajaxName.equals("expireTrigger")) {
                this.ajaxExpireTrigger(req, ret, session.getUser());
            }
        }
        catch (Exception e) {
            ret.put("error", e.getMessage());
        }
        if (ret != null) {
            this.writeJSON(resp, ret);
        }
    }

    private void handleGetAllSchedules(HttpServletRequest req, HttpServletResponse resp, Session session) throws ServletException, IOException {
        Page page = this.newPage(req, resp, session, "azkaban/webapp/servlet/velocity/triggerspage.vm");
        List<Trigger> triggers = this.triggerManager.getTriggers();
        page.add("triggers", triggers);
        page.render();
    }

    @Override
    protected void handlePost(HttpServletRequest req, HttpServletResponse resp, Session session) throws ServletException, IOException {
        if (this.hasParam(req, "ajax")) {
            this.handleAJAXAction(req, resp, session);
        }
    }

    private void ajaxExpireTrigger(HttpServletRequest req, Map<String, Object> ret, User user) throws ServletException, TriggerManagerException {
        int triggerId = this.getIntParam(req, "triggerId");
        Trigger t = this.triggerManager.getTrigger(triggerId);
        if (t == null) {
            ret.put("message", "Trigger with ID " + triggerId + " does not exist");
            ret.put("status", "error");
            return;
        }
        this.triggerManager.expireTrigger(triggerId);
        logger.info((Object)("User '" + user.getUserId() + " has removed trigger " + t.getDescription()));
        ret.put("status", "success");
        ret.put("message", "trigger " + triggerId + " removed from Schedules.");
    }
}

