/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.parseq;

import com.linkedin.parseq.BaseTask;
import com.linkedin.parseq.Context;
import com.linkedin.parseq.MultiException;
import com.linkedin.parseq.ParTask;
import com.linkedin.parseq.Task;
import com.linkedin.parseq.internal.InternalUtil;
import com.linkedin.parseq.promise.Promise;
import com.linkedin.parseq.promise.PromiseListener;
import com.linkedin.parseq.promise.Promises;
import com.linkedin.parseq.promise.SettablePromise;
import com.linkedin.parseq.trace.ResultType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

class ParTaskImpl<T>
extends BaseTask<List<T>>
implements ParTask<T> {
    private final List<Task<T>> _tasks;

    public ParTaskImpl(String name, Iterable<? extends Task<? extends T>> tasks) {
        super(name);
        ArrayList<Task<? extends T>> taskList = new ArrayList<Task<? extends T>>();
        Iterator<Task<T>> iterator = tasks.iterator();
        while (iterator.hasNext()) {
            Task<? extends T> task;
            Task<? extends T> coercedTask = task = iterator.next();
            taskList.add(coercedTask);
        }
        if (taskList.isEmpty()) {
            throw new IllegalArgumentException("No tasks to parallelize!");
        }
        this._tasks = Collections.unmodifiableList(taskList);
    }

    @Override
    protected Promise<List<T>> run(Context context) throws Exception {
        final SettablePromise<List<T>> result = Promises.settable();
        PromiseListener<Object> listener = new PromiseListener<Object>(){

            @Override
            public void onResolved(Promise<Object> resolvedPromise) {
                boolean allEarlyFinish = true;
                ArrayList taskResult = new ArrayList();
                ArrayList<Throwable> errors = new ArrayList<Throwable>();
                for (Task task : ParTaskImpl.this._tasks) {
                    if (task.isFailed()) {
                        if (allEarlyFinish && ResultType.fromTask(task) != ResultType.EARLY_FINISH) {
                            allEarlyFinish = false;
                        }
                        errors.add(task.getError());
                        continue;
                    }
                    taskResult.add(task.get());
                }
                if (!errors.isEmpty()) {
                    result.fail(allEarlyFinish ? (Throwable)errors.get(0) : new MultiException("Multiple errors in 'ParTask' task.", errors));
                } else {
                    result.done(taskResult);
                }
            }
        };
        InternalUtil.after(listener, this._tasks.toArray(new Task[this._tasks.size()]));
        for (Task<T> task : this._tasks) {
            context.run(task);
        }
        return result;
    }

    @Override
    public List<Task<T>> getTasks() {
        return this._tasks;
    }

    @Override
    public List<T> getSuccessful() {
        if (!this.isFailed()) {
            return (List)this.get();
        }
        ArrayList taskResult = new ArrayList();
        for (Task<T> task : this._tasks) {
            if (task.isFailed()) continue;
            taskResult.add(task.get());
        }
        return taskResult;
    }
}

