/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.parseq.internal;

import java.util.concurrent.atomic.AtomicLong;

public class IdGenerator {
    private static final long CHUNK_SIZE = 1000L;
    private static final AtomicLong _nextFreeId = new AtomicLong();
    private static final ThreadLocal<Chunk> CHUNK = new ThreadLocal<Chunk>(){

        @Override
        protected Chunk initialValue() {
            return IdGenerator.claim();
        }
    };

    private static Chunk claim() {
        long newMax = _nextFreeId.addAndGet(1000L);
        return new Chunk(newMax - 1000L, newMax);
    }

    public static long getNextId() {
        Chunk chunk = CHUNK.get();
        if (chunk.isEmpty()) {
            chunk = IdGenerator.claim();
            CHUNK.set(chunk);
        }
        return chunk.next();
    }

    private static class Chunk {
        private long _current;
        private final long _max;

        public Chunk(long current, long max) {
            this._current = current;
            this._max = max;
        }

        public boolean isEmpty() {
            return this._current == this._max;
        }

        public long next() {
            return this._current++;
        }
    }
}

