/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.transport.http.client;

import com.linkedin.common.callback.Callback;
import com.linkedin.common.util.None;
import com.linkedin.r2.message.Request;
import com.linkedin.r2.message.RequestContext;
import com.linkedin.r2.message.stream.StreamResponse;
import com.linkedin.r2.transport.common.bridge.common.RequestWithCallback;
import com.linkedin.r2.transport.common.bridge.common.TransportCallback;
import com.linkedin.r2.transport.common.bridge.common.TransportResponseImpl;
import com.linkedin.r2.transport.http.client.AbstractJmxManager;
import com.linkedin.r2.transport.http.client.AbstractNettyStreamClient;
import com.linkedin.r2.transport.http.client.AsyncPool;
import com.linkedin.r2.transport.http.client.AsyncPoolHandle;
import com.linkedin.r2.transport.http.client.AsyncSharedPoolImpl;
import com.linkedin.r2.transport.http.client.ChannelPoolFactory;
import com.linkedin.r2.transport.http.client.ChannelPoolLifecycle;
import com.linkedin.r2.transport.http.client.ChannelPoolManager;
import com.linkedin.r2.transport.http.client.Http2ClientPipelineInitializer;
import com.linkedin.r2.transport.http.client.NoopRateLimiter;
import com.linkedin.r2.transport.http.client.PoolStats;
import com.linkedin.r2.transport.http.client.PoolStatsProvider;
import com.linkedin.r2.transport.http.client.RateLimiter;
import com.linkedin.r2.transport.http.client.TimeoutAsyncPoolHandle;
import com.linkedin.r2.transport.http.client.TimeoutCallback;
import com.linkedin.r2.transport.http.client.TimeoutTransportCallback;
import com.linkedin.r2.transport.http.common.HttpProtocolVersion;
import com.linkedin.r2.util.Cancellable;
import com.linkedin.r2.util.TimeoutRunnable;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroupFuture;
import io.netty.channel.group.ChannelGroupFutureListener;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Http2NettyStreamClient
extends AbstractNettyStreamClient {
    static final Logger LOG = LoggerFactory.getLogger(Http2NettyStreamClient.class);
    private final ChannelPoolManager _channelPoolManager;
    private final ScheduledExecutorService _scheduler;
    private final long _requestTimeout;

    public Http2NettyStreamClient(NioEventLoopGroup eventLoopGroup, ScheduledExecutorService scheduler, long requestTimeout, long idleTimeout, long shutdownTimeout, long maxResponseSize, SSLContext sslContext, SSLParameters sslParameters, ExecutorService callbackExecutors, int poolWaiterSize, String name, AbstractJmxManager jmxManager, int maxHeaderSize, int maxChunkSize, int maxConcurrentConnections, boolean tcpNoDelay) {
        super(eventLoopGroup, scheduler, requestTimeout, shutdownTimeout, maxResponseSize, callbackExecutors, jmxManager, maxConcurrentConnections);
        Http2ClientPipelineInitializer initializer = new Http2ClientPipelineInitializer(sslContext, sslParameters, scheduler, maxHeaderSize, maxChunkSize, maxResponseSize, requestTimeout);
        Bootstrap bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)eventLoopGroup)).channel(NioSocketChannel.class)).handler((ChannelHandler)initializer);
        this._channelPoolManager = new ChannelPoolManager(new ChannelPoolFactoryImpl(bootstrap, idleTimeout, poolWaiterSize, tcpNoDelay), name + "ChannelPools");
        this._scheduler = scheduler;
        this._requestTimeout = requestTimeout;
        this._jmxManager.onProviderCreate((PoolStatsProvider)this._channelPoolManager);
    }

    @Override
    public Map<String, PoolStats> getPoolStats() {
        return this._channelPoolManager.getPoolStats();
    }

    @Override
    protected void doShutdown(Callback<None> callback) {
        long deadline = System.currentTimeMillis() + this._shutdownTimeout;
        ChannelPoolShutdownCallback closeChannelsCallback = new ChannelPoolShutdownCallback(this._scheduler, this._shutdownTimeout, TimeUnit.MILLISECONDS, deadline, callback);
        this._channelPoolManager.shutdown((Callback<None>)closeChannelsCallback);
        this._jmxManager.onProviderShutdown((PoolStatsProvider)this._channelPoolManager);
    }

    @Override
    protected void doWriteRequest(Request request, RequestContext context, SocketAddress address, TimeoutTransportCallback<StreamResponse> callback) {
        AsyncPool<Channel> pool;
        try {
            pool = this._channelPoolManager.getPoolForAddress(address);
        }
        catch (IllegalStateException e) {
            Http2NettyStreamClient.errorResponse(callback, e);
            return;
        }
        context.putLocalAttr("HTTP_PROTOCOL_VERSION", (Object)HttpProtocolVersion.HTTP_2);
        ChannelPoolGetCallback getCallback = new ChannelPoolGetCallback(pool, request, callback);
        Cancellable pendingGet = pool.get((Callback)getCallback);
        if (pendingGet != null) {
            callback.addTimeoutTask(() -> pendingGet.cancel());
        }
    }

    private class ChannelPoolShutdownCallback
    extends TimeoutCallback<None> {
        public ChannelPoolShutdownCallback(final ScheduledExecutorService scheduler, long timeout, TimeUnit timeoutUnit, final long deadline, final Callback<None> callback) {
            super(scheduler, timeout, timeoutUnit, (Callback)new Callback<None>(){

                public void onSuccess(None result) {
                    LOG.info("All connection pools shut down, closing all channels");
                    this.finishShutdown();
                }

                public void onError(Throwable e) {
                    LOG.warn("Error shutting down HTTP connection pools, ignoring and continuing shutdown", e);
                    this.finishShutdown();
                }

                private void finishShutdown() {
                    Http2NettyStreamClient.this._state.set(AbstractNettyStreamClient.State.REQUESTS_STOPPING);
                    for (Callback<Channel> callback2 : Http2NettyStreamClient.this._channelPoolManager.cancelWaiters()) {
                        callback2.onError((Throwable)new TimeoutException("Operation did not complete before shutdown"));
                    }
                    Http2NettyStreamClient.this._allChannels.forEach(channel -> {
                        Http2Connection connection = (Http2Connection)channel.attr(Http2ClientPipelineInitializer.HTTP2_CONNECTION_ATTR_KEY).get();
                        if (connection != null) {
                            Http2Connection.PropertyKey callbackKey = (Http2Connection.PropertyKey)channel.attr(Http2ClientPipelineInitializer.CALLBACK_ATTR_KEY).get();
                            Http2Connection.PropertyKey handleKey = (Http2Connection.PropertyKey)channel.attr(Http2ClientPipelineInitializer.CHANNEL_POOL_HANDLE_ATTR_KEY).get();
                            try {
                                connection.forEachActiveStream(stream -> {
                                    AsyncPoolHandle handle;
                                    TransportCallback callback2 = (TransportCallback)stream.getProperty(callbackKey);
                                    if (callback2 != null) {
                                        AbstractNettyStreamClient.errorResponse(callback2, new TimeoutException("Operation did not complete before shutdown"));
                                    }
                                    if ((handle = (AsyncPoolHandle)stream.getProperty(handleKey)) != null) {
                                        handle.release();
                                    }
                                    return true;
                                });
                            }
                            catch (Http2Exception e) {
                                LOG.warn("Unexpected HTTP/2 error when invoking callbacks before shutdown", (Throwable)e);
                            }
                        }
                    });
                    final TimeoutRunnable afterClose = new TimeoutRunnable(scheduler, deadline - System.currentTimeMillis(), TimeUnit.MILLISECONDS, () -> {
                        Http2NettyStreamClient.this._state.set(AbstractNettyStreamClient.State.SHUTDOWN);
                        LOG.info("Shutdown complete");
                        callback.onSuccess((Object)None.none());
                    }, "Timed out waiting for channels to close, continuing shutdown");
                    Http2NettyStreamClient.this._allChannels.close().addListener((GenericFutureListener)new ChannelGroupFutureListener(){

                        public void operationComplete(ChannelGroupFuture channelGroupFuture) throws Exception {
                            if (!channelGroupFuture.isSuccess()) {
                                LOG.warn("Failed to close some connections, ignoring");
                            }
                            afterClose.run();
                        }
                    });
                }
            }, "Connection pool shutdown timeout exceeded (" + Http2NettyStreamClient.this._shutdownTimeout + "ms)");
        }
    }

    private class ChannelPoolGetCallback
    implements Callback<Channel> {
        private final AsyncPool<Channel> _pool;
        private final Request _request;
        private final TimeoutTransportCallback<StreamResponse> _callback;

        ChannelPoolGetCallback(AsyncPool<Channel> pool, Request request, TimeoutTransportCallback<StreamResponse> callback) {
            this._pool = pool;
            this._request = request;
            this._callback = callback;
        }

        public void onSuccess(Channel channel) {
            AbstractNettyStreamClient.State state = (AbstractNettyStreamClient.State)((Object)Http2NettyStreamClient.this._state.get());
            if (state == AbstractNettyStreamClient.State.REQUESTS_STOPPING || state == AbstractNettyStreamClient.State.SHUTDOWN) {
                this._callback.onResponse(TransportResponseImpl.error((Throwable)new TimeoutException("Operation did not complete before shutdown")));
                return;
            }
            TimeoutAsyncPoolHandle handle = new TimeoutAsyncPoolHandle(this._pool, Http2NettyStreamClient.this._scheduler, Http2NettyStreamClient.this._requestTimeout, TimeUnit.MILLISECONDS, (Object)channel);
            RequestWithCallback request = new RequestWithCallback(this._request, this._callback, (AsyncPoolHandle)handle);
            channel.writeAndFlush((Object)request).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
        }

        public void onError(Throwable e) {
            this._callback.onResponse(TransportResponseImpl.error((Throwable)e));
        }
    }

    private class ChannelPoolFactoryImpl
    implements ChannelPoolFactory {
        private final Bootstrap _bootstrap;
        private final long _idleTimeout;
        private final int _maxPoolWaiterSize;
        private final boolean _tcpNoDelay;

        private ChannelPoolFactoryImpl(Bootstrap bootstrap, long idleTimeout, int maxPoolWaiterSize, boolean tcpNoDelay) {
            this._bootstrap = bootstrap;
            this._idleTimeout = idleTimeout;
            this._maxPoolWaiterSize = maxPoolWaiterSize;
            this._tcpNoDelay = tcpNoDelay;
        }

        @Override
        public AsyncPool<Channel> getPool(SocketAddress address) {
            return new AsyncSharedPoolImpl(address.toString() + " HTTP connection pool", (AsyncPool.Lifecycle)new ChannelPoolLifecycle(address, this._bootstrap, Http2NettyStreamClient.this._allChannels, this._tcpNoDelay), Http2NettyStreamClient.this._scheduler, (RateLimiter)new NoopRateLimiter(), this._idleTimeout, this._maxPoolWaiterSize);
        }
    }
}

