/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.internal.server.response;

import com.linkedin.data.DataMap;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.restli.common.HttpStatus;
import com.linkedin.restli.internal.server.RoutingResult;
import com.linkedin.restli.internal.server.methods.AnyRecord;
import com.linkedin.restli.internal.server.response.GetResponseEnvelope;
import com.linkedin.restli.internal.server.response.PartialRestResponse;
import com.linkedin.restli.internal.server.response.RestLiResponseBuilder;
import com.linkedin.restli.internal.server.response.RestLiResponseDataImpl;
import com.linkedin.restli.internal.server.util.RestUtils;
import com.linkedin.restli.server.GetResult;
import com.linkedin.restli.server.ResourceContext;
import com.linkedin.restli.server.RestLiResponseData;
import java.net.HttpCookie;
import java.util.List;
import java.util.Map;

public class GetResponseBuilder
implements RestLiResponseBuilder {
    @Override
    public PartialRestResponse buildResponse(RoutingResult routingResult, RestLiResponseData responseData) {
        return new PartialRestResponse.Builder().headers(responseData.getHeaders()).cookies(responseData.getCookies()).status(responseData.getStatus()).entity(responseData.getRecordResponseEnvelope().getRecord()).build();
    }

    @Override
    public RestLiResponseData buildRestLiResponseData(RestRequest request, RoutingResult routingResult, Object result, Map<String, String> headers, List<HttpCookie> cookies) {
        HttpStatus status;
        Object record;
        if (result instanceof GetResult) {
            GetResult getResult = (GetResult)result;
            record = getResult.getValue();
            status = getResult.getStatus();
        } else {
            record = (RecordTemplate)result;
            status = HttpStatus.S_200_OK;
        }
        ResourceContext resourceContext = routingResult.getContext();
        DataMap data = RestUtils.projectFields(record.data(), resourceContext.getProjectionMode(), resourceContext.getProjectionMask());
        RestLiResponseDataImpl responseData = new RestLiResponseDataImpl(status, headers, cookies);
        responseData.setResponseEnvelope(new GetResponseEnvelope(new AnyRecord(data), responseData));
        return responseData;
    }
}

