/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.writer;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import org.apache.gobblin.records.ControlMessageHandler;
import org.apache.gobblin.records.FlushControlMessageHandler;
import org.apache.gobblin.stream.RecordEnvelope;

public interface DataWriter<D>
extends Closeable,
Flushable {
    default public void write(D record) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void commit() throws IOException;

    public void cleanup() throws IOException;

    public long recordsWritten();

    public long bytesWritten() throws IOException;

    default public void writeEnvelope(RecordEnvelope<D> recordEnvelope) throws IOException {
        this.write(recordEnvelope.getRecord());
        recordEnvelope.ack();
    }

    default public ControlMessageHandler getMessageHandler() {
        return new FlushControlMessageHandler(this);
    }

    @Override
    default public void flush() throws IOException {
    }
}

