/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.internal.tools;

import com.linkedin.restli.restspec.ParameterSchema;

public class RestLiToolsUtils {
    public static String normalizeUnderscores(String name) {
        StringBuilder output = new StringBuilder();
        boolean capitalize = false;
        for (int i = 0; i < name.length(); ++i) {
            if (name.charAt(i) == '_') {
                capitalize = true;
                continue;
            }
            if (capitalize) {
                output.append(Character.toUpperCase(name.charAt(i)));
                capitalize = false;
                continue;
            }
            output.append(name.charAt(i));
        }
        return output.toString();
    }

    public static StringBuilder normalizeCaps(String name) {
        StringBuilder output = new StringBuilder();
        boolean boundary = true;
        for (int i = 0; i < name.length(); ++i) {
            boolean currentUpper = Character.isUpperCase(name.charAt(i));
            if (currentUpper) {
                if (i == 0) {
                    boundary = true;
                } else if (i == name.length() - 1) {
                    boundary = false;
                } else if (Character.isLowerCase(name.charAt(i - 1)) || Character.isLowerCase(name.charAt(i + 1))) {
                    boundary = true;
                }
            }
            if (boundary) {
                output.append(Character.toUpperCase(name.charAt(i)));
            } else {
                output.append(Character.toLowerCase(name.charAt(i)));
            }
            boundary = false;
        }
        return output;
    }

    public static StringBuilder normalizeName(String name) {
        return RestLiToolsUtils.normalizeCaps(name);
    }

    public static String nameCamelCase(String name) {
        StringBuilder builder = RestLiToolsUtils.normalizeName(name);
        char firstLower = Character.toLowerCase(builder.charAt(0));
        builder.setCharAt(0, firstLower);
        return builder.toString();
    }

    public static String nameCapsCase(String name) {
        return RestLiToolsUtils.normalizeName(name).toString();
    }

    public static boolean isParameterOptional(ParameterSchema param) {
        boolean optional = param.isOptional() == null ? false : param.isOptional();
        return optional || param.hasDefault();
    }
}

