/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.tools.idlcheck;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class CompatibilityInfo {
    private static final String _pathSeparator = "/";
    protected String _path;
    protected Type _type;
    protected Object[] _parameters;

    public CompatibilityInfo(List<Object> path, Type type) {
        this._path = StringUtils.join(path, (String)_pathSeparator);
        this._type = type;
    }

    public CompatibilityInfo(List<Object> path, Type type, Object ... parameters) {
        this(path, type);
        if (parameters.length > 0) {
            this._parameters = parameters;
        }
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 29).append((Object)this._type).append((Object)this._path).append(this._parameters).toHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CompatibilityInfo other = (CompatibilityInfo)obj;
        return new EqualsBuilder().append((Object)this._type, (Object)other._type).append((Object)this._path, (Object)other._path).append(this._parameters, other._parameters).isEquals();
    }

    public String toString() {
        StringBuilder output = new StringBuilder();
        if (!this._path.isEmpty()) {
            output.append(this._path).append(": ");
        }
        output.append(this._type.getDescription(this._parameters));
        return output.toString();
    }

    public static enum Type {
        FINDER_ASSOCKEYS_DOWNGRADE(Level.INCOMPATIBLE, "Finder AssocKeys may not be downgraded to AssocKey"),
        ANNOTATION_CHANGE_BREAKS_NEW_SERVER(Level.INCOMPATIBLE, "%s, breaks new servers"),
        ANNOTATION_CHANGE_BREAKS_OLD_CLIENT(Level.INCOMPATIBLE, "%s, old clients' requests will fail validation"),
        ANNOTATION_CHANGE_MAY_REQUIRE_CLIENT_CODE_CHANGE(Level.INCOMPATIBLE, "%s, clients may need to change their code"),
        ARRAY_NOT_CONTAIN(Level.INCOMPATIBLE, "Current field must contain these values: %s"),
        ARRAY_NOT_EQUAL(Level.INCOMPATIBLE, "Current field must be these values: %s"),
        ARRAY_MISSING_ELEMENT(Level.INCOMPATIBLE, "\"%s\" has been removed from the current field"),
        OTHER_ERROR(Level.INCOMPATIBLE, "%s"),
        PARAMETER_NEW_REQUIRED(Level.INCOMPATIBLE, "Unable to add the new required parameter \"%s\""),
        PARAMETER_WRONG_OPTIONALITY(Level.INCOMPATIBLE, "Unable to change the previous optional parameter to currently required"),
        RESOURCE_MISSING(Level.INCOMPATIBLE, "Resource for \"%s\" is not found. This endpoint will not be released. Please remove this file and build again"),
        TYPE_MISSING(Level.INCOMPATIBLE, "Type is required but missing"),
        TYPE_UNKNOWN(Level.INCOMPATIBLE, "Type cannot be resolved: %s"),
        VALUE_NOT_EQUAL(Level.INCOMPATIBLE, "Current value \"%2$s\" does not match the previous value \"%1$s\""),
        VALUE_WRONG_OPTIONALITY(Level.INCOMPATIBLE, "\"%s\" may not be removed because it exists in the previous version"),
        TYPE_BREAKS_OLD_READER(Level.INCOMPATIBLE, "%s, breaks old readers"),
        TYPE_BREAKS_NEW_READER(Level.INCOMPATIBLE, "%s, breaks new readers"),
        TYPE_BREAKS_NEW_AND_OLD_READERS(Level.INCOMPATIBLE, "%s, breaks new and old readers"),
        TYPE_ERROR(Level.INCOMPATIBLE, "%s"),
        DOC_NOT_EQUAL(Level.COMPATIBLE, "Documentation is updated"),
        ANNOTATIONS_CHANGED(Level.COMPATIBLE, "Annotation %s"),
        DEPRECATED(Level.COMPATIBLE, "%s is deprecated"),
        PARAMETER_NEW_OPTIONAL(Level.COMPATIBLE, "New optional parameter \"%s\" is added"),
        OPTIONAL_PARAMETER(Level.COMPATIBLE, "Previous required parameter is changed to currently optional"),
        OPTIONAL_VALUE(Level.COMPATIBLE, "Optional field \"%s\" was previously missing but currently present"),
        RESOURCE_NEW(Level.COMPATIBLE, "New resource is created in \"%s\""),
        SUPERSET(Level.COMPATIBLE, "Current values have these extra values: %s"),
        VALUE_DIFFERENT(Level.COMPATIBLE, "Previous value \"%s\" is changed to \"%s\""),
        TYPE_INFO(Level.COMPATIBLE, "%s"),
        PAGING_ADDED(Level.COMPATIBLE, "Method added paging support"),
        PAGING_REMOVED(Level.INCOMPATIBLE, "Method removed paging support");

        private Level _level;
        private String _description;

        public String getDescription(Object[] parameters) {
            return String.format(this._description, parameters);
        }

        public Level getLevel() {
            return this._level;
        }

        private Type(Level level, String description) {
            this._level = level;
            this._description = description;
        }
    }

    public static enum Level {
        INCOMPATIBLE,
        COMPATIBLE;

    }
}

