/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv.bean;

import com.opencsv.CSVReader;
import com.opencsv.bean.AbstractBeanField;
import com.opencsv.bean.BeanField;
import com.opencsv.bean.BeanFieldDate;
import com.opencsv.bean.BeanFieldPrimitiveTypes;
import com.opencsv.bean.CsvBind;
import com.opencsv.bean.CsvBindByPosition;
import com.opencsv.bean.CsvCustomBindByPosition;
import com.opencsv.bean.CsvDate;
import com.opencsv.bean.HeaderColumnNameMappingStrategy;
import com.opencsv.exceptions.CsvBadConverterException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class ColumnPositionMappingStrategy<T>
extends HeaderColumnNameMappingStrategy<T> {
    private String[] columnMapping = new String[0];
    private boolean columnsExplicitlySet = false;

    @Override
    public void captureHeader(CSVReader reader) throws IOException {
    }

    @Override
    public Integer getColumnIndex(String name) {
        return (Integer)this.indexLookup.get(name);
    }

    @Override
    public String getColumnName(int col) {
        return col < this.columnMapping.length ? this.columnMapping[col] : null;
    }

    public String[] getColumnMapping() {
        return (String[])this.columnMapping.clone();
    }

    public void setColumnMapping(String ... columnMapping) {
        this.columnMapping = columnMapping != null ? (String[])columnMapping.clone() : new String[]{};
        this.resetIndexMap();
        this.createIndexLookup(this.columnMapping);
        this.columnsExplicitlySet = true;
    }

    @Override
    public void setType(Class<? extends T> type) throws CsvBadConverterException {
        super.setType(type);
        if (!this.columnsExplicitlySet) {
            TreeMap<Integer, BeanField> cols = new TreeMap<Integer, BeanField>();
            for (BeanField beanField : this.fieldMap.values()) {
                if (beanField.getField().getAnnotation(CsvCustomBindByPosition.class) != null) {
                    cols.put(beanField.getField().getAnnotation(CsvCustomBindByPosition.class).position(), beanField);
                    continue;
                }
                if (beanField.getField().getAnnotation(CsvBindByPosition.class) == null) continue;
                cols.put(beanField.getField().getAnnotation(CsvBindByPosition.class).position(), beanField);
            }
            if (!cols.isEmpty()) {
                this.columnMapping = new String[(Integer)cols.lastKey() + 1];
                for (Map.Entry entry : cols.entrySet()) {
                    this.columnMapping[((Integer)entry.getKey()).intValue()] = ((BeanField)entry.getValue()).getField().getName().toUpperCase().trim();
                }
                this.resetIndexMap();
                this.createIndexLookup(this.columnMapping);
            } else {
                this.columnMapping = new String[0];
            }
        }
    }

    @Override
    protected void loadFieldMap() throws CsvBadConverterException {
        this.fieldMap = new HashMap();
        for (Field field : this.loadFields(this.getType())) {
            boolean required;
            String columnName;
            if (field.isAnnotationPresent(CsvCustomBindByPosition.class)) {
                BeanField bean;
                columnName = field.getName().toUpperCase().trim();
                Class<? extends AbstractBeanField> converter = field.getAnnotation(CsvCustomBindByPosition.class).converter();
                try {
                    bean = converter.newInstance();
                }
                catch (IllegalAccessException oldEx) {
                    CsvBadConverterException newEx = new CsvBadConverterException(converter, "There was a problem instantiating the custom converter " + converter.getCanonicalName());
                    newEx.initCause(oldEx);
                    throw newEx;
                }
                catch (InstantiationException oldEx) {
                    CsvBadConverterException newEx = new CsvBadConverterException(converter, "There was a problem instantiating the custom converter " + converter.getCanonicalName());
                    newEx.initCause(oldEx);
                    throw newEx;
                }
                bean.setField(field);
                this.fieldMap.put(columnName, bean);
                continue;
            }
            if (field.isAnnotationPresent(CsvBindByPosition.class)) {
                required = field.getAnnotation(CsvBindByPosition.class).required();
                columnName = field.getName().toUpperCase().trim();
                String locale = field.getAnnotation(CsvBindByPosition.class).locale();
                if (field.isAnnotationPresent(CsvDate.class)) {
                    String formatString = field.getAnnotation(CsvDate.class).value();
                    this.fieldMap.put(columnName, new BeanFieldDate(field, required, formatString, locale));
                    continue;
                }
                this.fieldMap.put(columnName, new BeanFieldPrimitiveTypes(field, required, locale));
                continue;
            }
            required = field.getAnnotation(CsvBind.class).required();
            columnName = field.getName().toUpperCase().trim();
            this.fieldMap.put(columnName, new BeanFieldPrimitiveTypes(field, required, null));
        }
    }

    private List<Field> loadFields(Class<? extends T> cls) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Field field : cls.getDeclaredFields()) {
            if (!field.isAnnotationPresent(CsvBindByPosition.class) && !field.isAnnotationPresent(CsvCustomBindByPosition.class) && !field.isAnnotationPresent(CsvBind.class)) continue;
            fields.add(field);
        }
        this.annotationDriven = !fields.isEmpty();
        return fields;
    }
}

