/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.servers;

import com.linkedin.common.callback.Callback;
import com.linkedin.common.util.None;
import com.linkedin.d2.balancer.LoadBalancerServer;
import com.linkedin.d2.balancer.properties.PartitionData;
import com.linkedin.d2.balancer.properties.UriProperties;
import com.linkedin.d2.discovery.event.PropertyEventThread;
import com.linkedin.d2.discovery.stores.zk.ZooKeeperEphemeralStore;
import com.linkedin.d2.discovery.util.LogUtil;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperServer
implements LoadBalancerServer {
    private static final Logger _log = LoggerFactory.getLogger(ZooKeeperServer.class);
    private volatile ZooKeeperEphemeralStore<UriProperties> _store;

    public ZooKeeperServer() {
    }

    public ZooKeeperServer(ZooKeeperEphemeralStore<UriProperties> store) {
        this._store = store;
    }

    @Override
    public void start(Callback<None> callback) {
        this._store.start(callback);
    }

    @Override
    public void shutdown(final Callback<None> callback) {
        this._store.shutdown(new PropertyEventThread.PropertyEventShutdownCallback(){

            @Override
            public void done() {
                callback.onSuccess((Object)None.none());
            }
        });
    }

    @Override
    public void markUp(String clusterName, URI uri, Map<Integer, PartitionData> partitionDataMap, Callback<None> callback) {
        this.markUp(clusterName, uri, partitionDataMap, Collections.emptyMap(), callback);
    }

    @Override
    public void markUp(final String clusterName, final URI uri, final Map<Integer, PartitionData> partitionDataMap, final Map<String, Object> uriSpecificProperties, final Callback<None> callback) {
        Callback<None> doPutCallback = new Callback<None>(){

            public void onSuccess(None none) {
                Map<URI, Map<String, Object>> myUriSpecificProperties;
                HashMap<URI, Map<Integer, PartitionData>> partitionDesc = new HashMap<URI, Map<Integer, PartitionData>>();
                partitionDesc.put(uri, partitionDataMap);
                if (uriSpecificProperties != null && !uriSpecificProperties.isEmpty()) {
                    myUriSpecificProperties = new HashMap();
                    myUriSpecificProperties.put(uri, uriSpecificProperties);
                } else {
                    myUriSpecificProperties = Collections.emptyMap();
                }
                if (_log.isInfoEnabled()) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(ZooKeeperServer.this._store);
                    sb.append(" marked up for cluster: ");
                    sb.append(clusterName);
                    sb.append(", uri: ");
                    sb.append(uri);
                    sb.append(", announcing [partitionId: weight]s: {");
                    Iterator iterator = partitionDataMap.keySet().iterator();
                    while (iterator.hasNext()) {
                        int partitionId = (Integer)iterator.next();
                        sb.append("[");
                        sb.append(partitionId);
                        sb.append(" : ");
                        sb.append(partitionDataMap.get(partitionId));
                        sb.append("]");
                    }
                    sb.append("}");
                    LogUtil.info(_log, sb);
                }
                ZooKeeperServer.this._store.put(clusterName, new UriProperties(clusterName, partitionDesc, myUriSpecificProperties), (Callback<None>)callback);
            }

            public void onError(Throwable e) {
                callback.onError(e);
            }
        };
        Callback<UriProperties> getCallback = new Callback<UriProperties>((Callback)doPutCallback, callback){
            final /* synthetic */ Callback val$doPutCallback;
            final /* synthetic */ Callback val$callback;
            {
                this.val$doPutCallback = callback;
                this.val$callback = callback2;
            }

            public void onSuccess(UriProperties uris) {
                if (uris != null && uris.Uris().contains(uri)) {
                    LogUtil.warn(_log, "markUp called on a uri that already exists in cluster ", clusterName, ": ", uri);
                    ZooKeeperServer.this.markDown(clusterName, uri, (Callback<None>)this.val$doPutCallback);
                } else {
                    this.val$doPutCallback.onSuccess((Object)None.none());
                }
            }

            public void onError(Throwable e) {
                this.val$callback.onError(e);
            }
        };
        this._store.get(clusterName, getCallback);
    }

    @Override
    public void markDown(final String clusterName, final URI uri, final Callback<None> callback) {
        Callback<UriProperties> getCallback = new Callback<UriProperties>(){

            public void onSuccess(UriProperties uris) {
                if (uris == null) {
                    LogUtil.warn(_log, "markDown called on a cluster that doesn't exist in zk: ", clusterName);
                    callback.onSuccess((Object)None.none());
                } else if (!uris.Uris().contains(uri)) {
                    LogUtil.warn(_log, "markDown called on a uri that doesn't exist in cluster ", clusterName, ": ", uri);
                    callback.onSuccess((Object)None.none());
                } else {
                    LogUtil.warn(_log, ZooKeeperServer.this._store, " marked down for cluster ", clusterName, "with uri: ", uri);
                    HashMap<URI, Map<Integer, PartitionData>> partitionData = new HashMap<URI, Map<Integer, PartitionData>>(2);
                    partitionData.put(uri, Collections.emptyMap());
                    ZooKeeperServer.this._store.removePartial(clusterName, new UriProperties(clusterName, partitionData), (Callback<None>)callback);
                }
            }

            public void onError(Throwable e) {
                callback.onError(e);
            }
        };
        this._store.get(clusterName, getCallback);
    }

    public void setStore(ZooKeeperEphemeralStore<UriProperties> store) {
        this._store = store;
        LogUtil.info(_log, "store set to new store: ", this._store);
    }

    public void shutdown() {
        LogUtil.info(_log, "shutting down zk server");
        final CountDownLatch latch = new CountDownLatch(1);
        this._store.shutdown(new PropertyEventThread.PropertyEventShutdownCallback(){

            @Override
            public void done() {
                latch.countDown();
            }
        });
        try {
            if (!latch.await(5L, TimeUnit.SECONDS)) {
                LogUtil.warn(_log, "unable to shut down propertly");
            } else {
                LogUtil.info(_log, "shutting down complete");
            }
        }
        catch (InterruptedException e) {
            LogUtil.warn(_log, "unable to shut down propertly.. got interrupt exception while waiting");
        }
    }
}

