/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.util.hashing;

import com.linkedin.d2.balancer.util.hashing.ConsistentHashRing;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class ConsistentHashRingIterator<T>
implements Iterator<T> {
    private final List<ConsistentHashRing.Point<T>> _points;
    private int _iterated;
    private int _index;

    public ConsistentHashRingIterator(List<ConsistentHashRing.Point<T>> objects, int from) {
        this._points = objects;
        this._iterated = 0;
        this._index = from;
    }

    @Override
    public boolean hasNext() {
        return this._iterated < this._points.size();
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        T result = this._points.get(this._index).getT();
        this._index = (this._index + 1) % this._points.size();
        ++this._iterated;
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

