/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.util.partitions;

import com.linkedin.d2.balancer.properties.HashBasedPartitionProperties;
import com.linkedin.d2.balancer.properties.PartitionProperties;
import com.linkedin.d2.balancer.properties.RangeBasedPartitionProperties;
import com.linkedin.d2.balancer.util.partitions.DefaultPartitionAccessor;
import com.linkedin.d2.balancer.util.partitions.HashBasedPartitionAccessor;
import com.linkedin.d2.balancer.util.partitions.PartitionAccessor;
import com.linkedin.d2.balancer.util.partitions.RangeBasedPartitionAccessor;

public class PartitionAccessorFactory {
    public static PartitionAccessor getPartitionAccessor(PartitionProperties properties) {
        switch (properties.getPartitionType()) {
            case RANGE: {
                return new RangeBasedPartitionAccessor((RangeBasedPartitionProperties)properties);
            }
            case HASH: {
                return new HashBasedPartitionAccessor((HashBasedPartitionProperties)properties);
            }
            case NONE: {
                return DefaultPartitionAccessor.getInstance();
            }
        }
        throw new IllegalArgumentException("Unsupported partition properties type.");
    }
}

